/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SafeFileOutputStream
extends OutputStream {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.SafeFileOutputStream");
    private static final String EXTENSION_BAK = "___jb_bak___";
    private static final String EXTENSION_OLD = "___jb_old___";
    private final File myTargetFile;
    private final boolean myPreserveAttributes;
    private final File myBackupFile;
    private final OutputStream myBackupStream;
    private boolean myFailed = false;

    public SafeFileOutputStream(File target) throws FileNotFoundException {
        this(target, false);
    }

    public SafeFileOutputStream(File target, boolean preserveAttributes) throws FileNotFoundException {
        this.myTargetFile = target;
        this.myPreserveAttributes = preserveAttributes;
        this.myBackupFile = new File(this.myTargetFile.getParentFile(), this.myTargetFile.getName() + EXTENSION_BAK);
        this.myBackupStream = new FileOutputStream(this.myBackupFile);
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.myBackupStream.write(b);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.myBackupStream.write(b);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.myBackupStream.write(b, off, len);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myBackupStream.flush();
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.myBackupStream.close();
        }
        catch (IOException e) {
            LOG.warn(e);
            FileUtil.delete(this.myBackupFile);
            throw e;
        }
        if (this.myFailed) {
            throw new IOException(CommonBundle.message("safe.write.failed", this.myTargetFile, this.myBackupFile.getName()));
        }
        File oldFile = new File(this.myTargetFile.getParent(), this.myTargetFile.getName() + EXTENSION_OLD);
        try {
            FileUtil.rename(this.myTargetFile, oldFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.original", this.myTargetFile, this.myBackupFile.getName()));
        }
        try {
            FileUtil.rename(this.myBackupFile, this.myTargetFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.backup", this.myTargetFile, oldFile.getName(), this.myBackupFile.getName()));
        }
        if (this.myPreserveAttributes) {
            FileSystemUtil.clonePermissions(oldFile.getPath(), this.myTargetFile.getPath());
        }
        if (!FileUtil.delete(oldFile)) {
            throw new IOException(CommonBundle.message("safe.write.drop.temp", oldFile));
        }
    }
}

