/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XmlTagNamesIndex;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlNamespaceHelper
extends XmlNamespaceHelper {
    private static final Logger LOG = Logger.getInstance(DefaultXmlNamespaceHelper.class);

    @Override
    protected boolean isAvailable(PsiFile file) {
        return true;
    }

    @Override
    public void insertNamespaceDeclaration(@NotNull XmlFile file, @Nullable Editor editor, @NotNull Set<String> possibleNamespaces, @Nullable String nsPrefix, @Nullable XmlNamespaceHelper.Runner<String, IncorrectOperationException> runAfter) throws IncorrectOperationException {
        XmlAttribute xmlAttribute;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/DefaultXmlNamespaceHelper", "insertNamespaceDeclaration"));
        }
        if (possibleNamespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleNamespaces", "com/intellij/xml/DefaultXmlNamespaceHelper", "insertNamespaceDeclaration"));
        }
        String namespace = possibleNamespaces.iterator().next();
        Project project = file.getProject();
        XmlTag rootTag = file.getRootTag();
        assert (rootTag != null);
        XmlAttribute anchor = DefaultXmlNamespaceHelper.getAnchor(rootTag);
        List<XmlSchemaProvider> providers = XmlSchemaProvider.getAvailableProviders(file);
        String prefix = DefaultXmlNamespaceHelper.getPrefix(file, nsPrefix, namespace, providers);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance(project);
        String location = DefaultXmlNamespaceHelper.getLocation(file, namespace, providers);
        String xsiPrefix = null;
        if (location != null && (xsiPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = "xsi";
            rootTag.add(elementFactory.createXmlAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        }
        String qname = "xmlns" + (prefix.length() > 0 ? ":" + prefix : "");
        XmlAttribute attribute = elementFactory.createXmlAttribute(qname, namespace);
        if (anchor == null) {
            rootTag.add(attribute);
        } else {
            rootTag.addAfter(attribute, anchor);
        }
        if (location != null) {
            XmlAttribute locationAttribute = rootTag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
            String pair = namespace + " " + location;
            if (locationAttribute == null) {
                locationAttribute = elementFactory.createXmlAttribute(xsiPrefix + ":" + "schemaLocation", pair);
                rootTag.add(locationAttribute);
            } else {
                String value = locationAttribute.getValue();
                if (!StringUtil.notNullize(value).contains(namespace)) {
                    if (value == null || StringUtil.isEmptyOrSpaces(value)) {
                        locationAttribute.setValue(pair);
                    } else {
                        locationAttribute.setValue(value.trim() + " " + pair);
                    }
                }
            }
        }
        XmlUtil.reformatTagStart(rootTag);
        if (editor != null && namespace.length() == 0 && (xmlAttribute = rootTag.getAttribute(qname)) != null) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            assert (value != null);
            int startOffset = value.getTextOffset();
            editor.getCaretModel().moveToOffset(startOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        if (runAfter != null) {
            runAfter.run(prefix);
        }
    }

    private static String getPrefix(XmlFile file, String nsPrefix, String namespace, List<XmlSchemaProvider> providers) {
        String prefix = nsPrefix;
        if (prefix == null) {
            XmlSchemaProvider provider;
            Iterator<XmlSchemaProvider> iterator = providers.iterator();
            while (iterator.hasNext() && (prefix = (provider = iterator.next()).getDefaultPrefix(namespace, file)) == null) {
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    private static XmlAttribute getAnchor(XmlTag rootTag) {
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute anchor = null;
        for (XmlAttribute attribute : attributes) {
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (!attribute.isNamespaceDeclaration() && (descriptor == null || !descriptor.isRequired())) break;
            anchor = attribute;
        }
        return anchor;
    }

    private static String getLocation(XmlFile file, String namespace, List<XmlSchemaProvider> providers) {
        String location = null;
        if (namespace.length() > 0) {
            for (XmlSchemaProvider provider : providers) {
                Set<String> locations = provider.getLocations(namespace, file);
                if (locations == null || locations.isEmpty()) continue;
                location = locations.iterator().next();
            }
        }
        return location;
    }

    @Override
    @NotNull
    public Set<String> guessUnboundNamespaces(@NotNull PsiElement element, @NotNull XmlFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/DefaultXmlNamespaceHelper", "guessUnboundNamespaces"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/DefaultXmlNamespaceHelper", "guessUnboundNamespaces"));
        }
        if (!(element instanceof XmlTag)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/DefaultXmlNamespaceHelper", "guessUnboundNamespaces"));
            }
            return set;
        }
        XmlTag tag = (XmlTag)element;
        String name = tag.getLocalName();
        Set<String> byTagName = this.getNamespacesByTagName(name, file);
        if (!byTagName.isEmpty()) {
            HashSet<String> filtered = new HashSet<String>(byTagName);
            filtered.removeAll(Arrays.asList(tag.knownNamespaces()));
            HashSet<String> hashSet = filtered;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/DefaultXmlNamespaceHelper", "guessUnboundNamespaces"));
            }
            return hashSet;
        }
        Set<String> set = DefaultXmlNamespaceHelper.guessNamespace(file, name);
        set.removeAll(Arrays.asList(tag.knownNamespaces()));
        XmlTag parentTag = tag.getParentTag();
        Iterator<String> i = set.iterator();
        block0: while (i.hasNext()) {
            String s = i.next();
            Collection<XmlFile> namespaces = XmlUtil.findNSFilesByURI(s, element.getProject(), ModuleUtilCore.findModuleForPsiElement(file));
            for (XmlFile namespace : namespaces) {
                XmlElementDescriptor[] descriptors;
                XmlDocument document = namespace.getDocument();
                assert (document != null);
                XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
                assert (nsDescriptor != null);
                if (parentTag != null) continue block0;
                for (XmlElementDescriptor descriptor : descriptors = nsDescriptor.getRootElementsDescriptors(document)) {
                    if (descriptor == null) {
                        LOG.error(nsDescriptor + " returned null element for getRootElementsDescriptors() array");
                        continue;
                    }
                    if (descriptor.getName().equals(name)) continue block0;
                }
            }
            i.remove();
        }
        Set<String> set2 = set;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/DefaultXmlNamespaceHelper", "guessUnboundNamespaces"));
        }
        return set2;
    }

    private static Set<String> guessNamespace(PsiFile file, String tagName) {
        Project project = file.getProject();
        Collection<VirtualFile> files = XmlTagNamesIndex.getFilesByTagName(tagName, project);
        LinkedHashSet<String> possibleUris = new LinkedHashSet<String>(files.size());
        for (VirtualFile virtualFile : files) {
            String namespace = XmlNamespaceIndex.getNamespace(virtualFile, project, file);
            if (namespace == null) continue;
            possibleUris.add(namespace);
        }
        return possibleUris;
    }

    @Override
    @NotNull
    public Set<String> getNamespacesByTagName(@NotNull String tagName, @NotNull XmlFile context) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/xml/DefaultXmlNamespaceHelper", "getNamespacesByTagName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/DefaultXmlNamespaceHelper", "getNamespacesByTagName"));
        }
        List<XmlSchemaProvider> providers = XmlSchemaProvider.getAvailableProviders(context);
        HashSet<String> set = new HashSet<String>();
        for (XmlSchemaProvider provider : providers) {
            set.addAll(provider.getAvailableNamespaces(context, tagName));
        }
        HashSet<String> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/DefaultXmlNamespaceHelper", "getNamespacesByTagName"));
        }
        return hashSet;
    }
}

