/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WhitespacesBinders {
    public static final WhitespacesAndCommentsBinder DEFAULT_RIGHT_BINDER = new WhitespacesAndCommentsBinder(){

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return 0;
        }
    };
    public static final WhitespacesAndCommentsBinder DEFAULT_LEFT_BINDER = new WhitespacesAndCommentsBinder(){

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return tokens.size();
        }
    };
    public static final WhitespacesAndCommentsBinder GREEDY_LEFT_BINDER = DEFAULT_RIGHT_BINDER;
    public static final WhitespacesAndCommentsBinder GREEDY_RIGHT_BINDER = DEFAULT_LEFT_BINDER;

    public static WhitespacesAndCommentsBinder leadingCommentsBinder(@NotNull Condition<IElementType> isCommentCondition) {
        if (isCommentCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isCommentCondition", "com/intellij/lang/WhitespacesBinders", "leadingCommentsBinder"));
        }
        return new LeadingCommentsBinder(isCommentCondition);
    }

    public static WhitespacesAndCommentsBinder leadingCommentsBinder(IElementType ... commentTypes) {
        return WhitespacesBinders.leadingCommentsBinder(TokenSet.create(commentTypes));
    }

    public static WhitespacesAndCommentsBinder leadingCommentsBinder(final @NotNull TokenSet commentTypes) {
        if (commentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentTypes", "com/intellij/lang/WhitespacesBinders", "leadingCommentsBinder"));
        }
        return WhitespacesBinders.leadingCommentsBinder(new Condition<IElementType>(){

            @Override
            public boolean value(IElementType type) {
                return commentTypes.contains(type);
            }
        });
    }

    private WhitespacesBinders() {
    }

    private static class LeadingCommentsBinder
    implements WhitespacesAndCommentsBinder {
        @NotNull
        private final Condition<IElementType> myIsCommentCondition;

        LeadingCommentsBinder(@NotNull Condition<IElementType> isCommentCondition) {
            if (isCommentCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isCommentCondition", "com/intellij/lang/WhitespacesBinders$LeadingCommentsBinder", "<init>"));
            }
            this.myIsCommentCondition = isCommentCondition;
        }

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            int i;
            for (i = 0; i < tokens.size() && !this.myIsCommentCondition.value(tokens.get(i)); ++i) {
            }
            return i;
        }
    }
}

