/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;

public abstract class RootProviderBaseImpl
implements RootProvider {
    private final EventDispatcher<RootProvider.RootSetChangedListener> myDispatcher = EventDispatcher.create(RootProvider.RootSetChangedListener.class);

    @Override
    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "addRootSetChangedListener"));
        }
        this.myDispatcher.addListener(listener);
    }

    @Override
    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "removeRootSetChangedListener"));
        }
        this.myDispatcher.removeListener(listener);
    }

    @Override
    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "addRootSetChangedListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/roots/impl/RootProviderBaseImpl", "addRootSetChangedListener"));
        }
        this.myDispatcher.addListener(listener, parentDisposable);
    }

    public void fireRootSetChanged() {
        this.myDispatcher.getMulticaster().rootSetChanged(this);
    }
}

