/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.ManualRangeMarker;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectFunction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkerCache {
    private final SmartPointerManagerImpl.FilePointersList myPointers;
    private final VirtualFile myVirtualFile;
    private volatile Trinity<Integer, TLongObjectHashMap<ManualRangeMarker>, FrozenDocument> myUpdatedRanges;

    MarkerCache(SmartPointerManagerImpl.FilePointersList pointers, VirtualFile virtualFile) {
        this.myPointers = pointers;
        this.myVirtualFile = virtualFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLongObjectHashMap<ManualRangeMarker> getUpdatedMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedMarkers"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedMarkers"));
        }
        int eventCount = events.size();
        assert (eventCount > 0);
        Trinity<Integer, TLongObjectHashMap<ManualRangeMarker>, FrozenDocument> cache = this.myUpdatedRanges;
        if (cache != null && (Integer)cache.first == eventCount) {
            return (TLongObjectHashMap)cache.second;
        }
        MarkerCache markerCache = this;
        synchronized (markerCache) {
            TLongObjectHashMap answer;
            cache = this.myUpdatedRanges;
            if (cache != null && (Integer)cache.first == eventCount) {
                return (TLongObjectHashMap)cache.second;
            }
            if (cache != null && (Integer)cache.first < eventCount) {
                answer = ((TLongObjectHashMap)cache.second).clone();
                frozen = MarkerCache.applyEvents((FrozenDocument)cache.third, events.subList((Integer)cache.first, eventCount), (TLongObjectHashMap<ManualRangeMarker>)answer);
            } else {
                List<SelfElementInfo> infos = this.getInfos();
                answer = new TLongObjectHashMap(infos.size());
                for (SelfElementInfo info : infos) {
                    boolean forInjected;
                    ProperTextRange range = info.getPsiRange();
                    long key = info.markerCacheKey();
                    if (range == null || key == 0L) continue;
                    answer.put(key, (Object)new ManualRangeMarker(frozen, range, forInjected, forInjected, !(forInjected = info.isForInjected())));
                }
                frozen = MarkerCache.applyEvents(frozen, events, (TLongObjectHashMap<ManualRangeMarker>)answer);
            }
            this.myUpdatedRanges = Trinity.create(eventCount, answer, frozen);
            return answer;
        }
    }

    private static FrozenDocument applyEvents(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events, TLongObjectHashMap<ManualRangeMarker> map) {
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "applyEvents"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "applyEvents"));
        }
        for (DocumentEvent event : events) {
            DocumentEventImpl corrected;
            if (event instanceof RetargetRangeMarkers) {
                RetargetRangeMarkers retarget = (RetargetRangeMarkers)event;
                corrected = new RetargetRangeMarkers(frozen, retarget.getStartOffset(), retarget.getEndOffset(), retarget.getMoveDestinationOffset());
            } else {
                frozen = frozen.applyEvent(event, 0);
                corrected = new DocumentEventImpl(frozen, event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), event.isWholeTextReplaced(), ((DocumentEventImpl)event).getInitialStartOffset(), ((DocumentEventImpl)event).getInitialOldLength());
            }
            map.transformValues((TObjectFunction)new TObjectFunction<ManualRangeMarker, ManualRangeMarker>(){

                public ManualRangeMarker execute(ManualRangeMarker currentRange) {
                    return currentRange == null ? null : currentRange.getUpdatedRange(corrected);
                }
            });
        }
        return frozen;
    }

    synchronized void updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "updateMarkers"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "updateMarkers"));
        }
        TLongObjectHashMap<ManualRangeMarker> updated = this.getUpdatedMarkers(frozen, events);
        for (SelfElementInfo info : this.getInfos()) {
            long key = info.markerCacheKey();
            if (key == 0L) continue;
            ManualRangeMarker newRangeMarker = (ManualRangeMarker)updated.get(key);
            info.setRange(newRangeMarker == null ? null : newRangeMarker.getRange());
        }
        this.myUpdatedRanges = null;
    }

    @NotNull
    private List<SelfElementInfo> getInfos() {
        List<SelfElementInfo> list = ContainerUtil.findAll(ContainerUtil.map(this.myPointers.getAlivePointers(), new NullableFunction<SmartPsiElementPointerImpl, SmartPointerElementInfo>(){

            @Override
            public SmartPointerElementInfo fun(SmartPsiElementPointerImpl pointer) {
                return pointer.getElementInfo();
            }
        }), SelfElementInfo.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/MarkerCache", "getInfos"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    ProperTextRange getUpdatedRange(long rangeKey, @NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> list) {
        void events;
        if (frozen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frozen", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/smartPointers/MarkerCache", "getUpdatedRange"));
        }
        ManualRangeMarker updated = (ManualRangeMarker)this.getUpdatedMarkers(frozen, (List<DocumentEvent>)events).get(rangeKey);
        return updated == null ? null : updated.getRange();
    }

    synchronized void rangeChanged(long rangeKey) {
        if (this.myUpdatedRanges != null && !((TLongObjectHashMap)this.myUpdatedRanges.second).contains(rangeKey)) {
            this.myUpdatedRanges = null;
        }
    }

    VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }
}

