/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.HFinal;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class BytecodeAnalysisIndex
extends FileBasedIndexExtension<Bytes, HEquations> {
    public static final ID<Bytes, HEquations> NAME = ID.create("bytecodeAnalysis");
    private final HEquationsExternalizer myExternalizer = new HEquationsExternalizer();
    private static final ClassDataIndexer INDEXER = new ClassDataIndexer();
    private static final HKeyDescriptor KEY_DESCRIPTOR = new HKeyDescriptor();
    private static final int ourInternalVersion = 6;
    private static final boolean ourEnabled = SystemProperties.getBooleanProperty("idea.enable.bytecode.contract.inference", true);

    @Override
    @NotNull
    public ID<Bytes, HEquations> getName() {
        ID<Bytes, HEquations> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<Bytes, HEquations, FileContent> getIndexer() {
        ClassDataIndexer classDataIndexer = INDEXER;
        if (classDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getIndexer"));
        }
        return classDataIndexer;
    }

    @Override
    @NotNull
    public KeyDescriptor<Bytes> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = KEY_DESCRIPTOR;
        if (hKeyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getKeyDescriptor"));
        }
        return hKeyDescriptor;
    }

    @Override
    @NotNull
    public DataExternalizer<HEquations> getValueExternalizer() {
        HEquationsExternalizer hEquationsExternalizer = this.myExternalizer;
        if (hEquationsExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getValueExternalizer"));
        }
        return hEquationsExternalizer;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

            @Override
            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$1", "acceptInput"));
                }
                return ourEnabled && super.acceptInput(file);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 6 + (ourEnabled ? 255 : 0);
    }

    public static class HEquationsExternalizer
    implements DataExternalizer<HEquations>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        @Override
        public void save(@NotNull DataOutput out, HEquations eqs) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "save"));
            }
            out.writeBoolean(eqs.stable);
            DataInputOutputUtil.writeINT(out, eqs.results.size());
            for (DirectionResultPair pair : eqs.results) {
                DataInputOutputUtil.writeINT(out, pair.directionKey);
                HResult rhs = pair.hResult;
                if (rhs instanceof HFinal) {
                    HFinal finalResult = (HFinal)rhs;
                    out.writeBoolean(true);
                    DataInputOutputUtil.writeINT(out, finalResult.value.ordinal());
                    continue;
                }
                HPending pendResult = (HPending)rhs;
                out.writeBoolean(false);
                DataInputOutputUtil.writeINT(out, pendResult.delta.length);
                for (HComponent component : pendResult.delta) {
                    DataInputOutputUtil.writeINT(out, component.value.ordinal());
                    HKey[] ids = component.ids;
                    DataInputOutputUtil.writeINT(out, ids.length);
                    for (HKey hKey : ids) {
                        out.write(hKey.key);
                        int rawDirKey = hKey.negated ? -hKey.dirKey : hKey.dirKey;
                        DataInputOutputUtil.writeINT(out, rawDirKey);
                        out.writeBoolean(hKey.stable);
                    }
                }
            }
        }

        @Override
        public HEquations read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "read"));
            }
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT(in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT(in);
                boolean isFinal = in.readBoolean();
                if (isFinal) {
                    int ordinal = DataInputOutputUtil.readINT(in);
                    Value value = Value.values()[ordinal];
                    results.add(new DirectionResultPair(directionKey, new HFinal(value)));
                    continue;
                }
                int sumLength = DataInputOutputUtil.readINT(in);
                HComponent[] components = new HComponent[sumLength];
                for (int i = 0; i < sumLength; ++i) {
                    int ordinal = DataInputOutputUtil.readINT(in);
                    Value value = Value.values()[ordinal];
                    int componentSize = DataInputOutputUtil.readINT(in);
                    HKey[] ids = new HKey[componentSize];
                    for (int j = 0; j < componentSize; ++j) {
                        byte[] bytes = new byte[14];
                        for (int bi = 0; bi < bytes.length; ++bi) {
                            bytes[bi] = in.readByte();
                        }
                        int rawDirKey = DataInputOutputUtil.readINT(in);
                        ids[j] = new HKey(bytes, Math.abs(rawDirKey), in.readBoolean(), rawDirKey < 0);
                    }
                    components[i] = new HComponent(value, ids);
                }
                results.add(new DirectionResultPair(directionKey, new HPending(components)));
            }
            return new HEquations(results, stable);
        }
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<Bytes>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private HKeyDescriptor() {
        }

        @Override
        public void save(@NotNull DataOutput out, Bytes value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "save"));
            }
            out.write(value.bytes);
        }

        @Override
        public Bytes read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "read"));
            }
            byte[] bytes = new byte[14];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = in.readByte();
            }
            return new Bytes(bytes);
        }

        @Override
        public int getHashCode(Bytes value) {
            return Arrays.hashCode(value.bytes);
        }

        @Override
        public boolean isEqual(Bytes val1, Bytes val2) {
            return Arrays.equals(val1.bytes, val2.bytes);
        }
    }
}

