/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import org.jetbrains.annotations.NotNull;

public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    public static final LanguageSubstitutors INSTANCE = new LanguageSubstitutors();

    private LanguageSubstitutors() {
        super("com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language lang, @NotNull VirtualFile file, @NotNull Project project) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        for (LanguageSubstitutor substitutor : this.forKey(lang)) {
            Language language = substitutor.getLanguage(file, project);
            if (language == null) continue;
            Language language2 = language;
            if (language2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
            }
            return language2;
        }
        Language language = lang;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        return language;
    }
}

