/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nullable;

public abstract class XsdEnumerationDescriptor<T extends XmlElement>
extends XmlEnumerationDescriptor<T> {
    private boolean myExhaustiveEnum;

    public abstract XmlTag getDeclaration();

    @Override
    public String getDefaultValue() {
        if (this.isFixed()) {
            return this.getDeclaration().getAttributeValue("fixed");
        }
        return this.getDeclaration().getAttributeValue("default");
    }

    @Override
    public boolean isFixed() {
        return this.getDeclaration().getAttributeValue("fixed") != null;
    }

    @Override
    public String[] getEnumeratedValues() {
        return this.getEnumeratedValues(false);
    }

    @Override
    public String[] getValuesForCompletion() {
        return this.getEnumeratedValues(true);
    }

    private String[] getEnumeratedValues(boolean forCompletion) {
        final SmartList<String> list = new SmartList<String>();
        this.processEnumeration(null, new PairProcessor<PsiElement, String>(){

            @Override
            public boolean process(PsiElement element, String s) {
                list.add(s);
                return true;
            }
        }, forCompletion);
        String defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            list.add(defaultValue);
        }
        return ArrayUtil.toStringArray(list);
    }

    private boolean processEnumeration(XmlElement context, PairProcessor<PsiElement, String> processor, boolean forCompletion) {
        XmlTag contextTag = context != null ? PsiTreeUtil.getContextOfType((PsiElement)context, XmlTag.class, false) : null;
        XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType(this.getDeclaration(), contextTag);
        if (elementDescriptor != null && elementDescriptor.getType() instanceof ComplexTypeDescriptor) {
            return this.processEnumerationImpl(((ComplexTypeDescriptor)elementDescriptor.getType()).getDeclaration(), processor, forCompletion);
        }
        String namespacePrefix = this.getDeclaration().getNamespacePrefix();
        XmlTag type = this.getDeclaration().findFirstSubTag((namespacePrefix.length() > 0 ? namespacePrefix + ":" : "") + "simpleType");
        if (type != null) {
            return this.processEnumerationImpl(type, processor, forCompletion);
        }
        return false;
    }

    private boolean processEnumerationImpl(XmlTag declaration, final PairProcessor<PsiElement, String> pairProcessor, boolean forCompletion) {
        XmlAttribute name = declaration.getAttribute("name");
        if (name != null && "boolean".equals(name.getValue())) {
            XmlAttributeValue valueElement = name.getValueElement();
            pairProcessor.process(valueElement, "true");
            pairProcessor.process(valueElement, "false");
            if (!forCompletion) {
                pairProcessor.process(valueElement, "1");
                pairProcessor.process(valueElement, "0");
            }
            this.myExhaustiveEnum = true;
            return true;
        }
        final Ref<Boolean> found = new Ref<Boolean>(Boolean.FALSE);
        this.myExhaustiveEnum = XmlUtil.processEnumerationValues(declaration, new Processor<XmlTag>(){

            @Override
            public boolean process(XmlTag tag) {
                found.set(Boolean.TRUE);
                XmlAttribute name = tag.getAttribute("value");
                return name == null || pairProcessor.process(tag, name.getValue());
            }
        });
        return found.get();
    }

    @Override
    public PsiElement getValueDeclaration(XmlElement attributeValue, String value) {
        PsiElement declaration = super.getValueDeclaration(attributeValue, value);
        if (declaration == null && !this.myExhaustiveEnum) {
            return this.getDeclaration();
        }
        return declaration;
    }

    @Override
    public boolean isEnumerated(@Nullable XmlElement context) {
        return this.processEnumeration(context, PairProcessor.TRUE, false);
    }

    @Override
    public PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, final String value) {
        final Ref result = new Ref();
        this.processEnumeration(this.getDeclaration(), new PairProcessor<PsiElement, String>(){

            @Override
            public boolean process(PsiElement element, String s) {
                if (value.equals(s)) {
                    result.set(element);
                    return false;
                }
                return true;
            }
        }, false);
        return (PsiElement)result.get();
    }

    @Override
    protected PsiElement getDefaultValueDeclaration() {
        return this.getDeclaration();
    }
}

