/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TooBroadThrowsInspectionBase
extends BaseInspection {
    public boolean onlyWarnOnRootExceptions = false;
    public boolean ignoreInTestCode = false;
    public boolean ignoreLibraryOverrides = false;
    public boolean ignoreThrown = false;

    @Override
    @NotNull
    public String getID() {
        if ("OverlyBroadThrowsClause" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase", "getID"));
        }
        return "OverlyBroadThrowsClause";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.broad.throws.clause.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typesMaskedString;
        List typesMasked = (List)infos[0];
        PsiType type = ((SmartTypePointer)typesMasked.get(0)).getType();
        String string = typesMaskedString = type != null ? type.getPresentableText() : "";
        if (typesMasked.size() == 1) {
            String string2 = InspectionGadgetsBundle.message("overly.broad.throws.clause.problem.descriptor1", typesMaskedString);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase", "buildErrorString"));
            }
            return string2;
        }
        int lastTypeIndex = typesMasked.size() - 1;
        for (int i = 1; i < lastTypeIndex; ++i) {
            PsiType psiType = ((SmartTypePointer)typesMasked.get(i)).getType();
            if (psiType == null) continue;
            typesMaskedString = typesMaskedString + ", ";
            typesMaskedString = typesMaskedString + psiType.getPresentableText();
        }
        PsiType psiType = ((SmartTypePointer)typesMasked.get(lastTypeIndex)).getType();
        String lastTypeString = psiType != null ? psiType.getPresentableText() : "";
        String string3 = InspectionGadgetsBundle.message("overly.broad.throws.clause.problem.descriptor2", typesMaskedString, lastTypeString);
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase", "buildErrorString"));
        }
        return string3;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("too.broad.catch.option", new Object[0]), "onlyWarnOnRootExceptions");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.exceptions.declared.on.library.override.option", new Object[0]), "ignoreLibraryOverrides");
        panel.addCheckbox(InspectionGadgetsBundle.message("overly.broad.throws.clause.ignore.thrown.option", new Object[0]), "ignoreThrown");
        return panel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Collection maskedExceptions = (Collection)infos[0];
        Boolean originalNeeded = (Boolean)infos[1];
        AddThrowsClauseFix addThrowsClauseFix = new AddThrowsClauseFix(maskedExceptions, originalNeeded);
        if (addThrowsClauseFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase", "buildFix"));
        }
        return addThrowsClauseFix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadThrowsVisitor();
    }

    private class TooBroadThrowsVisitor
    extends BaseInspectionVisitor {
        private TooBroadThrowsVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiReferenceList throwsList = method.getThrowsList();
            if (!throwsList.isPhysical()) {
                return;
            }
            PsiJavaCodeReferenceElement[] throwsReferences = throwsList.getReferenceElements();
            if (throwsReferences.length == 0) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (TooBroadThrowsInspectionBase.this.ignoreLibraryOverrides && LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            Set<PsiType> exceptionsThrown = ExceptionUtils.calculateExceptionsThrown(body);
            PsiClassType[] referencedExceptions = throwsList.getReferencedTypes();
            HashSet exceptionsDeclared = new HashSet(referencedExceptions.length);
            ContainerUtil.addAll(exceptionsDeclared, referencedExceptions);
            int referencedExceptionsLength = referencedExceptions.length;
            for (int i = 0; i < referencedExceptionsLength; ++i) {
                PsiClassType referencedException = referencedExceptions[i];
                if (TooBroadThrowsInspectionBase.this.onlyWarnOnRootExceptions && !ExceptionUtils.isGenericExceptionClass(referencedException)) continue;
                ArrayList<SmartTypePointer> exceptionsMasked = new ArrayList<SmartTypePointer>();
                SmartTypePointerManager pointerManager = SmartTypePointerManager.getInstance(body.getProject());
                for (PsiType exceptionThrown : exceptionsThrown) {
                    if (!referencedException.isAssignableFrom(exceptionThrown) || exceptionsDeclared.contains(exceptionThrown)) continue;
                    exceptionsMasked.add(pointerManager.createSmartTypePointer(exceptionThrown));
                }
                if (exceptionsMasked.isEmpty()) continue;
                PsiJavaCodeReferenceElement throwsReference = throwsReferences[i];
                boolean originalNeeded = exceptionsThrown.contains(referencedException);
                if (TooBroadThrowsInspectionBase.this.ignoreThrown && originalNeeded) continue;
                this.registerError((PsiElement)throwsReference, exceptionsMasked, originalNeeded, throwsReference);
            }
        }
    }

    private static class AddThrowsClauseFix
    extends InspectionGadgetsFix {
        private final Collection<SmartTypePointer> types;
        private final boolean originalNeeded;

        AddThrowsClauseFix(Collection<SmartTypePointer> types, boolean originalNeeded) {
            this.types = types;
            this.originalNeeded = originalNeeded;
        }

        @Override
        @NotNull
        public String getName() {
            if (this.originalNeeded) {
                String string = InspectionGadgetsBundle.message("overly.broad.throws.clause.quickfix1", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase$AddThrowsClauseFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("overly.broad.throws.clause.quickfix2", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase$AddThrowsClauseFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Fix 'throws' clause" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadThrowsInspectionBase$AddThrowsClauseFix", "getFamilyName"));
            }
            return "Fix 'throws' clause";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)parent;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            if (!this.originalNeeded) {
                element.delete();
            }
            for (SmartTypePointer type : this.types) {
                PsiType psiType = type.getType();
                if (!(psiType instanceof PsiClassType)) continue;
                PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType((PsiClassType)psiType);
                referenceList.add(referenceElement);
            }
        }
    }
}

