/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.JavaClassInheritorsSearcher");

    @Override
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        final PsiClass baseClass = parameters.getClassToProcess();
        SearchScope searchScope = parameters.getScope();
        LOG.assertTrue(searchScope != null);
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                @Override
                public String compute() {
                    return baseClass.getName();
                }
            });
            progress.setText(className != null ? PsiBundle.message("psi.search.inheritors.of.class.progress", className) : PsiBundle.message("psi.search.inheritors.progress", new Object[0]));
        }
        JavaClassInheritorsSearcher.processInheritors(consumer, baseClass, searchScope, parameters);
        if (progress != null) {
            progress.popState();
        }
    }

    private static void processInheritors(final @NotNull Processor<PsiClass> consumer, final @NotNull PsiClass baseClass, final @NotNull SearchScope searchScope, final @NotNull ClassInheritorsSearch.SearchParameters parameters) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        if (baseClass instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return;
        }
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            AllClassesSearch.search(searchScope, project, parameters.getNameCondition()).forEach(new Processor<PsiClass>(){

                @Override
                public boolean process(PsiClass aClass) {
                    ProgressManager.checkCanceled();
                    return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process(aClass);
                }
            });
            return;
        }
        final Ref<Object> currentBase = Ref.create(null);
        final Stack stack = new Stack();
        THashSet processed = ContainerUtil.newTroveSet();
        ReadActionProcessor<PsiClass> processor = new ReadActionProcessor<PsiClass>(){

            @Override
            public boolean processInReadAction(PsiClass candidate) {
                ProgressManager.checkCanceled();
                if ((parameters.isCheckInheritance() || parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass)) && !candidate.isInheritor((PsiClass)currentBase.get(), false)) {
                    return true;
                }
                if (PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)candidate)) {
                    if (candidate instanceof PsiAnonymousClass) {
                        return consumer.process(candidate);
                    }
                    String name = candidate.getName();
                    if (name != null && parameters.getNameCondition().value(name) && !consumer.process(candidate)) {
                        return false;
                    }
                }
                if (parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass) && !JavaClassInheritorsSearcher.isFinal(candidate)) {
                    stack.push(PsiAnchor.create(candidate));
                }
                return true;
            }
        };
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                stack.push(PsiAnchor.create(baseClass));
            }
        });
        GlobalSearchScope projectScope = GlobalSearchScope.allScope(project);
        while (!stack.isEmpty()) {
            PsiClass psiClass;
            ProgressManager.checkCanceled();
            final PsiAnchor anchor = (PsiAnchor)stack.pop();
            if (!processed.add((PsiAnchor)anchor) || (psiClass = ApplicationManager.getApplication().runReadAction(new Computable<PsiClass>(){

                @Override
                public PsiClass compute() {
                    return (PsiClass)anchor.retrieve();
                }
            })) == null) continue;
            currentBase.set(psiClass);
            if (DirectClassInheritorsSearch.search(psiClass, projectScope, parameters.isIncludeAnonymous(), false).forEach((Processor<PsiClass>)processor)) continue;
            return;
        }
    }

    private static boolean isJavaLangObject(final @NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isJavaLangObject"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName());
            }
        });
    }

    private static boolean isFinal(final @NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isFinal"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return baseClass.hasModifierProperty("final");
            }
        });
    }
}

