/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class NonNlsUtils {
    private static final Key<Boolean> KEY = new Key("IG_NON_NLS_ANNOTATED_USE");

    private NonNlsUtils() {
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableArgument(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression referenceExpression;
        PsiElement element;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length < 1) {
            return null;
        }
        PsiExpression argument = arguments[0];
        if (argument instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)element;
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableQualifier(PsiReferenceExpression expression) {
        PsiReferenceExpression referenceExpression;
        PsiElement element;
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)element;
        }
        return null;
    }

    public static boolean isNonNlsAnnotated(@Nullable PsiExpression expression) {
        if (NonNlsUtils.isReferenceToNonNlsAnnotatedElement(expression)) {
            return true;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (NonNlsUtils.isNonNlsAnnotatedModifierListOwner(method)) {
                return true;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return NonNlsUtils.isNonNlsAnnotated(qualifier);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            return NonNlsUtils.isNonNlsAnnotated(arrayExpression);
        }
        return false;
    }

    public static boolean isNonNlsAnnotatedUse(@Nullable PsiExpression expression) {
        boolean result;
        if (expression == null) {
            return false;
        }
        Boolean value = NonNlsUtils.getCachedValue(expression, KEY);
        if (value != null) {
            return value;
        }
        Object element = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpressionList.class, PsiAssignmentExpression.class, PsiVariable.class, PsiReturnStatement.class);
        if (element instanceof PsiExpressionList) {
            PsiExpressionList expressionList = (PsiExpressionList)element;
            result = NonNlsUtils.isNonNlsAnnotatedParameter(expression, expressionList);
        } else if (element instanceof PsiVariable) {
            result = NonNlsUtils.isNonNlsAnnotatedModifierListOwner(element);
        } else if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            result = NonNlsUtils.isAssignmentToNonNlsAnnotatedVariable(assignmentExpression);
        } else if (element instanceof PsiReturnStatement) {
            PsiMethod method = PsiTreeUtil.getParentOfType(element, PsiMethod.class);
            result = NonNlsUtils.isNonNlsAnnotatedModifierListOwner(method);
        } else {
            result = false;
        }
        NonNlsUtils.putCachedValue(expression, KEY, result);
        return result;
    }

    private static <T> void putCachedValue(PsiExpression expression, Key<T> key, T value) {
        if (expression instanceof PsiBinaryExpression) {
            expression.putUserData(key, value);
        }
    }

    @Nullable
    private static <T> T getCachedValue(PsiExpression expression, Key<T> key) {
        PsiExpression rhs;
        T data = expression.getUserData(key);
        if (!(expression instanceof PsiBinaryExpression)) {
            return data;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        PsiExpression lhs = binaryExpression.getLOperand();
        Object childData = null;
        if (lhs instanceof PsiBinaryExpression) {
            childData = lhs.getUserData(key);
        }
        if (childData == null && (rhs = binaryExpression.getROperand()) instanceof PsiBinaryExpression) {
            childData = rhs.getUserData(key);
        }
        if (childData != data) {
            expression.putUserData(key, childData);
        }
        return childData;
    }

    private static boolean isAssignmentToNonNlsAnnotatedVariable(PsiAssignmentExpression assignmentExpression) {
        PsiExpression lhs = assignmentExpression.getLExpression();
        return NonNlsUtils.isReferenceToNonNlsAnnotatedElement(lhs);
    }

    private static boolean isReferenceToNonNlsAnnotatedElement(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement target = referenceExpression.resolve();
        return NonNlsUtils.isNonNlsAnnotatedModifierListOwner(target);
    }

    private static boolean isNonNlsAnnotatedParameter(PsiExpression expression, PsiExpressionList expressionList) {
        PsiParameterList parameterList;
        PsiElement parent = expressionList.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            if (NonNlsUtils.isQualifierNonNlsAnnotated(methodCallExpression)) {
                return true;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            parameterList = method.getParameterList();
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            parameterList = constructor.getParameterList();
        } else {
            return false;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        int index = -1;
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression argument = expressions[i];
            if (!PsiTreeUtil.isAncestor(argument, expression, false)) continue;
            index = i;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (parameters.length == 0) {
            return false;
        }
        PsiParameter parameter = index < parameters.length ? parameters[index] : parameters[parameters.length - 1];
        return NonNlsUtils.isNonNlsAnnotatedModifierListOwner(parameter);
    }

    private static boolean isQualifierNonNlsAnnotated(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (NonNlsUtils.isReferenceToNonNlsAnnotatedElement(qualifier)) {
            return true;
        }
        if (qualifier instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            if (NonNlsUtils.isChainable(method) && NonNlsUtils.isQualifierNonNlsAnnotated(expression = (PsiMethodCallExpression)qualifier)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isChainable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiElement navigationElement = method.getNavigationElement();
        if (!(navigationElement instanceof PsiMethod)) {
            return false;
        }
        method = (PsiMethod)navigationElement;
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement lastStatement = statements[statements.length - 1];
        if (!(lastStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)lastStatement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return returnValue instanceof PsiThisExpression;
    }

    private static boolean isNonNlsAnnotatedModifierListOwner(@Nullable PsiElement element) {
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner variable = (PsiModifierListOwner)element;
        return AnnotationUtil.isAnnotated(variable, "org.jetbrains.annotations.NonNls", false, false);
    }
}

