/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiVariable;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentExcludedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private final Processor<PsiCall> myCallProcessor;
    private final boolean myBuilderPattern;
    private boolean passed;

    VariablePassedAsArgumentExcludedVisitor(@NotNull PsiVariable variable, boolean builderPattern, @NotNull Processor<PsiCall> callProcessor) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor", "<init>"));
        }
        if (callProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callProcessor", "com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor", "<init>"));
        }
        this.variable = variable;
        this.myCallProcessor = callProcessor;
        this.myBuilderPattern = builderPattern;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor", "visitElement"));
        }
        if (this.passed) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitCallExpression(PsiCallExpression callExpression) {
        if (this.passed) {
            return;
        }
        super.visitCallExpression(callExpression);
        this.visitCall(callExpression);
    }

    @Override
    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (this.passed) {
            return;
        }
        super.visitEnumConstant(enumConstant);
        this.visitCall(enumConstant);
    }

    private void visitCall(PsiCall call) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable, this.myBuilderPattern) || this.myCallProcessor.process(call)) continue;
            this.passed = true;
            break;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

