/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethods = true;

    @Override
    @NotNull
    public String getID() {
        if ("LocalVariableHidesMemberVariable" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspectionBase", "getID"));
        }
        return "LocalVariableHidesMemberVariable";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.problem.descriptor", aClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("local.variable.hides.member.variable.ignore.option", new Object[0]), "m_ignoreStaticMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LocalVariableHidingMemberVariableVisitor();
    }

    private class LocalVariableHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LocalVariableHidingMemberVariableVisitor() {
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiMember member;
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspectionBase$LocalVariableHidingMemberVariableVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            if (LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreStaticMethods && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class, PsiClassInitializer.class)) != null && member.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = this.checkFieldNames(variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError(variable, aClass);
        }

        @Override
        public void visitParameter(@NotNull PsiParameter variable) {
            PsiMember member;
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspectionBase$LocalVariableHidingMemberVariableVisitor", "visitParameter"));
            }
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection) && !(declarationScope instanceof PsiForeachStatement)) {
                return;
            }
            if (LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreStaticMethods && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class, PsiClassInitializer.class)) != null && member.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = this.checkFieldNames(variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError(variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldNames(PsiVariable variable) {
            PsiClass aClass = ClassUtils.getContainingClass(variable);
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            while (aClass != null) {
                PsiField[] fields;
                for (PsiField field : fields = aClass.getAllFields()) {
                    String fieldName = field.getName();
                    if (!variableName.equals(fieldName) || LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass)) continue;
                    return aClass;
                }
                aClass = ClassUtils.getContainingClass(aClass);
            }
            return null;
        }
    }
}

