/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeImpl
extends PsiDiamondType {
    private static final Logger LOG = Logger.getInstance("#" + PsiDiamondTypeImpl.class.getName());
    private final PsiManager myManager;
    private final PsiTypeElement myTypeElement;

    public PsiDiamondTypeImpl(PsiManager manager, PsiTypeElement psiTypeElement) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = manager;
        this.myTypeElement = psiTypeElement;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getPresentableText"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getCanonicalText"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        if ("Diamond Type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getInternalCanonicalText"));
        }
        return "Diamond Type";
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiDiamondTypeImpl", "equalsToText"));
        }
        return text.isEmpty();
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiDiamondTypeImpl", "accept"));
        }
        return visitor.visitDiamondType(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{PsiDiamondTypeImpl.getJavaLangObject(this.myManager, this.getResolveScope())};
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondTypeImpl", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    @Override
    public PsiDiamondType.DiamondInferenceResult resolveInferredTypes() {
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType((PsiElement)this.myTypeElement, PsiNewExpression.class);
        if (newExpression == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression) {
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression, newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression, PsiElement context) {
        PsiElement resolve;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass != null && !PsiUtil.isLanguageLevel9OrHigher(newExpression) && (resolve = anonymousClass.getBaseClassReference().resolve()) instanceof PsiClass) {
            return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
        }
        PsiReferenceParameterList referenceParameterList = PsiTreeUtil.getChildOfType(newExpression, PsiReferenceParameterList.class);
        if (referenceParameterList != null && referenceParameterList.getTypeParameterElements().length > 0) {
            return PsiDiamondType.DiamondInferenceResult.EXPLICIT_CONSTRUCTOR_TYPE_ARGS;
        }
        PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, context);
        if (anonymousClass != null && PsiUtil.isLanguageLevel9OrHigher(newExpression)) {
            InferredAnonymTypeVisitor anonymTypeVisitor = new InferredAnonymTypeVisitor(context);
            for (PsiType type : inferenceResult.getInferredTypes()) {
                Boolean accepted = type.accept(anonymTypeVisitor);
                if (accepted == null || accepted.booleanValue()) continue;
                return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
            }
        }
        return inferenceResult;
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypesNoCheck(final PsiNewExpression newExpression, final PsiElement context) {
        final Ref staticFactoryRef = new Ref();
        PsiSubstitutor inferredSubstitutor = ourDiamondGuard.doPreventingRecursion(context, false, new Computable<PsiSubstitutor>(){

            @Override
            public PsiSubstitutor compute() {
                MethodCandidateInfo staticFactoryCandidateInfo = context == newExpression ? CachedValuesManager.getCachedValue(context, new CachedValueProvider<MethodCandidateInfo>(){

                    @Override
                    @Nullable
                    public CachedValueProvider.Result<MethodCandidateInfo> compute() {
                        return new CachedValueProvider.Result<MethodCandidateInfo>(PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, newExpression), PsiModificationTracker.MODIFICATION_COUNT);
                    }
                }) : PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, context);
                staticFactoryRef.set(staticFactoryCandidateInfo);
                return staticFactoryCandidateInfo != null ? staticFactoryCandidateInfo.getSubstitutor() : null;
            }
        });
        if (inferredSubstitutor == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        MethodCandidateInfo staticFactoryInfo = (MethodCandidateInfo)staticFactoryRef.get();
        if (staticFactoryInfo == null) {
            LOG.error(inferredSubstitutor);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiMethod staticFactory = staticFactoryInfo.getElement();
        PsiTypeParameter[] parameters = staticFactory.getTypeParameters();
        PsiElement staticFactoryContext = staticFactory.getContext();
        PsiClass psiClass = PsiTreeUtil.getContextOfType(staticFactoryContext, PsiClass.class, false);
        if (psiClass == null) {
            LOG.error("failed for expression:" + newExpression);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiTypeParameter[] classParameters = psiClass.getTypeParameters();
        PsiJavaCodeReferenceElement classOrAnonymousClassReference = newExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(classOrAnonymousClassReference != null);
        PsiDiamondType.DiamondInferenceResult result = new PsiDiamondType.DiamondInferenceResult(classOrAnonymousClassReference.getReferenceName() + "<>");
        if (PsiUtil.isRawSubstitutor(staticFactory, inferredSubstitutor)) {
            if (!JavaVersionService.getInstance().isAtLeast(newExpression, JavaSdkVersion.JDK_1_8) && PsiUtil.skipParenthesizedExprUp(newExpression.getParent()) instanceof PsiExpressionList) {
                for (PsiTypeParameter ignored : parameters) {
                    result.addInferredType(PsiType.getJavaLangObject(newExpression.getManager(), GlobalSearchScope.allScope(newExpression.getProject())));
                }
            }
            return result;
        }
        block1: for (PsiTypeParameter parameter : parameters) {
            for (PsiTypeParameter classParameter : classParameters) {
                if (!Comparing.strEqual(classParameter.getName(), parameter.getName())) continue;
                result.addInferredType(inferredSubstitutor.substitute(parameter));
                continue block1;
            }
        }
        return result;
    }

    private static MethodCandidateInfo getStaticFactoryCandidateInfo(PsiNewExpression newExpression, PsiElement context) {
        Computable<Integer> computable;
        Integer applicability;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiClass psiClass = PsiDiamondTypeImpl.findClass(newExpression);
        if (psiClass == null) {
            return null;
        }
        PsiMethod staticFactory = PsiDiamondTypeImpl.findConstructorStaticFactory(psiClass, newExpression);
        if (staticFactory == null) {
            return null;
        }
        final MethodCandidateInfo staticFactoryCandidateInfo = PsiDiamondTypeImpl.createMethodCandidate(staticFactory, context, false, argumentList);
        if (staticFactory.isVarArgs() && ((applicability = MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(newExpression, true, computable = new Computable<Integer>(){

            @Override
            public Integer compute() {
                return staticFactoryCandidateInfo.getPertinentApplicabilityLevel();
            }
        })) != null ? applicability.intValue() : staticFactoryCandidateInfo.getApplicabilityLevel()) < 3) {
            return PsiDiamondTypeImpl.createMethodCandidate(staticFactory, context, true, argumentList);
        }
        return staticFactoryCandidateInfo;
    }

    @Nullable
    private static PsiMethod findConstructorStaticFactory(final PsiClass containingClass, PsiNewExpression newExpression) {
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(newExpression);
        ArrayList conflicts = new ArrayList();
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{null};
        }
        PsiConflictResolver[] conflictResolvers = new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList, languageLevel)};
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(argumentList, argumentList.getContainingFile(), conflictResolvers, conflicts){

            @Override
            protected boolean isAccepted(PsiMethod candidate) {
                return true;
            }

            @Override
            protected PsiClass getContainingClass(PsiMethod method) {
                return containingClass;
            }

            @Override
            protected boolean acceptVarargs() {
                return true;
            }
        };
        processor.setArgumentList(argumentList);
        for (PsiMethod constructor : constructors) {
            PsiTypeParameter[] params = PsiDiamondTypeImpl.getAllTypeParams(constructor, containingClass);
            PsiMethod staticFactory = PsiDiamondTypeImpl.generateStaticFactory(constructor, containingClass, params, newExpression.getClassReference());
            if (staticFactory == null) continue;
            processor.add(staticFactory, PsiSubstitutor.EMPTY);
        }
        JavaResolveResult[] result = processor.getResult();
        return result.length == 1 ? (PsiMethod)result[0].getElement() : null;
    }

    @Nullable
    private static PsiClass findClass(PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
        if (classReference != null) {
            String text = classReference.getReferenceName();
            if (text != null) {
                PsiClass aClass;
                Project project = newExpression.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiExpression newExpressionQualifier = newExpression.getQualifier();
                PsiElement qualifierElement = classReference.getQualifier();
                String qualifier = qualifierElement != null ? qualifierElement.getText() : "";
                String qualifiedName = StringUtil.getQualifiedName(qualifier, text);
                if (newExpressionQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly(newExpressionQualifier.getType())) != null) {
                    return aClass.findInnerClassByName(qualifiedName, false);
                }
                return resolveHelper.resolveReferencedClass(qualifiedName, newExpression);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiMethod generateStaticFactory(@Nullable PsiMethod constructor, PsiClass containingClass, PsiTypeParameter[] params, PsiJavaCodeReferenceElement reference) {
        PsiElement qualifier;
        StringBuilder buf = new StringBuilder();
        String modifier = VisibilityUtil.getVisibilityModifier(constructor != null ? constructor.getModifierList() : containingClass.getModifierList());
        if (!"packageLocal".equals(modifier)) {
            buf.append(modifier);
            buf.append(" ");
        }
        buf.append("static ");
        buf.append("<");
        buf.append(StringUtil.join(params, new Function<PsiTypeParameter, String>(){

            @Override
            public String fun(PsiTypeParameter psiTypeParameter) {
                PsiClassType[] extendsListTypes;
                String extendsList = "";
                if (psiTypeParameter.getLanguage().isKindOf(JavaLanguage.INSTANCE) && (extendsListTypes = psiTypeParameter.getExtendsListTypes()).length > 0) {
                    Function<PsiClassType, String> canonicalTypePresentationFun = new Function<PsiClassType, String>(){

                        @Override
                        public String fun(PsiClassType type) {
                            return type.getCanonicalText();
                        }
                    };
                    extendsList = " extends " + StringUtil.join(extendsListTypes, canonicalTypePresentationFun, "&");
                }
                return psiTypeParameter.getName() + extendsList;
            }
        }, ", "));
        buf.append(">");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(containingClass.getProject());
        String qualifiedName = containingClass.getQualifiedName();
        PsiElement psiElement = qualifier = reference != null ? reference.getQualifier() : null;
        if (qualifier instanceof PsiJavaCodeReferenceElement) {
            JavaResolveResult resolveResult = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiClass) {
                String outerClassSubstitutedQName = elementFactory.createType((PsiClass)element, resolveResult.getSubstitutor()).getInternalCanonicalText();
                qualifiedName = outerClassSubstitutedQName + "." + containingClass.getName();
            }
        } else if (reference != null && qualifier == null && containingClass.getContainingClass() != null) {
            qualifiedName = null;
        }
        buf.append(qualifiedName != null ? qualifiedName : containingClass.getName());
        PsiTypeParameter[] parameters = containingClass.getTypeParameters();
        buf.append("<");
        buf.append(StringUtil.join(parameters, new Function<PsiTypeParameter, String>(){

            @Override
            public String fun(PsiTypeParameter psiTypeParameter) {
                return psiTypeParameter.getName();
            }
        }, ", "));
        buf.append("> ");
        String staticFactoryName = "staticFactory";
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(containingClass.getProject());
        staticFactoryName = styleManager.suggestUniqueVariableName(staticFactoryName, (PsiElement)containingClass, false);
        buf.append(staticFactoryName);
        if (constructor == null) {
            buf.append("()");
        } else {
            buf.append("(").append(StringUtil.join(constructor.getParameterList().getParameters(), new Function<PsiParameter, String>(){
                int myIdx = 0;

                @Override
                public String fun(PsiParameter psiParameter) {
                    return psiParameter.getType().getCanonicalText() + " p" + this.myIdx++;
                }
            }, ",")).append(")");
        }
        buf.append("{}");
        try {
            return elementFactory.createMethodFromText(buf.toString(), constructor != null ? constructor : containingClass);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static PsiTypeParameter[] getAllTypeParams(PsiTypeParameterListOwner listOwner, PsiClass containingClass) {
        LinkedHashSet params = new LinkedHashSet();
        if (listOwner != null) {
            Collections.addAll(params, listOwner.getTypeParameters());
        }
        Collections.addAll(params, containingClass.getTypeParameters());
        return params.toArray(new PsiTypeParameter[params.size()]);
    }

    private static MethodCandidateInfo createMethodCandidate(@NotNull PsiMethod staticFactoryMethod, final PsiElement parent, final boolean varargs, final PsiExpressionList argumentList) {
        if (staticFactoryMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticFactoryMethod", "com/intellij/psi/PsiDiamondTypeImpl", "createMethodCandidate"));
        }
        return new MethodCandidateInfo(staticFactoryMethod, PsiSubstitutor.EMPTY, false, false, argumentList, parent, null, null){
            private PsiType[] myExpressionTypes;

            @Override
            public boolean isVarargs() {
                return varargs;
            }

            @Override
            protected PsiElement getParent() {
                return parent;
            }

            @Override
            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null) {
                    PsiType[] expressionTypes = argumentList.getExpressionTypes();
                    if (MethodCandidateInfo.isOverloadCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }

            @Override
            protected PsiElement getMarkerList() {
                return parent instanceof PsiNewExpression ? ((PsiNewExpression)parent).getArgumentList() : super.getMarkerList();
            }
        };
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] constructors;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/PsiDiamondTypeImpl", "hasDefaultConstructor"));
        }
        for (PsiMethod method : constructors = psiClass.getConstructors()) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return constructors.length == 0;
    }

    public static boolean haveConstructorsGenericsParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/PsiDiamondTypeImpl", "haveConstructorsGenericsParameters"));
        }
        for (final PsiMethod method : psiClass.getConstructors()) {
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                PsiType type = parameter.getType();
                Boolean accept = type.accept(new PsiTypeVisitor<Boolean>(){

                    @Override
                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return arrayType.getComponentType().accept(this);
                    }

                    @Override
                    public Boolean visitClassType(PsiClassType classType) {
                        for (PsiType psiType : classType.getParameters()) {
                            Boolean typeParamFound;
                            if (psiType == null || (typeParamFound = psiType.accept(this)) == null || !typeParamFound.booleanValue()) continue;
                            return true;
                        }
                        PsiClass aClass = PsiUtil.resolveClassInType(classType);
                        return aClass instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method;
                    }

                    @Override
                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound == null) {
                            return false;
                        }
                        return bound.accept(this);
                    }
                });
                if (accept == null || !accept.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static class InferredAnonymTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        private final PsiElement myExpression;

        public InferredAnonymTypeVisitor(PsiElement expression) {
            this.myExpression = expression;
        }

        @Override
        @Nullable
        public Boolean visitType(PsiType type) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return false;
        }

        @Override
        @Nullable
        public Boolean visitIntersectionType(PsiIntersectionType intersectionType) {
            return false;
        }

        @Override
        @Nullable
        public Boolean visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                if (psiClass instanceof PsiTypeParameter && InferenceSession.isFreshVariable((PsiTypeParameter)psiClass)) {
                    return false;
                }
                if (!PsiUtil.isAccessible(psiClass, this.myExpression, null)) {
                    return false;
                }
                for (PsiType psiType : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    Boolean accepted = psiType.accept(this);
                    if (accepted == null || accepted.booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

