/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutLoggerInspectionBase
extends BaseInspection {
    protected final List<String> loggerNames = new ArrayList<String>();
    @NonNls
    public String loggerNamesString = "java.util.logging.Logger,org.slf4j.Logger,org.apache.commons.logging.Log,org.apache.log4j.Logger";
    public boolean ignoreSuperLoggers = false;

    public ClassWithoutLoggerInspectionBase() {
        ClassWithoutLoggerInspectionBase.parseString(this.loggerNamesString, this.loggerNames);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("no.logger.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/ClassWithoutLoggerInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("no.logger.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/ClassWithoutLoggerInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/ClassWithoutLoggerInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        ClassWithoutLoggerInspectionBase.parseString(this.loggerNamesString, this.loggerNames);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/ClassWithoutLoggerInspectionBase", "writeSettings"));
        }
        this.loggerNamesString = ClassWithoutLoggerInspectionBase.formatString(this.loggerNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutLoggerVisitor();
    }

    private class ClassWithoutLoggerVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutLoggerVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/logging/ClassWithoutLoggerInspectionBase$ClassWithoutLoggerVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            PsiField[] fields = ClassWithoutLoggerInspectionBase.this.ignoreSuperLoggers ? aClass.getAllFields() : aClass.getFields();
            for (PsiField field : fields) {
                if (!this.isLogger(field) || !PsiUtil.isAccessible(field, aClass, aClass)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type = variable.getType();
            String text = type.getCanonicalText();
            return ClassWithoutLoggerInspectionBase.this.loggerNames.contains(text);
        }
    }
}

