/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnboxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyUnboxed = false;
    @NonNls
    static final Map<String, String> s_unboxingMethods = new HashMap<String, String>(8);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.unboxing.superfluous.option", new Object[0]), this, "onlyReportSuperfluouslyUnboxed");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnboxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnboxingVisitor();
    }

    static {
        s_unboxingMethods.put("java.lang.Integer", "intValue");
        s_unboxingMethods.put("java.lang.Short", "shortValue");
        s_unboxingMethods.put("java.lang.Boolean", "booleanValue");
        s_unboxingMethods.put("java.lang.Long", "longValue");
        s_unboxingMethods.put("java.lang.Byte", "byteValue");
        s_unboxingMethods.put("java.lang.Float", "floatValue");
        s_unboxingMethods.put("java.lang.Double", "doubleValue");
        s_unboxingMethods.put("java.lang.Character", "charValue");
    }

    private class UnnecessaryUnboxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnboxingVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiType expectedType;
            PsiCallExpression methodCallExpression;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!this.isUnboxingExpression(expression)) {
                return;
            }
            PsiExpression containingExpression = this.getContainingExpression(expression);
            if (this.isPossibleObjectComparison(expression, containingExpression)) {
                return;
            }
            if (containingExpression instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)containingExpression;
                PsiTypeElement typeElement = typeCastExpression.getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType castType = typeElement.getType();
                PsiType expressionType = expression.getType();
                if (expressionType == null || !castType.isAssignableFrom(expressionType)) {
                    return;
                }
            } else if (containingExpression instanceof PsiConditionalExpression) {
                PsiType type;
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)containingExpression;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                if (thenExpression == null) {
                    return;
                }
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null) {
                    return;
                }
                if (PsiTreeUtil.isAncestor(thenExpression, expression, false) ? !((type = elseExpression.getType()) instanceof PsiPrimitiveType) : PsiTreeUtil.isAncestor(elseExpression, expression, false) && !((type = thenExpression.getType()) instanceof PsiPrimitiveType)) {
                    return;
                }
            } else if (containingExpression instanceof PsiCallExpression && !this.isSameMethodCalledWithoutUnboxing(methodCallExpression = (PsiCallExpression)containingExpression, expression)) {
                return;
            }
            if (UnnecessaryUnboxingInspection.this.onlyReportSuperfluouslyUnboxed && !((expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true)) instanceof PsiClassType)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean isPossibleObjectComparison(PsiMethodCallExpression expression, PsiExpression containingExpression) {
            if (!(containingExpression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)containingExpression;
            if (!ComparisonUtils.isEqualityComparison(binaryExpression)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return true;
            }
            if (expression == lhs && (!(rhs.getType() instanceof PsiPrimitiveType) || this.isUnboxingExpression(rhs))) {
                return true;
            }
            return expression == rhs && (!(lhs.getType() instanceof PsiPrimitiveType) || this.isUnboxingExpression(lhs));
        }

        private boolean isUnboxingExpression(PsiExpression expression) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            String qualifierTypeName = qualifierType.getCanonicalText();
            if (!s_unboxingMethods.containsKey(qualifierTypeName)) {
                return false;
            }
            String methodName = methodExpression.getReferenceName();
            String unboxingMethod = s_unboxingMethods.get(qualifierTypeName);
            return unboxingMethod.equals(methodName);
        }

        private boolean isSameMethodCalledWithoutUnboxing(@NotNull PsiCallExpression callExpression, @NotNull PsiMethodCallExpression unboxingExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "isSameMethodCalledWithoutUnboxing"));
            }
            if (unboxingExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboxingExpression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "isSameMethodCalledWithoutUnboxing"));
            }
            PsiReferenceExpression methodExpression = unboxingExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiMethod originalMethod = callExpression.resolveMethod();
            if (originalMethod == null) {
                return false;
            }
            PsiMethod method = MethodCallUtils.findMethodWithReplacedArgument(callExpression, unboxingExpression, qualifier);
            return originalMethod == method;
        }

        @Nullable
        private PsiExpression getContainingExpression(@NotNull PsiElement expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingVisitor", "getContainingExpression"));
            }
            PsiElement parent = expression.getParent();
            if (parent == null || !(parent instanceof PsiExpression) && !(parent instanceof PsiExpressionList)) {
                return null;
            }
            if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiExpressionList) {
                return this.getContainingExpression(parent);
            }
            return (PsiExpression)parent;
        }
    }

    private static class UnnecessaryUnboxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryUnboxingFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unboxing.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryUnboxingInspection$UnnecessaryUnboxingFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiReferenceExpression referenceExpression;
            PsiElement element;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression strippedQualifier = ParenthesesUtils.stripParentheses(qualifier);
            if (strippedQualifier == null) {
                return;
            }
            if (strippedQualifier instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)strippedQualifier).resolve()) instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String classname = containingClass.getQualifiedName();
                if ("java.lang.Boolean".equals(classname)) {
                    String name = field.getName();
                    if ("TRUE".equals(name)) {
                        PsiReplacementUtil.replaceExpression(methodCall, "true");
                        return;
                    }
                    if ("FALSE".equals(name)) {
                        PsiReplacementUtil.replaceExpression(methodCall, "false");
                        return;
                    }
                }
            }
            String strippedQualifierText = strippedQualifier.getText();
            PsiReplacementUtil.replaceExpression(methodCall, strippedQualifierText);
        }
    }
}

