/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ImageLoader;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationInfoImpl
extends ApplicationInfoEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.application.impl.ApplicationInfoImpl");
    private String myCodeName = null;
    private String myMajorVersion = null;
    private String myMinorVersion = null;
    private String myMicroVersion = null;
    private String myPatchVersion = null;
    private String myFullVersion = null;
    private String myBuildNumber = null;
    private String myApiVersion = null;
    private String myCompanyName = "JetBrains s.r.o.";
    private String myCompanyUrl = "https://www.jetbrains.com/";
    private Color myProgressColor = null;
    private Color myCopyrightForeground = JBColor.BLACK;
    private Color myAboutForeground = JBColor.BLACK;
    private Color myAboutLinkColor = null;
    private String myProgressTailIconName = null;
    private Icon myProgressTailIcon = null;
    private int myProgressHeight = 2;
    private int myProgressX = 1;
    private int myProgressY = 350;
    private String mySplashImageUrl = null;
    private String myAboutImageUrl = null;
    private Color mySplashTextColor = new Color(0, 35, 135);
    private String myIconUrl = "/icon.png";
    private String mySmallIconUrl = "/icon_small.png";
    private String myBigIconUrl = null;
    private String myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
    private String myWelcomeScreenLogoUrl = null;
    private String myEditorBackgroundImageUrl = null;
    private Calendar myBuildDate = null;
    private Calendar myMajorReleaseBuildDate = null;
    private String myPackageCode = null;
    private boolean myShowLicensee = true;
    private String myCustomizeIDEWizardStepsProvider;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myEAPFeedbackUrl;
    private String myReleaseFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp = true;
    private boolean myHasContextHelp = true;
    private String myHelpFileName = "ideahelp.jar";
    private String myHelpRootName = "idea";
    private String myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
    private List<ApplicationInfoEx.PluginChooserPage> myPluginChooserPages = new ArrayList<ApplicationInfoEx.PluginChooserPage>();
    private String[] myEssentialPluginsIds;
    private String myStatisticsSettingsUrl;
    private String myStatisticsServiceUrl;
    private String myStatisticsServiceKey;
    private String myThirdPartySoftwareUrl;
    private String myJetbrainsTvUrl;
    private String myEvalLicenseUrl = "https://www.jetbrains.com/company/useterms.html";
    private String myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
    private Rectangle myAboutLogoRect;
    private static final String IDEA_PATH = "/idea/";
    private static final String ELEMENT_VERSION = "version";
    private static final String ATTRIBUTE_MAJOR = "major";
    private static final String ATTRIBUTE_MINOR = "minor";
    private static final String ATTRIBUTE_MICRO = "micro";
    private static final String ATTRIBUTE_PATCH = "patch";
    private static final String ATTRIBUTE_FULL = "full";
    private static final String ATTRIBUTE_CODENAME = "codename";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_BUILD = "build";
    private static final String ELEMENT_COMPANY = "company";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_API_VERSION = "apiVersion";
    private static final String ATTRIBUTE_DATE = "date";
    private static final String ATTRIBUTE_MAJOR_RELEASE_DATE = "majorReleaseDate";
    private static final String ELEMENT_LOGO = "logo";
    private static final String ATTRIBUTE_URL = "url";
    private static final String ATTRIBUTE_TEXT_COLOR = "textcolor";
    private static final String ATTRIBUTE_PROGRESS_COLOR = "progressColor";
    private static final String ATTRIBUTE_ABOUT_FOREGROUND_COLOR = "foreground";
    private static final String ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR = "copyrightForeground";
    private static final String ATTRIBUTE_ABOUT_LINK_COLOR = "linkColor";
    private static final String ATTRIBUTE_PROGRESS_HEIGHT = "progressHeight";
    private static final String ATTRIBUTE_PROGRESS_X = "progressX";
    private static final String ATTRIBUTE_PROGRESS_Y = "progressY";
    private static final String ATTRIBUTE_PROGRESS_TAIL_ICON = "progressTailIcon";
    private static final String ELEMENT_ABOUT = "about";
    private static final String ELEMENT_ICON = "icon";
    private static final String ATTRIBUTE_SIZE32 = "size32";
    private static final String ATTRIBUTE_SIZE128 = "size128";
    private static final String ATTRIBUTE_SIZE16 = "size16";
    private static final String ATTRIBUTE_SIZE12 = "size12";
    private static final String ELEMENT_PACKAGE = "package";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ELEMENT_LICENSEE = "licensee";
    private static final String ATTRIBUTE_SHOW = "show";
    private static final String WELCOME_SCREEN_ELEMENT_NAME = "welcome-screen";
    private static final String LOGO_URL_ATTR = "logo-url";
    private static final String ELEMENT_EDITOR = "editor";
    private static final String BACKGROUND_URL_ATTR = "background-url";
    private static final String UPDATE_URLS_ELEMENT_NAME = "update-urls";
    private static final String XML_EXTENSION = ".xml";
    private static final String ATTRIBUTE_EAP = "eap";
    private static final String HELP_ELEMENT_NAME = "help";
    private static final String ATTRIBUTE_HELP_FILE = "file";
    private static final String ATTRIBUTE_HELP_ROOT = "root";
    private static final String PLUGINS_PAGE_ELEMENT_NAME = "plugins-page";
    private static final String ELEMENT_DOCUMENTATION = "documentation";
    private static final String ELEMENT_SUPPORT = "support";
    private static final String ELEMENT_FEEDBACK = "feedback";
    private static final String ATTRIBUTE_RELEASE_URL = "release-url";
    private static final String ATTRIBUTE_EAP_URL = "eap-url";
    private static final String ELEMENT_PLUGINS = "plugins";
    private static final String ATTRIBUTE_LIST_URL = "list-url";
    private static final String ATTRIBUTE_CHANNEL_LIST_URL = "channel-list-url";
    private static final String ATTRIBUTE_DOWNLOAD_URL = "download-url";
    private static final String ATTRIBUTE_BUILTIN_URL = "builtin-url";
    private static final String ATTRIBUTE_WEBHELP_URL = "webhelp-url";
    private static final String ATTRIBUTE_HAS_HELP = "has-help";
    private static final String ATTRIBUTE_HAS_CONTEXT_HELP = "has-context-help";
    private static final String ELEMENT_WHATSNEW = "whatsnew";
    private static final String ELEMENT_KEYMAP = "keymap";
    private static final String ATTRIBUTE_WINDOWS_URL = "win";
    private static final String ATTRIBUTE_MAC_URL = "mac";
    private static final String ELEMENT_STATISTICS = "statistics";
    private static final String ATTRIBUTE_STATISTICS_SETTINGS = "settings";
    private static final String ATTRIBUTE_STATISTICS_SERVICE = "service";
    private static final String ATTRIBUTE_STATISTICS_SERVICE_KEY = "service-key";
    private static final String ELEMENT_THIRD_PARTY = "third-party";
    private static final String ELEMENT_JB_TV = "jetbrains-tv";
    private static final String CUSTOMIZE_IDE_WIZARD_STEPS = "customize-ide-wizard";
    private static final String STEPS_PROVIDER = "provider";
    private static final String ELEMENT_EVALUATION = "evaluation";
    private static final String ATTRIBUTE_EVAL_LICENSE_URL = "license-url";
    private static final String ELEMENT_LICENSING = "licensing";
    private static final String ATTRIBUTE_KEY_CONVERSION_URL = "key-conversion-url";
    private static final String ESSENTIAL_PLUGIN = "essential-plugin";
    private static final String DEFAULT_PLUGINS_HOST = "http://plugins.jetbrains.com";
    private static ApplicationInfoImpl ourShadowInstance;
    private static volatile boolean myInPerformanceTest;

    ApplicationInfoImpl() {
        try {
            Document doc = JDOMUtil.loadDocument(ApplicationInfoImpl.class, IDEA_PATH + ApplicationNamesInfo.getComponentName() + XML_EXTENSION);
            this.loadState(doc.getRootElement());
        }
        catch (FileNotFoundException e) {
            LOG.error("Resource is not in classpath or wrong platform prefix: " + System.getProperty("idea.platform.prefix"), e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Override
    public Calendar getBuildDate() {
        return this.myBuildDate;
    }

    @Override
    public Calendar getMajorReleaseBuildDate() {
        return this.myMajorReleaseBuildDate != null ? this.myMajorReleaseBuildDate : this.myBuildDate;
    }

    @Override
    public BuildNumber getBuild() {
        return BuildNumber.fromString(this.myBuildNumber, ApplicationInfoImpl.getProductPrefix());
    }

    private static String getProductPrefix() {
        String prefix = null;
        if (PlatformUtils.isIdeaCommunity()) {
            prefix = "IC";
        } else if (PlatformUtils.isIdeaUltimate()) {
            prefix = "IU";
        }
        return prefix;
    }

    @Override
    public String getApiVersion() {
        if (this.myApiVersion != null) {
            return BuildNumber.fromString(this.myApiVersion, this.getBuild().getProductCode()).asString();
        }
        return this.getBuild().asString();
    }

    @Override
    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    @Override
    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    @Override
    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    @Override
    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    @Override
    public String getFullVersion() {
        if (this.myFullVersion == null) {
            if (!StringUtil.isEmptyOrSpaces(this.myMajorVersion)) {
                if (!StringUtil.isEmptyOrSpaces(this.myMinorVersion)) {
                    return this.myMajorVersion + "." + this.myMinorVersion;
                }
                return this.myMajorVersion + ".0";
            }
            return this.getVersionName();
        }
        return MessageFormat.format(this.myFullVersion, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion);
    }

    @Override
    public String getStrictVersion() {
        return this.myMajorVersion + "." + this.myMinorVersion + "." + StringUtil.notNullize(this.myMicroVersion, "0") + "." + StringUtil.notNullize(this.myPatchVersion, "0");
    }

    @Override
    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && !StringUtil.isEmptyOrSpaces(this.myCodeName)) {
            return fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    @Override
    public String getHelpURL() {
        return "jar:file:///" + this.getHelpJarPath() + "!/" + this.myHelpRootName;
    }

    @Override
    public String getCompanyName() {
        return this.myCompanyName;
    }

    @Override
    public String getCompanyURL() {
        return this.myCompanyUrl;
    }

    private String getHelpJarPath() {
        return PathManager.getHomePath() + File.separator + HELP_ELEMENT_NAME + File.separator + this.myHelpFileName;
    }

    @Override
    public String getSplashImageUrl() {
        return this.mySplashImageUrl;
    }

    @Override
    public Color getSplashTextColor() {
        return this.mySplashTextColor;
    }

    @Override
    public String getAboutImageUrl() {
        return this.myAboutImageUrl;
    }

    public Color getProgressColor() {
        return this.myProgressColor;
    }

    public Color getCopyrightForeground() {
        return this.myCopyrightForeground;
    }

    public int getProgressHeight() {
        return this.myProgressHeight;
    }

    public int getProgressY() {
        return this.myProgressY;
    }

    public int getProgressX() {
        return this.myProgressX;
    }

    @Nullable
    public Icon getProgressTailIcon() {
        if (this.myProgressTailIcon == null && this.myProgressTailIconName != null) {
            try {
                URL url = this.getClass().getResource(this.myProgressTailIconName);
                Image image = ImageLoader.loadFromUrl(url, false);
                if (image != null) {
                    this.myProgressTailIcon = new ImageIcon(image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myProgressTailIcon;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    public String getSmallIconUrl() {
        return this.mySmallIconUrl;
    }

    @Override
    @Nullable
    public String getBigIconUrl() {
        return this.myBigIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    @Nullable
    public String getCustomizeIDEWizardStepsProvider() {
        return this.myCustomizeIDEWizardStepsProvider;
    }

    @Override
    public String getEditorBackgroundImageUrl() {
        return this.myEditorBackgroundImageUrl;
    }

    @Override
    public String getPackageCode() {
        return this.myPackageCode;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getEAPFeedbackUrl() {
        return this.myEAPFeedbackUrl;
    }

    @Override
    public String getReleaseFeedbackUrl() {
        return this.myReleaseFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getChannelsListUrl() {
        return this.myChannelsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    @Override
    public boolean hasHelp() {
        return this.myHasHelp;
    }

    @Override
    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public Color getAboutForeground() {
        return this.myAboutForeground;
    }

    public Color getAboutLinkColor() {
        return this.myAboutLinkColor;
    }

    @Override
    public String getFullApplicationName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getVersionName());
        buffer.append(" ");
        if (this.getMajorVersion() != null && !this.isEAP() && !this.isBetaOrRC()) {
            buffer.append(this.getFullVersion());
        } else {
            buffer.append(this.getBuild().asStringWithAllDetails());
        }
        return buffer.toString();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    public String getStatisticsSettingsUrl() {
        return this.myStatisticsSettingsUrl;
    }

    public String getStatisticsServiceUrl() {
        return this.myStatisticsServiceUrl;
    }

    public String getStatisticsServiceKey() {
        return this.myStatisticsServiceKey;
    }

    @Override
    public String getThirdPartySoftwareURL() {
        return this.myThirdPartySoftwareUrl;
    }

    @Override
    public String getJetbrainsTvUrl() {
        return this.myJetbrainsTvUrl;
    }

    @Override
    public String getEvalLicenseUrl() {
        return this.myEvalLicenseUrl;
    }

    @Override
    public String getKeyConversionUrl() {
        return this.myKeyConversionUrl;
    }

    @Override
    public Rectangle getAboutLogoRect() {
        return this.myAboutLogoRect;
    }

    public boolean isBetaOrRC() {
        String minor = this.getMinorVersion();
        return minor != null && (minor.contains("RC") || minor.contains("Beta") || minor.contains("beta"));
    }

    public static ApplicationInfoEx getShadowInstance() {
        if (ourShadowInstance == null) {
            ourShadowInstance = new ApplicationInfoImpl();
        }
        return ourShadowInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState(Element parentNode) {
        String url;
        Element licensingElement;
        String url2;
        Element evaluationElement;
        Element tvElement;
        Element keymapElement;
        Element pluginsElement;
        Element whatsnewElement;
        Element feedbackElement;
        Element supportElement;
        Element helpElement;
        Element editor;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconElement;
        Element aboutLogoElement;
        Element buildElement;
        Element companyElement;
        Element versionElement = parentNode.getChild(ELEMENT_VERSION);
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue(ATTRIBUTE_MAJOR);
            this.myMinorVersion = versionElement.getAttributeValue(ATTRIBUTE_MINOR);
            this.myMicroVersion = versionElement.getAttributeValue(ATTRIBUTE_MICRO);
            this.myPatchVersion = versionElement.getAttributeValue(ATTRIBUTE_PATCH);
            this.myFullVersion = versionElement.getAttributeValue(ATTRIBUTE_FULL);
            this.myCodeName = versionElement.getAttributeValue(ATTRIBUTE_CODENAME);
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue(ATTRIBUTE_EAP));
        }
        if ((companyElement = parentNode.getChild(ELEMENT_COMPANY)) != null) {
            this.myCompanyName = companyElement.getAttributeValue(ATTRIBUTE_NAME, this.myCompanyName);
            this.myCompanyUrl = companyElement.getAttributeValue(ATTRIBUTE_URL, this.myCompanyUrl);
        }
        if ((buildElement = parentNode.getChild(ELEMENT_BUILD)) != null) {
            String majorReleaseDateString;
            this.myBuildNumber = buildElement.getAttributeValue(ATTRIBUTE_NUMBER);
            this.myApiVersion = buildElement.getAttributeValue(ATTRIBUTE_API_VERSION);
            ApplicationInfoImpl.setBuildNumber(this.myApiVersion, this.myBuildNumber);
            String dateString = buildElement.getAttributeValue(ATTRIBUTE_DATE);
            if (dateString.equals("__BUILD_DATE__")) {
                this.myBuildDate = new GregorianCalendar();
                try {
                    JarFile bootJar = new JarFile(PathManager.getHomePath() + File.separator + "lib" + File.separator + "boot.jar");
                    try {
                        JarEntry jarEntry = bootJar.entries().nextElement();
                        this.myBuildDate.setTime(new Date(jarEntry.getTime()));
                    }
                    finally {
                        bootJar.close();
                    }
                }
                catch (Exception bootJar) {}
            } else {
                this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
            }
            if ((majorReleaseDateString = buildElement.getAttributeValue(ATTRIBUTE_MAJOR_RELEASE_DATE)) != null) {
                this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
            }
        }
        Thread currentThread = Thread.currentThread();
        currentThread.setName(currentThread.getName() + " " + this.myMajorVersion + "." + this.myMinorVersion + "#" + this.myBuildNumber + ", eap:" + this.myEAP);
        Element logoElement = parentNode.getChild(ELEMENT_LOGO);
        if (logoElement != null) {
            this.mySplashImageUrl = logoElement.getAttributeValue(ATTRIBUTE_URL);
            this.mySplashTextColor = ApplicationInfoImpl.parseColor(logoElement.getAttributeValue(ATTRIBUTE_TEXT_COLOR));
            String v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_COLOR);
            if (v != null) {
                this.myProgressColor = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_TAIL_ICON)) != null) {
                this.myProgressTailIconName = v;
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_HEIGHT)) != null) {
                this.myProgressHeight = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_X)) != null) {
                this.myProgressX = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_Y)) != null) {
                this.myProgressY = Integer.parseInt(v);
            }
        }
        if ((aboutLogoElement = parentNode.getChild(ELEMENT_ABOUT)) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue(ATTRIBUTE_URL);
            String v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_FOREGROUND_COLOR);
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR)) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_LINK_COLOR)) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new Rectangle(Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = parentNode.getChild(ELEMENT_ICON)) != null) {
            this.myIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE32);
            this.mySmallIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE16);
            this.myBigIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE128, (String)null);
            String toolWindowIcon = iconElement.getAttributeValue(ATTRIBUTE_SIZE12);
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
        }
        if ((packageElement = parentNode.getChild(ELEMENT_PACKAGE)) != null) {
            this.myPackageCode = packageElement.getAttributeValue(ATTRIBUTE_CODE);
        }
        if ((showLicensee = parentNode.getChild(ELEMENT_LICENSEE)) != null) {
            this.myShowLicensee = Boolean.valueOf(showLicensee.getAttributeValue(ATTRIBUTE_SHOW));
        }
        if ((welcomeScreen = parentNode.getChild(WELCOME_SCREEN_ELEMENT_NAME)) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue(LOGO_URL_ATTR);
        }
        if ((wizardSteps = parentNode.getChild(CUSTOMIZE_IDE_WIZARD_STEPS)) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue(STEPS_PROVIDER);
        }
        if ((editor = parentNode.getChild(ELEMENT_EDITOR)) != null) {
            this.myEditorBackgroundImageUrl = editor.getAttributeValue(BACKGROUND_URL_ATTR);
        }
        if ((helpElement = parentNode.getChild(HELP_ELEMENT_NAME)) != null) {
            String attValue;
            this.myHelpFileName = helpElement.getAttributeValue(ATTRIBUTE_HELP_FILE);
            this.myHelpRootName = helpElement.getAttributeValue(ATTRIBUTE_HELP_ROOT);
            String webHelpUrl = helpElement.getAttributeValue(ATTRIBUTE_WEBHELP_URL);
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_HELP)) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_CONTEXT_HELP);
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        Element updateUrls = parentNode.getChild(UPDATE_URLS_ELEMENT_NAME);
        this.myUpdateUrls = new UpdateUrlsImpl(updateUrls);
        Element documentationElement = parentNode.getChild(ELEMENT_DOCUMENTATION);
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((supportElement = parentNode.getChild(ELEMENT_SUPPORT)) != null) {
            this.mySupportUrl = supportElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((feedbackElement = parentNode.getChild(ELEMENT_FEEDBACK)) != null) {
            this.myEAPFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_EAP_URL);
            this.myReleaseFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_RELEASE_URL);
        }
        if ((whatsnewElement = parentNode.getChild(ELEMENT_WHATSNEW)) != null) {
            this.myWhatsNewUrl = whatsnewElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((pluginsElement = parentNode.getChild(ELEMENT_PLUGINS)) != null) {
            String url3 = pluginsElement.getAttributeValue(ATTRIBUTE_URL);
            this.myPluginManagerUrl = url3 != null ? url3 : DEFAULT_PLUGINS_HOST;
            boolean closed = StringUtil.endsWith(this.myPluginManagerUrl, "/");
            String listUrl = pluginsElement.getAttributeValue(ATTRIBUTE_LIST_URL);
            this.myPluginsListUrl = listUrl != null ? listUrl : this.myPluginManagerUrl + (closed ? "" : "/") + "plugins/list/";
            String channelListUrl = pluginsElement.getAttributeValue(ATTRIBUTE_CHANNEL_LIST_URL);
            this.myChannelsListUrl = channelListUrl != null ? channelListUrl : this.myPluginManagerUrl + (closed ? "" : "/") + "channels/list/";
            String downloadUrl = pluginsElement.getAttributeValue(ATTRIBUTE_DOWNLOAD_URL);
            String string = downloadUrl != null ? downloadUrl : (this.myPluginsDownloadUrl = this.myPluginManagerUrl + (closed ? "" : "/") + "pluginManager/");
            if (!this.getBuild().isSnapshot()) {
                this.myBuiltinPluginsUrl = pluginsElement.getAttributeValue(ATTRIBUTE_BUILTIN_URL);
            }
        } else {
            this.myPluginManagerUrl = DEFAULT_PLUGINS_HOST;
            this.myPluginsListUrl = "http://plugins.jetbrains.com/plugins/list/";
            this.myChannelsListUrl = "http://plugins.jetbrains.com/channels/list/";
            this.myPluginsDownloadUrl = "http://plugins.jetbrains.com/pluginManager/";
        }
        String pluginsHost = System.getProperty("idea.plugins.host");
        if (pluginsHost != null) {
            this.myPluginsListUrl = this.myPluginsListUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
            this.myChannelsListUrl = this.myChannelsListUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
            this.myPluginsDownloadUrl = this.myPluginsDownloadUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
        }
        if ((keymapElement = parentNode.getChild(ELEMENT_KEYMAP)) != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_WINDOWS_URL);
            this.myMacKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_MAC_URL);
        }
        this.myPluginChooserPages = new ArrayList<ApplicationInfoEx.PluginChooserPage>();
        List children = parentNode.getChildren(PLUGINS_PAGE_ELEMENT_NAME);
        for (Object child : children) {
            this.myPluginChooserPages.add(new PluginChooserPageImpl((Element)child));
        }
        List<Element> essentialPluginsElements = JDOMUtil.getChildren(parentNode, ESSENTIAL_PLUGIN);
        List<String> essentialPluginsIds = ContainerUtil.mapNotNull(essentialPluginsElements, new Function<Element, String>(){

            @Override
            public String fun(Element element) {
                String id = element.getTextTrim();
                return StringUtil.isNotEmpty(id) ? id : null;
            }
        });
        this.myEssentialPluginsIds = ArrayUtil.toStringArray(essentialPluginsIds);
        Element statisticsElement = parentNode.getChild(ELEMENT_STATISTICS);
        if (statisticsElement != null) {
            this.myStatisticsSettingsUrl = statisticsElement.getAttributeValue(ATTRIBUTE_STATISTICS_SETTINGS);
            this.myStatisticsServiceUrl = statisticsElement.getAttributeValue(ATTRIBUTE_STATISTICS_SERVICE);
            this.myStatisticsServiceKey = statisticsElement.getAttributeValue(ATTRIBUTE_STATISTICS_SERVICE_KEY);
        } else {
            this.myStatisticsSettingsUrl = "https://www.jetbrains.com/idea/statistics/stat-assistant.xml";
            this.myStatisticsServiceUrl = "https://www.jetbrains.com/idea/statistics/index.jsp";
            this.myStatisticsServiceKey = null;
        }
        Element thirdPartyElement = parentNode.getChild(ELEMENT_THIRD_PARTY);
        if (thirdPartyElement != null) {
            this.myThirdPartySoftwareUrl = thirdPartyElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((tvElement = parentNode.getChild(ELEMENT_JB_TV)) != null) {
            this.myJetbrainsTvUrl = tvElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((evaluationElement = parentNode.getChild(ELEMENT_EVALUATION)) != null && (url2 = evaluationElement.getAttributeValue(ATTRIBUTE_EVAL_LICENSE_URL)) != null && !url2.isEmpty()) {
            this.myEvalLicenseUrl = url2.trim();
        }
        if ((licensingElement = parentNode.getChild(ELEMENT_LICENSING)) != null && (url = licensingElement.getAttributeValue(ATTRIBUTE_KEY_CONVERSION_URL)) != null && !url.isEmpty()) {
            this.myKeyConversionUrl = url.trim();
        }
    }

    private static void setBuildNumber(String apiVersion, String buildNumber) {
        PluginManagerCore.BUILD_NUMBER = apiVersion != null ? apiVersion : buildNumber;
    }

    private static GregorianCalendar parseDate(String dateString) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        try {
            year = Integer.parseInt(dateString.substring(0, 4));
            month = Integer.parseInt(dateString.substring(4, 6));
            day = Integer.parseInt(dateString.substring(6, 8));
            if (dateString.length() > 8) {
                hour = Integer.parseInt(dateString.substring(8, 10));
                minute = Integer.parseInt(dateString.substring(10, 12));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (month > 0) {
            --month;
        }
        return new GregorianCalendar(year, month, day, hour, minute);
    }

    private static Color parseColor(String colorString) {
        long rgb = Long.parseLong(colorString, 16);
        return new Color((int)rgb, rgb > 0xFFFFFFL);
    }

    @Override
    public List<ApplicationInfoEx.PluginChooserPage> getPluginChooserPages() {
        return this.myPluginChooserPages;
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/openapi/application/impl/ApplicationInfoImpl", "isEssentialPlugin"));
        }
        return "com.intellij".equals(pluginId) || ArrayUtil.contains(pluginId, this.myEssentialPluginsIds);
    }

    public static boolean isInPerformanceTest() {
        return myInPerformanceTest;
    }

    public static void setInPerformanceTest(boolean inPerformanceTest) {
        myInPerformanceTest = inPerformanceTest;
    }

    private static class PluginChooserPageImpl
    implements ApplicationInfoEx.PluginChooserPage {
        private final String myTitle;
        private final String myCategory;
        private final String myDependentPlugin;

        private PluginChooserPageImpl(Element e) {
            this.myTitle = e.getAttributeValue("title");
            this.myCategory = e.getAttributeValue("category");
            this.myDependentPlugin = e.getAttributeValue("depends");
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        public String getCategory() {
            return this.myCategory;
        }

        @Override
        public String getDependentPlugin() {
            return this.myDependentPlugin;
        }
    }

    private static class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private String myCheckingUrl;
        private String myPatchesUrl;

        private UpdateUrlsImpl(Element element) {
            if (element != null) {
                this.myCheckingUrl = element.getAttributeValue("check");
                this.myPatchesUrl = element.getAttributeValue("patches");
            }
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }
    }
}

