/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class GeneratedSourcesFilter {
    public static final ExtensionPointName<GeneratedSourcesFilter> EP_NAME = ExtensionPointName.create("com.intellij.generatedSourcesFilter");

    public static boolean isGeneratedSourceByAnyFilter(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/GeneratedSourcesFilter", "isGeneratedSourceByAnyFilter"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/GeneratedSourcesFilter", "isGeneratedSourceByAnyFilter"));
        }
        for (GeneratedSourcesFilter filter : EP_NAME.getExtensions()) {
            if (!filter.isGeneratedSource(file, project)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isGeneratedSource(@NotNull VirtualFile var1, @NotNull Project var2);

    @NotNull
    public List<? extends PsiElement> getOriginalElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getOriginalElements"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/GeneratedSourcesFilter", "getOriginalElements"));
        }
        return list;
    }
}

