/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class NumberEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("number.comparison.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NumberEqualityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("number.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NumberEqualityInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NumberEqualityVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualityToEqualsFix();
    }

    private static class NumberEqualityVisitor
    extends BaseInspectionVisitor {
        private NumberEqualityVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/NumberEqualityInspection$NumberEqualityVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null || !ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!NumberEqualityVisitor.hasNumberType(lhs) || !NumberEqualityVisitor.hasNumberType(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
        }

        private static boolean hasNumberType(PsiExpression expression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.Number");
        }
    }
}

