/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class RecordStoreResourceInspection
extends ResourceInspection {
    @Override
    @NotNull
    public String getID() {
        if ("RecordStoreOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/RecordStoreResourceInspection", "getID"));
        }
        return "RecordStoreOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("recordstore.opened.not.safely.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/RecordStoreResourceInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        return MethodCallUtils.isCallToMethod(methodCallExpression, "javax.microedition.rms.RecordStore", null, "openRecordStore", null);
    }

    @Override
    protected boolean isResourceClose(PsiMethodCallExpression call, PsiVariable resource) {
        return MethodCallUtils.isMethodCallOnVariable(call, resource, "closeRecordStore");
    }
}

