/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.findUsages;

import com.intellij.lang.Language;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import org.jetbrains.annotations.NotNull;

public class DescriptiveNameUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.findUsages.DescriptiveNameUtil");

    @NotNull
    public static String getMetaDataName(@NotNull PsiMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/lang/findUsages/DescriptiveNameUtil", "getMetaDataName"));
        }
        String name = metaData.getName();
        String string = StringUtil.isEmpty(name) ? "''" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/findUsages/DescriptiveNameUtil", "getMetaDataName"));
        }
        return string;
    }

    @NotNull
    public static String getDescriptiveName(@NotNull PsiElement psiElement) {
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/findUsages/DescriptiveNameUtil", "getDescriptiveName"));
        }
        LOG.assertTrue(psiElement.isValid());
        if (psiElement instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)((Object)psiElement)).getMetaData()) != null) {
            String string = DescriptiveNameUtil.getMetaDataName(metaData);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/findUsages/DescriptiveNameUtil", "getDescriptiveName"));
            }
            return string;
        }
        Language lang = psiElement.getLanguage();
        FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(lang);
        assert (provider != null) : lang;
        String string = provider.getDescriptiveName(psiElement);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/findUsages/DescriptiveNameUtil", "getDescriptiveName"));
        }
        return string;
    }
}

