/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleSourceOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    static final String ENTRY_TYPE = "sourceFolder";
    @NonNls
    private static final String ATTRIBUTE_FOR_TESTS = "forTests";

    ModuleSourceOrderEntryImpl(RootModelImpl rootModel) {
        super(rootModel);
    }

    ModuleSourceOrderEntryImpl(Element element, RootModelImpl rootModel) throws InvalidDataException {
        super(rootModel);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element.setAttribute("type", ENTRY_TYPE);
        element.setAttribute(ATTRIBUTE_FOR_TESTS, Boolean.FALSE.toString());
        rootElement.addContent(element);
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed();
    }

    @Override
    @NotNull
    public Module getOwnerModule() {
        Module module = ((RootModelImpl)this.getRootModel()).getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl", "getOwnerModule"));
        }
        return module;
    }

    @Override
    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return policy.visitModuleSourceOrderEntry(this, initialValue);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message("project.root.module.source", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        if (OrderRootType.SOURCES.equals(type)) {
            VirtualFile[] virtualFileArray = ((RootModelBase)this.getRootModel()).getSourceRoots();
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl", "getFiles"));
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl", "getFiles"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String[] getUrls(OrderRootType type) {
        ArrayList<String> result = new ArrayList<String>();
        if (OrderRootType.SOURCES.equals(type)) {
            for (ContentEntry contentEntry : ((RootModelBase)this.getRootModel()).getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    result.add(sourceFolder.getUrl());
                }
            }
            String[] stringArray = ArrayUtil.toStringArray(result);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl", "getUrls"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl", "getUrls"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new ModuleSourceOrderEntryImpl(rootModel);
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }
}

