/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.util.ReflectionUtil;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckBox
extends JCheckBox {
    public CheckBox(@NotNull String label, @NotNull InspectionProfileEntry owner, @NonNls String property) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/util/ui/CheckBox", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/ui/CheckBox", "<init>"));
        }
        super(label, CheckBox.getPropertyValue(owner, property));
        ButtonModel model = this.getModel();
        SingleCheckboxChangeListener listener = new SingleCheckboxChangeListener(owner, property, model);
        model.addChangeListener(listener);
    }

    private static boolean getPropertyValue(InspectionProfileEntry owner, String property) {
        return ReflectionUtil.getField(owner.getClass(), owner, Boolean.TYPE, property);
    }

    private static class SingleCheckboxChangeListener
    implements ChangeListener {
        private final InspectionProfileEntry owner;
        private final String property;
        private final ButtonModel model;

        SingleCheckboxChangeListener(InspectionProfileEntry owner, String property, ButtonModel model) {
            this.owner = owner;
            this.property = property;
            this.model = model;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SingleCheckboxChangeListener.setPropertyValue(this.owner, this.property, this.model.isSelected());
        }

        private static void setPropertyValue(InspectionProfileEntry owner, String property, boolean selected) {
            ReflectionUtil.setField(owner.getClass(), owner, Boolean.TYPE, property, selected);
        }
    }
}

