/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextBase
extends UserDataHolderBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    private static final TObjectHashingStrategy<Tools> TOOLS_HASHING_STRATEGY = new TObjectHashingStrategy<Tools>(){

        public int computeHashCode(Tools object) {
            return object.getShortName().hashCode();
        }

        public boolean equals(Tools o1, Tools o2) {
            return o1.getShortName().equals(o2.getShortName());
        }
    };
    private RefManager myRefManager;
    private AnalysisScope myCurrentScope;
    @NotNull
    private final Project myProject;
    private final List<JobDescriptor> myJobDescriptors;
    private final StdJobDescriptors myStdJobDescriptors;
    protected ProgressIndicator myProgressIndicator;
    private InspectionProfile myExternalProfile;
    protected final Map<Key, GlobalInspectionContextExtension> myExtensions;
    protected final Map<String, Tools> myTools;
    @NonNls
    public static final String LOCAL_TOOL_ATTRIBUTE = "is_local_tool";

    public GlobalInspectionContextBase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "<init>"));
        }
        this.myJobDescriptors = new ArrayList<JobDescriptor>();
        this.myStdJobDescriptors = new StdJobDescriptors();
        this.myProgressIndicator = new EmptyProgressIndicator();
        this.myExtensions = new HashMap<Key, GlobalInspectionContextExtension>();
        this.myTools = new THashMap();
        this.myProject = project;
        for (InspectionExtensionsFactory factory : Extensions.getExtensions(InspectionExtensionsFactory.EP_NAME)) {
            GlobalInspectionContextExtension extension = factory.createGlobalInspectionContextExtension();
            this.myExtensions.put(extension.getID(), extension);
        }
    }

    AnalysisScope getCurrentScope() {
        return this.myCurrentScope;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "getProject"));
        }
        return project;
    }

    @Override
    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "getExtension"));
        }
        return (T)this.myExtensions.get(key);
    }

    public InspectionProfile getCurrentProfile() {
        if (this.myExternalProfile != null) {
            return this.myExternalProfile;
        }
        InspectionManagerBase managerEx = (InspectionManagerBase)InspectionManager.getInstance(this.myProject);
        String currentProfile = managerEx.getCurrentProfile();
        InspectionProjectProfileManager inspectionProfileManager = InspectionProjectProfileManager.getInstance(this.myProject);
        Profile profile = inspectionProfileManager.getProfile(currentProfile, false);
        if (profile == null) {
            profile = InspectionProfileManager.getInstance().getProfile(currentProfile);
            if (profile != null) {
                return (InspectionProfile)profile;
            }
            String[] availableProfileNames = inspectionProfileManager.getAvailableProfileNames();
            if (availableProfileNames.length == 0) {
                return null;
            }
            profile = inspectionProfileManager.getProfile(availableProfileNames[0]);
        }
        return (InspectionProfile)profile;
    }

    @Override
    public boolean isSuppressed(@NotNull RefEntity entity, @NotNull String id) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "isSuppressed"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "isSuppressed"));
        }
        return entity instanceof RefElementImpl && ((RefElementImpl)entity).isSuppressed(id);
    }

    @Override
    public boolean shouldCheck(@NotNull RefEntity entity, @NotNull GlobalInspectionTool tool) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "shouldCheck"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "shouldCheck"));
        }
        return !(entity instanceof RefElementImpl) || this.isToCheckMember((RefElementImpl)entity, tool);
    }

    @Override
    public boolean isSuppressed(@NotNull PsiElement element, @NotNull String id) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "isSuppressed"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "isSuppressed"));
        }
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        if (refManager.isDeclarationsFound()) {
            RefElement refElement = refManager.getReference(element);
            return refElement instanceof RefElementImpl && ((RefElementImpl)refElement).isSuppressed(id);
        }
        return SuppressionUtil.isSuppressed(element, id);
    }

    void cleanupTools() {
        this.myProgressIndicator.cancel();
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                toolWrapper.cleanup(this.myProject);
            }
        }
        this.myTools.clear();
        EntryPointsManager entryPointsManager = EntryPointsManager.getInstance(this.getProject());
        if (entryPointsManager != null) {
            entryPointsManager.cleanup();
        }
        if (this.myRefManager != null) {
            ((RefManagerImpl)this.myRefManager).cleanup();
            this.myRefManager = null;
            if (this.myCurrentScope != null) {
                this.myCurrentScope.invalidate();
                this.myCurrentScope = null;
            }
        }
        this.myJobDescriptors.clear();
    }

    public void setCurrentScope(@NotNull AnalysisScope currentScope) {
        if (currentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "setCurrentScope"));
        }
        this.myCurrentScope = currentScope;
    }

    public void doInspections(final @NotNull AnalysisScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "doInspections"));
        }
        if (!GlobalInspectionContextUtil.canRunInspections(this.myProject, true)) {
            return;
        }
        this.cleanup();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GlobalInspectionContextBase.this.myCurrentScope = scope;
                GlobalInspectionContextBase.this.launchInspections(scope);
            }
        }, ApplicationManager.getApplication().getDisposed());
    }

    @Override
    @NotNull
    public RefManager getRefManager() {
        if (this.myRefManager == null) {
            this.myRefManager = ApplicationManager.getApplication().runReadAction(new Computable<RefManagerImpl>(){

                @Override
                public RefManagerImpl compute() {
                    return new RefManagerImpl(GlobalInspectionContextBase.this.myProject, GlobalInspectionContextBase.this.myCurrentScope, GlobalInspectionContextBase.this);
                }
            });
        }
        RefManager refManager = this.myRefManager;
        if (refManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "getRefManager"));
        }
        return refManager;
    }

    public boolean isToCheckMember(@NotNull RefElement owner, @NotNull InspectionProfileEntry tool) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "isToCheckMember"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "isToCheckMember"));
        }
        return this.isToCheckFile(((RefElementImpl)owner).getContainingFile(), tool) && !((RefElementImpl)owner).isSuppressed(tool.getShortName());
    }

    public boolean isToCheckFile(PsiFile file, @NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "isToCheckFile"));
        }
        Tools tools = this.myTools.get(tool.getShortName());
        if (tools != null && file != null) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope namedScope = state.getScope(file.getProject());
                if (namedScope != null && !namedScope.getValue().contains(file, this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
                return state.isEnabled() && state.getTool().getTool() == tool;
            }
        }
        return false;
    }

    protected void launchInspections(final @NotNull AnalysisScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "launchInspections"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        LOG.info("Code inspection started");
        ProgressManager.getInstance().run(new Task.Backgroundable(this.getProject(), InspectionsBundle.message("inspection.progress.title", new Object[0]), true, this.createOption()){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextBase$4", "run"));
                }
                GlobalInspectionContextBase.this.performInspectionsWithProgress(scope, false, false);
            }

            @Override
            public void onSuccess() {
                GlobalInspectionContextBase.this.notifyInspectionsFinished();
            }
        });
    }

    @NotNull
    protected PerformInBackgroundOption createOption() {
        PerformInBackgroundOption performInBackgroundOption = new PerformInBackgroundOption(){

            @Override
            public boolean shouldStartInBackground() {
                return true;
            }

            @Override
            public void processSentToBackground() {
            }
        };
        if (performInBackgroundOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "createOption"));
        }
        return performInBackgroundOption;
    }

    protected void notifyInspectionsFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInspectionsWithProgress(final @NotNull AnalysisScope scope, final boolean runGlobalToolsOnly, final boolean isOfflineInspections) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "performInspectionsWithProgress"));
        }
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (this.myProgressIndicator == null) {
            throw new IllegalStateException("Inspections must be run under progress");
        }
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        try {
            psiManager.startBatchFilesProcessingMode();
            refManager.inspectionReadActionStarted();
            this.getStdJobDescriptors().BUILD_GRAPH.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().LOCAL_ANALYSIS.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().FIND_EXTERNAL_USAGES.setTotalAmount(0);
            ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                @Override
                public void run() {
                    GlobalInspectionContextBase.this.runTools(scope, runGlobalToolsOnly, isOfflineInspections);
                }
            }, ProgressWrapper.wrap(this.myProgressIndicator));
        }
        catch (ProcessCanceledException e) {
            this.cleanup();
            throw e;
        }
        catch (IndexNotReadyException e) {
            this.cleanup();
            DumbService.getInstance(this.myProject).showDumbModeNotification("Usage search is not available until indices are ready");
            throw new ProcessCanceledException();
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            refManager.inspectionReadActionFinished();
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "runTools"));
        }
    }

    public void initializeTools(@NotNull List<Tools> outGlobalTools, @NotNull List<Tools> outLocalTools, @NotNull List<Tools> outGlobalSimpleTools) {
        if (outGlobalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outGlobalTools", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "initializeTools"));
        }
        if (outLocalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outLocalTools", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "initializeTools"));
        }
        if (outGlobalSimpleTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outGlobalSimpleTools", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "initializeTools"));
        }
        List<Tools> usedTools = this.getUsedTools();
        for (Tools currentTools : usedTools) {
            JobDescriptor[] jobDescriptors;
            String shortName = currentTools.getShortName();
            this.myTools.put(shortName, currentTools);
            InspectionToolWrapper toolWrapper = currentTools.getTool();
            GlobalInspectionContextBase.classifyTool(outGlobalTools, outLocalTools, outGlobalSimpleTools, currentTools, toolWrapper);
            for (ScopeToolState state : currentTools.getTools()) {
                state.getTool().initialize(this);
            }
            for (JobDescriptor jobDescriptor : jobDescriptors = toolWrapper.getJobDescriptors(this)) {
                this.appendJobDescriptor(jobDescriptor);
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.performPreRunActivities(outGlobalTools, outLocalTools, this);
        }
    }

    @NotNull
    protected List<Tools> getUsedTools() {
        InspectionProfileImpl profile = new InspectionProfileImpl((InspectionProfileImpl)this.getCurrentProfile());
        List<Tools> tools = profile.getAllEnabledInspectionTools(this.myProject);
        LinkedHashSet<InspectionToolWrapper> dependentTools = new LinkedHashSet<InspectionToolWrapper>();
        for (Tools tool : tools) {
            profile.collectDependentInspections(tool.getTool(), dependentTools, this.getProject());
        }
        if (dependentTools.isEmpty()) {
            List<Tools> list = tools;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "getUsedTools"));
            }
            return list;
        }
        THashSet set = new THashSet(tools, TOOLS_HASHING_STRATEGY);
        set.addAll(ContainerUtil.map(dependentTools, new Function<InspectionToolWrapper, ToolsImpl>(){

            @Override
            public ToolsImpl fun(InspectionToolWrapper toolWrapper) {
                return new ToolsImpl(toolWrapper, toolWrapper.getDefaultLevel(), true, true);
            }
        }));
        ArrayList<Tools> arrayList = new ArrayList<Tools>((Collection<Tools>)set);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "getUsedTools"));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void classifyTool(@NotNull List<Tools> outGlobalTools, @NotNull List<Tools> outLocalTools, @NotNull List<Tools> outGlobalSimpleTools, @NotNull Tools currentTools, @NotNull InspectionToolWrapper toolWrapper) {
        if (outGlobalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outGlobalTools", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "classifyTool"));
        }
        if (outLocalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outLocalTools", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "classifyTool"));
        }
        if (outGlobalSimpleTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outGlobalSimpleTools", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "classifyTool"));
        }
        if (currentTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTools", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "classifyTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "classifyTool"));
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            outLocalTools.add(currentTools);
            return;
        } else {
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) throw new RuntimeException("unknown tool " + toolWrapper);
            if (toolWrapper.getTool() instanceof GlobalSimpleInspectionTool) {
                outGlobalSimpleTools.add(currentTools);
                return;
            } else {
                if (!(toolWrapper.getTool() instanceof GlobalInspectionTool)) throw new RuntimeException("unknown global tool " + toolWrapper);
                outGlobalTools.add(currentTools);
            }
        }
    }

    @NotNull
    public Map<String, Tools> getTools() {
        Map<String, Tools> map = this.myTools;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "getTools"));
        }
        return map;
    }

    private void appendJobDescriptor(@NotNull JobDescriptor job) {
        if (job == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "job", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "appendJobDescriptor"));
        }
        if (!this.myJobDescriptors.contains(job)) {
            this.myJobDescriptors.add(job);
            job.setDoneAmount(0);
        }
    }

    public void codeCleanup(@NotNull Project project, @NotNull AnalysisScope scope, @NotNull InspectionProfile profile, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "codeCleanup"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "codeCleanup"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "codeCleanup"));
        }
    }

    public static void codeCleanup(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable Runnable runnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "codeCleanup"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "codeCleanup"));
        }
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance(project).createNewGlobalContext(false);
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        globalContext.codeCleanup(project, scope, profile, null, runnable, false);
    }

    public static void cleanupElements(final @NotNull Project project, final @Nullable Runnable runnable, PsiElement ... scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "cleanupElements"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "cleanupElements"));
        }
        final ArrayList<SmartPsiElementPointer<PsiElement>> elements = new ArrayList<SmartPsiElementPointer<PsiElement>>();
        SmartPointerManager manager = SmartPointerManager.getInstance(project);
        for (PsiElement element : scope) {
            elements.add(manager.createSmartPsiElementPointer(element));
        }
        Runnable cleanupRunnable = new Runnable(){

            @Override
            public void run() {
                ArrayList psiElements = new ArrayList();
                for (SmartPsiElementPointer element : elements) {
                    Object psiElement = element.getElement();
                    if (psiElement == null || !psiElement.isPhysical()) continue;
                    psiElements.add(psiElement);
                }
                if (psiElements.isEmpty()) {
                    return;
                }
                GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance(project).createNewGlobalContext(false);
                InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
                AnalysisScope analysisScope = new AnalysisScope(new LocalSearchScope(psiElements.toArray(new PsiElement[psiElements.size()])), project);
                globalContext.codeCleanup(project, analysisScope, profile, null, runnable, true);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !application.isUnitTestMode()) {
            application.invokeLater(cleanupRunnable);
        } else {
            cleanupRunnable.run();
        }
    }

    public void close(boolean noSuspisiousCodeFound) {
        this.cleanup();
    }

    @Override
    public void cleanup() {
        this.cleanupTools();
    }

    @Override
    public void incrementJobDoneAmount(@NotNull JobDescriptor job, @NotNull String message) {
        if (job == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "job", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "incrementJobDoneAmount"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "incrementJobDoneAmount"));
        }
        if (this.myProgressIndicator == null) {
            return;
        }
        ProgressManager.checkCanceled();
        int old = job.getDoneAmount();
        job.setDoneAmount(old + 1);
        float totalProgress = this.getTotalProgress();
        this.myProgressIndicator.setFraction(totalProgress);
        this.myProgressIndicator.setText(job.getDisplayName() + " " + message);
    }

    private float getTotalProgress() {
        float totalDone = 0.0f;
        int totalTotal = 0;
        for (JobDescriptor jobDescriptor : this.myJobDescriptors) {
            totalDone += (float)jobDescriptor.getDoneAmount();
            totalTotal += jobDescriptor.getTotalAmount();
        }
        return totalTotal == 0 ? 1.0f : totalDone / (float)totalTotal;
    }

    public void setExternalProfile(InspectionProfile profile) {
        this.myExternalProfile = profile;
    }

    @Override
    @NotNull
    public StdJobDescriptors getStdJobDescriptors() {
        StdJobDescriptors stdJobDescriptors = this.myStdJobDescriptors;
        if (stdJobDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextBase", "getStdJobDescriptors"));
        }
        return stdJobDescriptors;
    }
}

