/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousCollectionsMethodCallsInspection
extends BaseJavaBatchLocalInspectionTool {
    public boolean REPORT_CONVERTIBLE_METHOD_CALLS = true;

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message("report.suspicious.but.possibly.correct.method.calls", new Object[0]), this, "REPORT_CONVERTIBLE_METHOD_CALLS");
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection", "buildVisitor"));
        }
        final ArrayList patternMethods = new ArrayList();
        final IntArrayList indices = new IntArrayList();
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression(expression);
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                super.visitMethodCallExpression(methodCall);
                String message = SuspiciousCollectionsMethodCallsInspection.getSuspiciousMethodCallMessage(methodCall, SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS, patternMethods, indices);
                if (message != null) {
                    holder.registerProblem((PsiElement)methodCall.getArgumentList().getExpressions()[0], message, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.suspicious.collections.method.calls.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("SuspiciousMethodCalls" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection", "getShortName"));
        }
        return "SuspiciousMethodCalls";
    }

    @Nullable
    private static String getSuspiciousMethodCallMessage(PsiMethodCallExpression methodCall, boolean reportConvertibleMethodCalls, List<PsiMethod> patternMethods, IntArrayList indices) {
        PsiType dfaType;
        PsiExpression[] args = methodCall.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiType argType = args[0].getType();
        String plainMessage = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, argType, reportConvertibleMethodCalls, patternMethods, indices);
        if (plainMessage != null && (dfaType = GuessManager.getInstance(methodCall.getProject()).getControlFlowExpressionType(args[0])) != null && SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, dfaType, reportConvertibleMethodCalls, patternMethods, indices) == null) {
            return null;
        }
        return plainMessage;
    }
}

