/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SimpleTimer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimpleTimerTask {
    private final long myTargetTime;
    private final Runnable myRunnable;
    private boolean myCancelled;
    private final Object LOCK;
    private final SimpleTimer myTimer;

    /*
     * WARNING - void declaration
     */
    public SimpleTimerTask(long targetTime, @NotNull Runnable runnable, @NotNull SimpleTimer simpleTimer) {
        void timer;
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/SimpleTimerTask", "<init>"));
        }
        if (simpleTimer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timer", "com/intellij/openapi/util/SimpleTimerTask", "<init>"));
        }
        this.LOCK = new Object();
        this.myTargetTime = targetTime;
        this.myRunnable = runnable;
        this.myTimer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myCancelled = true;
            this.myTimer.onCancelled(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myCancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myCancelled) {
                this.myRunnable.run();
            }
        }
    }

    long getTargetTime() {
        return this.myTargetTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNls
    public String toString() {
        Object object = this.LOCK;
        synchronized (object) {
            return "targetTime=" + this.myTargetTime + " cancelled=" + this.myCancelled + " runnable=" + this.myRunnable;
        }
    }
}

