/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.equalsAndHashcode;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsAndHashcodeBase
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase", "buildVisitor"));
        }
        final Project project = holder.getProject();
        Pair<PsiMethod, PsiMethod> pair = CachedValuesManager.getManager(project).getCachedValue(project, new CachedValueProvider<Pair<PsiMethod, PsiMethod>>(){

            @Override
            public CachedValueProvider.Result<Pair<PsiMethod, PsiMethod>> compute() {
                final JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
                PsiClass psiObjectClass = ApplicationManager.getApplication().runReadAction(new Computable<PsiClass>(){

                    @Override
                    @Nullable
                    public PsiClass compute() {
                        return psiFacade.findClass("java.lang.Object", GlobalSearchScope.allScope(project));
                    }
                });
                if (psiObjectClass == null) {
                    return CachedValueProvider.Result.create(null, ProjectRootManager.getInstance(project));
                }
                PsiMethod[] methods = psiObjectClass.getMethods();
                PsiMethod myEquals = null;
                PsiMethod myHashCode = null;
                for (PsiMethod method : methods) {
                    String name = method.getName();
                    if ("equals".equals(name)) {
                        myEquals = method;
                        continue;
                    }
                    if (!"hashCode".equals(name)) continue;
                    myHashCode = method;
                }
                return CachedValueProvider.Result.create(Pair.create(myEquals, myHashCode), psiObjectClass);
            }
        });
        if (pair == null) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        final PsiMethod myEquals = (PsiMethod)pair.first;
        final PsiMethod myHashCode = (PsiMethod)pair.second;
        if (myEquals == null || myHashCode == null || !myEquals.isValid() || !myHashCode.isValid()) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                boolean[] hasEquals = new boolean[]{false};
                boolean[] hasHashCode = new boolean[]{false};
                EqualsAndHashcodeBase.processClass(aClass, hasEquals, hasHashCode, myEquals, myHashCode);
                if (hasEquals[0] != hasHashCode[0]) {
                    PsiIdentifier identifier = aClass.getNameIdentifier();
                    holder.registerProblem(identifier != null ? identifier : aClass, hasEquals[0] ? InspectionsBundle.message("inspection.equals.hashcode.only.one.defined.problem.descriptor", "<code>equals()</code>", "<code>hashCode()</code>") : InspectionsBundle.message("inspection.equals.hashcode.only.one.defined.problem.descriptor", "<code>hashCode()</code>", "<code>equals()</code>"), EqualsAndHashcodeBase.this.buildFixes(isOnTheFly, hasEquals[0]));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void processClass(PsiClass aClass, boolean[] hasEquals, boolean[] hasHashCode, PsiMethod equals, PsiMethod hashcode) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (MethodSignatureUtil.areSignaturesEqual(method, equals)) {
                hasEquals[0] = true;
                continue;
            }
            if (!MethodSignatureUtil.areSignaturesEqual(method, hashcode)) continue;
            hasHashCode[0] = true;
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.equals.hashcode.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase", "getGroupDisplayName"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("EqualsAndHashcode" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase", "getShortName"));
        }
        return "EqualsAndHashcode";
    }

    protected LocalQuickFix[] buildFixes(boolean isOnTheFly, boolean hasEquals) {
        return LocalQuickFix.EMPTY_ARRAY;
    }
}

