/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessCanBeTightenedInspection
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    private static final String SHORT_NAME = "AccessCanBeTightened";

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VISIBILITY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Member access can be tightened" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "getDisplayName"));
        }
        return "Member access can be tightened";
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "buildVisitor"));
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    private static void log(String s) {
    }

    private static class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final UnusedDeclarationInspectionBase myDeadCodeInspection;
        private final Set<PsiClass> childMembersAreUsedOutsideMyPackage;

        public MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "<init>"));
            }
            this.childMembersAreUsedOutsideMyPackage = ContainerUtil.newConcurrentSet();
            this.myHolder = holder;
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(holder.getProject()).getInspectionProfile();
            UnusedDeclarationInspectionBase tool = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)holder.getFile());
            this.myDeadCodeInspection = tool == null ? new UnusedDeclarationInspectionBase() : tool;
        }

        @Override
        public void visitClass(PsiClass aClass) {
            this.checkMember(aClass);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            this.checkMember(method);
        }

        @Override
        public void visitField(PsiField field) {
            this.checkMember(field);
        }

        private void checkMember(@NotNull PsiMember member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "checkMember"));
            }
            if (member.hasModifierProperty("private") || member.hasModifierProperty("native")) {
                return;
            }
            if (member instanceof PsiMethod && member instanceof SyntheticElement || !member.isPhysical()) {
                return;
            }
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (!method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overrides");
                    return;
                }
                if (MethodUtils.isOverridden(method)) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overridden");
                    return;
                }
            }
            if (member instanceof PsiEnumConstant) {
                return;
            }
            if (member instanceof PsiClass && (member instanceof PsiAnonymousClass || member instanceof PsiTypeParameter || member instanceof PsiSyntheticClass || PsiUtil.isLocalClass((PsiClass)member))) {
                return;
            }
            final PsiClass memberClass = member.getContainingClass();
            if (memberClass != null && (memberClass.isInterface() || memberClass.isEnum() || memberClass.isAnnotationType() || PsiUtil.isLocalClass(memberClass) && member instanceof PsiClass)) {
                return;
            }
            final PsiFile memberFile = member.getContainingFile();
            Project project = memberFile.getProject();
            if (this.myDeadCodeInspection.isEntryPoint(member)) {
                AccessCanBeTightenedInspection.log(member.getName() + " is entry point");
                return;
            }
            PsiModifierList memberModifierList = member.getModifierList();
            if (memberModifierList == null) {
                return;
            }
            final int currentLevel = PsiUtil.getAccessLevel(memberModifierList);
            final AtomicInteger maxLevel = new AtomicInteger(1);
            final AtomicBoolean foundUsage = new AtomicBoolean();
            PsiDirectory memberDirectory = memberFile.getContainingDirectory();
            final PsiPackage memberPackage = memberDirectory == null ? null : JavaDirectoryService.getInstance().getPackage(memberDirectory);
            AccessCanBeTightenedInspection.log(member.getName() + ": checking effective level for " + member);
            boolean result = UnusedSymbolUtil.processUsages(project, memberFile, member, new EmptyProgressIndicator(), null, new Processor<UsageInfo>(){

                @Override
                public boolean process(UsageInfo info) {
                    int oldLevel;
                    foundUsage.set(true);
                    PsiFile psiFile = info.getFile();
                    if (psiFile == null) {
                        return true;
                    }
                    if (!(psiFile instanceof PsiJavaFile)) {
                        AccessCanBeTightenedInspection.log("     refd from " + psiFile.getName() + "; set to public");
                        maxLevel.set(4);
                        if (memberClass != null) {
                            MyVisitor.this.childMembersAreUsedOutsideMyPackage.add(memberClass);
                        }
                        return false;
                    }
                    PsiElement element = info.getElement();
                    if (element == null) {
                        return true;
                    }
                    int level = MyVisitor.getEffectiveLevel(element, psiFile, memberFile, memberClass, memberPackage);
                    AccessCanBeTightenedInspection.log("    ref in file " + psiFile.getName() + "; level = " + PsiUtil.getAccessModifier(level) + "; (" + element + ")");
                    while (level > (oldLevel = maxLevel.get()) && !maxLevel.compareAndSet(oldLevel, level)) {
                    }
                    if (level == 4 && memberClass != null) {
                        MyVisitor.this.childMembersAreUsedOutsideMyPackage.add(memberClass);
                    }
                    return level != 4;
                }
            });
            if (!foundUsage.get()) {
                AccessCanBeTightenedInspection.log(member.getName() + " unused; ignore");
                return;
            }
            int max = maxLevel.get();
            if (max == 1 && memberClass == null) {
                max = 2;
            }
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + PsiUtil.getAccessModifier(max) + "'");
            if (max < currentLevel) {
                PsiElement toHighlight;
                if (max == 2 && member instanceof PsiClass && this.childMembersAreUsedOutsideMyPackage.contains(member)) {
                    AccessCanBeTightenedInspection.log(member.getName() + "  children used outside my package; ignore");
                    return;
                }
                PsiElement psiElement = toHighlight = currentLevel == 2 ? ((PsiNameIdentifierOwner)((Object)member)).getNameIdentifier() : ContainerUtil.find(memberModifierList.getChildren(), new Condition<PsiElement>(){

                    @Override
                    public boolean value(PsiElement element) {
                        return element instanceof PsiKeyword && element.getText().equals(PsiUtil.getAccessModifier(currentLevel));
                    }
                });
                assert (toHighlight != null) : member + " ; " + ((PsiNameIdentifierOwner)((Object)member)).getNameIdentifier() + "; " + memberModifierList.getText();
                this.myHolder.registerProblem(toHighlight, "Access can be " + PsiUtil.getAccessModifier(max), new ChangeModifierFix(PsiUtil.getAccessModifier(max)));
            }
        }

        @PsiUtil.AccessLevel
        private static int getEffectiveLevel(@NotNull PsiElement element, @NotNull PsiFile file, @NotNull PsiFile memberFile, PsiClass memberClass, PsiPackage memberPackage) {
            PsiPackage aPackage;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "getEffectiveLevel"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "getEffectiveLevel"));
            }
            if (memberFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberFile", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "getEffectiveLevel"));
            }
            PsiClass aClass = PsiTreeUtil.getParentOfType(element, PsiClass.class);
            if (memberClass != null && PsiTreeUtil.isAncestor(aClass, memberClass, false) || aClass != null && PsiTreeUtil.isAncestor(memberClass, aClass, false)) {
                PsiAnnotation annotation = PsiTreeUtil.getParentOfType(element, PsiAnnotation.class);
                if (annotation != null && annotation.getParent() instanceof PsiModifierList && annotation.getParent().getParent() == aClass) {
                    return 2;
                }
                return 1;
            }
            PsiDirectory directory = file.getContainingDirectory();
            PsiPackage psiPackage = aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == memberPackage || aPackage != null && memberPackage != null && Comparing.strEqual(aPackage.getQualifiedName(), memberPackage.getQualifiedName())) {
                return 2;
            }
            if (aClass != null && memberClass != null && aClass.isInheritor(memberClass, true)) {
                boolean isConstructor;
                PsiElement resolved = element instanceof PsiReference ? ((PsiReference)((Object)element)).resolve() : null;
                boolean bl = isConstructor = resolved instanceof PsiClass && element.getParent() instanceof PsiNewExpression || resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor();
                if (!isConstructor) {
                    return 3;
                }
            }
            return 4;
        }
    }
}

