/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.AnchorTypeInfo;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    protected volatile AnchorTypeInfo myType;
    protected final SmartPointerManagerImpl myManager;
    private final VirtualFile myFile;
    private final boolean myForInjected;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@NotNull Project project, @Nullable ProperTextRange range, @NotNull AnchorTypeInfo info, @NotNull PsiFile containingFile, boolean forInjected) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myForInjected = forInjected;
        this.myType = info;
        this.myManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance(project);
        this.myFile = containingFile.getViewProvider().getVirtualFile();
        this.setRange(range);
    }

    void setRange(@Nullable Segment range) {
        if (range != null) {
            this.myStartOffset = range.getStartOffset();
            this.myEndOffset = range.getEndOffset();
        } else {
            this.myStartOffset = -1;
            this.myEndOffset = -1;
        }
    }

    boolean hasRange() {
        return this.myStartOffset >= 0;
    }

    int getPsiStartOffset() {
        return this.myStartOffset;
    }

    int getPsiEndOffset() {
        return this.myEndOffset;
    }

    boolean isForInjected() {
        return this.myForInjected;
    }

    @Override
    public Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    public PsiElement restoreElement() {
        TextRange segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return SelfElementInfo.findElementInside(file, segment.getStartOffset(), segment.getEndOffset(), this.myType);
    }

    @Override
    @Nullable
    public TextRange getPsiRange() {
        return this.calcPsiRange();
    }

    @Nullable
    private TextRange calcPsiRange() {
        return this.hasRange() ? new UnfairTextRange(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), this.getProject(), this.myType.getFileLanguage());
    }

    public static PsiElement findElementInside(@NotNull PsiFile file, int syncStartOffset, int syncEndOffset, @NotNull AnchorTypeInfo type) {
        PsiElement lastChild;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        PsiElement anchor = file.getViewProvider().findElementAt(syncStartOffset, type.getFileLanguage());
        if (anchor == null && syncStartOffset == file.getTextLength() && (lastChild = file.getViewProvider().getPsi(type.getFileLanguage()).getLastChild()) != null) {
            anchor = PsiTreeUtil.getDeepestLast(lastChild);
        }
        if (anchor == null) {
            return null;
        }
        PsiElement result = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type, anchor);
        if (syncEndOffset == syncStartOffset) {
            while (result == null && anchor.getTextRange().getStartOffset() == syncEndOffset && (anchor = PsiTreeUtil.prevLeaf(anchor, false)) != null) {
                result = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type, anchor);
            }
        }
        return result;
    }

    @Nullable
    private static PsiElement findParent(int syncStartOffset, int syncEndOffset, @NotNull AnchorTypeInfo type, PsiElement anchor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findParent"));
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset) {
            if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) {
                return null;
            }
            range = anchor.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset) {
            if (type.isAcceptable(anchor)) {
                return anchor;
            }
            if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) break;
            range = anchor.getTextRange();
        }
        return null;
    }

    @Override
    public void cleanup() {
        this.setRange(null);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(final @NotNull VirtualFile virtualFile, final @NotNull Project project, final @Nullable Language language) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        return ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiFile>(){

            @Override
            public PsiFile compute() {
                if (project.isDisposed()) {
                    return null;
                }
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiFile file = PsiManager.getInstance(project).findFile(child);
                if (file != null && language != null) {
                    return file.getViewProvider().getPsi(language);
                }
                return file;
            }
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(final VirtualFile virtualFile, final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

            @Override
            public PsiDirectory compute() {
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiDirectory file = PsiManager.getInstance(project).findDirectory(child);
                if (file == null || !file.isValid()) {
                    return null;
                }
                return file;
            }
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(VirtualFile virtualFile) {
        VirtualFile child;
        if (virtualFile.isValid()) {
            child = virtualFile;
        } else {
            VirtualFile vParent = virtualFile.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile.getName();
            child = vParent.findChild(name);
        }
        return child;
    }

    @Override
    public int elementHashCode() {
        return this.getVirtualFile().hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            if (!this.getVirtualFile().equals(other.getVirtualFile()) || this.myType != otherInfo.myType) {
                return false;
            }
            TextRange range1 = this.getPsiRange();
            TextRange range2 = otherInfo.getPsiRange();
            return range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
        }
        return this.areRestoredElementsEqual(other);
    }

    protected boolean areRestoredElementsEqual(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "areRestoredElementsEqual"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return Comparing.equal(SelfElementInfo.this.restoreElement(), other.restoreElement());
            }
        });
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public Segment getRange() {
        MarkerCache markerCache;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (this.hasRange() && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = this.myManager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty() && (markerCache = this.myManager.getMarkerCache(this.getVirtualFile())) != null) {
            return markerCache.getUpdatedRange(this, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project;
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myType;
    }
}

