/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.pom.xml.impl.events.XmlTagNameChangedImpl;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagImpl
extends XmlElementImpl
implements XmlTag,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.xml.XmlTagImpl");
    @NonNls
    private static final String XML_NS_PREFIX = "xml";
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("xmlTag");
    private static final Key<ParameterizedCachedValue<XmlTag[], XmlTagImpl>> SUBTAGS_KEY = Key.create("subtags");
    private static final ParameterizedCachedValueProvider<XmlTag[], XmlTagImpl> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<XmlTag[], XmlTagImpl>(){

        @Override
        public CachedValueProvider.Result<XmlTag[]> compute(XmlTagImpl tag) {
            ArrayList<XmlTag> result = new ArrayList<XmlTag>();
            tag.fillSubTags(result);
            int s = result.size();
            XmlTag[] tags = s > 0 ? ContainerUtil.toArray(result, new XmlTag[s]) : XmlTag.EMPTY;
            return CachedValueProvider.Result.create(tags, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, tag.getContainingFile());
        }
    };
    private static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange range1, TextRange range2) {
            return range1.getStartOffset() - range2.getStartOffset();
        }
    };
    private final int myHC = ourHC++;
    private volatile String myName = null;
    private volatile String myLocalName;
    private volatile XmlAttribute[] myAttributes = null;
    private volatile TextRange[] myTextElements = null;
    private volatile Map<String, String> myAttributeValueMap = null;
    private volatile XmlTagValue myValue = null;
    private volatile Map<String, CachedValue<XmlNSDescriptor>> myNSDescriptorsMap = null;
    private volatile String myCachedNamespace;
    private volatile long myModCount;
    private volatile XmlElementDescriptor myCachedDescriptor;
    private volatile long myDescriptorModCount = -1L;
    private volatile long myExtResourcesModCount = -1L;
    private volatile boolean myHasNamespaceDeclarations = false;
    private volatile BidirectionalMap<String, String> myNamespaceMap = null;

    public XmlTagImpl() {
        this(XmlElementType.XML_TAG);
    }

    protected XmlTagImpl(IElementType type) {
        super(type);
    }

    @Nullable
    private static XmlNSDescriptor getDtdDescriptor(@NotNull XmlFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getDtdDescriptor"));
        }
        XmlDocument document = containingFile.getDocument();
        if (document == null) {
            return null;
        }
        String url = XmlUtil.getDtdUri(document);
        if (url == null) {
            return null;
        }
        return document.getDefaultNSDescriptor(url, true);
    }

    @Nullable
    private static String getNSVersion(String ns, XmlTagImpl xmlTag) {
        String versionValue = xmlTag.getAttributeValue("version");
        if (versionValue != null && xmlTag.getNamespace().equals(ns)) {
            return versionValue;
        }
        return null;
    }

    public final int hashCode() {
        return this.myHC;
    }

    @Override
    public void clearCaches() {
        this.myName = null;
        this.myLocalName = null;
        this.myNamespaceMap = null;
        this.myCachedNamespace = null;
        this.myCachedDescriptor = null;
        this.myDescriptorModCount = -1L;
        this.myAttributes = null;
        this.myTextElements = null;
        this.myAttributeValueMap = null;
        this.myHasNamespaceDeclarations = false;
        this.myValue = null;
        this.myNSDescriptorsMap = null;
        super.clearCaches();
    }

    @Override
    @Deprecated
    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/xml/XmlTagImpl", "shouldAskParentForReferences"));
        }
        return false;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull PsiReferenceService.Hints hints) {
        boolean inEndTag;
        boolean inStartTag;
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getReferences"));
        }
        ProgressManager.checkCanceled();
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(this);
        if (startTagName == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this);
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        String prefix = this.getNamespacePrefix();
        boolean bl = inStartTag = hints.offsetInElement == null || XmlTagImpl.childContainsOffset(startTagName.getPsi(), hints.offsetInElement);
        if (inStartTag) {
            TagNameReference startTagRef = TagNameReference.createTagNameReference(this, startTagName, true);
            if (startTagRef != null) {
                refs.add(startTagRef);
            }
            if (!prefix.isEmpty()) {
                refs.add(this.createPrefixReference(startTagName, prefix, startTagRef));
            }
        }
        boolean bl2 = inEndTag = endTagName != null && (hints.offsetInElement == null || XmlTagImpl.childContainsOffset(endTagName.getPsi(), hints.offsetInElement));
        if (inEndTag) {
            TagNameReference endTagRef = TagNameReference.createTagNameReference(this, endTagName, false);
            if (endTagRef != null) {
                refs.add(endTagRef);
            }
            if (StringUtil.isNotEmpty(prefix = XmlUtil.findPrefixByQualifiedName(endTagName.getText()))) {
                refs.add(this.createPrefixReference(endTagName, prefix, endTagRef));
            }
        }
        if (hints.offsetInElement == null || inStartTag || inEndTag || this.isInsideXmlText(hints.offsetInElement)) {
            Collections.addAll(refs, ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, hints));
        }
        PsiReference[] psiReferenceArray = ContainerUtil.toArray(refs, new PsiReference[refs.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    private static boolean childContainsOffset(PsiElement child, int offsetInTag) {
        return child.getStartOffsetInParent() <= offsetInTag && offsetInTag <= child.getStartOffsetInParent() + child.getTextLength();
    }

    private boolean isInsideXmlText(int offsetInTag) {
        TextRange[] ranges = this.getValueTextRanges();
        if (ranges.length == 0) {
            return false;
        }
        if (offsetInTag < ranges[0].getStartOffset() || offsetInTag > ranges[ranges.length - 1].getEndOffset()) {
            return false;
        }
        int i = Arrays.binarySearch(ranges, TextRange.from(offsetInTag, 0), RANGE_COMPARATOR);
        return i >= 0 || ranges[-i - 2].containsOffset(offsetInTag);
    }

    @NotNull
    private TextRange[] getValueTextRanges() {
        TextRange[] elements = this.myTextElements;
        if (elements == null) {
            List<TextRange> list = ContainerUtil.newSmartList();
            for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                PsiElement psi = child.getPsi();
                if (!(psi instanceof XmlText)) continue;
                list.add(TextRange.from(psi.getStartOffsetInParent(), psi.getTextLength()));
            }
            elements = list.toArray(new TextRange[list.size()]);
            this.myTextElements = elements;
        }
        if (elements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getValueTextRanges"));
        }
        return elements;
    }

    private SchemaPrefixReference createPrefixReference(ASTNode startTagName, String prefix, TagNameReference tagRef) {
        return new SchemaPrefixReference(this, TextRange.from(startTagName.getStartOffset() - this.getStartOffset(), prefix.length()), prefix, tagRef);
    }

    @Override
    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        XmlNSDescriptor value;
        XmlNSDescriptor descriptor;
        XmlTag parentTag = this.getParentTag();
        if (parentTag == null && namespace.equals("http://www.w3.org/1999/xhtml") && (descriptor = XmlTagImpl.getDtdDescriptor(XmlUtil.getContainingFile(this))) != null) {
            return descriptor;
        }
        Map<String, CachedValue<XmlNSDescriptor>> map = this.initNSDescriptorsMap();
        CachedValue<XmlNSDescriptor> descriptor2 = map.get(namespace);
        if (descriptor2 != null && (value = descriptor2.getValue()) != null) {
            return value;
        }
        if (parentTag == null) {
            XmlDocument parentOfType = PsiTreeUtil.getParentOfType((PsiElement)this, XmlDocument.class);
            if (parentOfType == null) {
                return null;
            }
            return parentOfType.getDefaultNSDescriptor(namespace, strict);
        }
        return parentTag.getNSDescriptor(namespace, strict);
    }

    @Override
    public boolean isEmpty() {
        return XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this) == null;
    }

    @Override
    public void collapseIfEmpty() {
        XmlTag[] tags = this.getSubTags();
        if (tags.length > 0) {
            return;
        }
        final ASTNode closingName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this);
        final ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(this);
        if (closingName == null || startTagEnd == null) {
            return;
        }
        PomModel pomModel = PomManager.getModel(this.getProject());
        PomTransactionBase transaction = new PomTransactionBase(this, pomModel.getModelAspect(XmlAspect.class)){

            @Override
            @Nullable
            public PomModelEvent runInner() {
                ASTNode closingBracket = closingName.getTreeNext();
                XmlTagImpl.this.removeRange(startTagEnd, closingBracket);
                LeafElement emptyTagEnd = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, null, XmlTagImpl.this.getManager());
                XmlTagImpl.this.replaceChild(closingBracket, emptyTagEnd);
                return null;
            }
        };
        try {
            pomModel.runTransaction(transaction);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    @Override
    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        XmlTag tag = this.findFirstSubTag(qname);
        if (tag == null) {
            return null;
        }
        return tag.getValue().getText();
    }

    protected final Map<String, CachedValue<XmlNSDescriptor>> initNSDescriptorsMap() {
        Map<String, CachedValue<XmlNSDescriptor>> map = this.myNSDescriptorsMap;
        if (map == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            map = this.computeNsDescriptorMap();
            if (stamp.mayCacheNow()) {
                this.myNSDescriptorsMap = map;
            }
        }
        return map;
    }

    @NotNull
    private Map<String, CachedValue<XmlNSDescriptor>> computeNsDescriptorMap() {
        Map<String, CachedValue<XmlNSDescriptor>> map = null;
        String noNamespaceDeclaration = this.getAttributeValue("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        String schemaLocationDeclaration = this.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (noNamespaceDeclaration != null) {
            map = this.initializeSchema("", null, noNamespaceDeclaration, null, this.myHasNamespaceDeclarations);
        }
        if (schemaLocationDeclaration != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                map = this.initializeSchema(uri, XmlTagImpl.getNSVersion(uri, this), tokenizer.nextToken(), map, this.myHasNamespaceDeclarations);
            }
        }
        if (this.hasNamespaceDeclarations()) {
            for (XmlAttribute attribute : this.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String ns = attribute.getValue();
                if (ns == null) {
                    ns = "";
                }
                ns = this.getRealNs(ns);
                if (map != null && map.containsKey(ns)) continue;
                map = this.initializeSchema(ns, XmlTagImpl.getNSVersion(ns, this), this.getNsLocation(ns), map, true);
            }
        }
        Map<String, CachedValue<XmlNSDescriptor>> map2 = map == null ? Collections.emptyMap() : map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "computeNsDescriptorMap"));
        }
        return map2;
    }

    private Map<String, CachedValue<XmlNSDescriptor>> initializeSchema(final @NotNull String namespace, final @Nullable String version, final String fileLocation, Map<String, CachedValue<XmlNSDescriptor>> map, final boolean nsDecl) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/psi/impl/source/xml/XmlTagImpl", "initializeSchema"));
        }
        if (map == null) {
            map = new THashMap();
        }
        map.put(namespace, CachedValuesManager.getManager(this.getManager().getProject()).createCachedValue(new CachedValueProvider<XmlNSDescriptor>(){

            @Override
            public CachedValueProvider.Result<XmlNSDescriptor> compute() {
                PsiMetaOwner currentOwner;
                XmlDocument document;
                XmlNSDescriptor descriptor = XmlTagImpl.this.getImplicitNamespaceDescriptor(fileLocation);
                if (descriptor != null) {
                    return new CachedValueProvider.Result<XmlNSDescriptor>(descriptor, ArrayUtil.append(descriptor.getDependences(), XmlTagImpl.this));
                }
                XmlFile currentFile = XmlTagImpl.this.retrieveFile(fileLocation, version, namespace, nsDecl);
                if (currentFile == null && (document = XmlUtil.getContainingFile(XmlTagImpl.this).getDocument()) != null) {
                    String defaultValue;
                    XmlAttributeDescriptor attributeDescriptor;
                    XmlElementDescriptor elementDescriptor;
                    String uri = XmlUtil.getDtdUri(document);
                    if (uri != null) {
                        XmlFile containingFile = XmlUtil.getContainingFile(document);
                        XmlFile xmlFile = XmlUtil.findNamespace(containingFile, uri);
                        XmlNSDescriptor xmlNSDescriptor = descriptor = xmlFile == null ? null : (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
                    }
                    if (descriptor instanceof com.intellij.xml.impl.dtd.XmlNSDescriptorImpl && (elementDescriptor = descriptor.getElementDescriptor(XmlTagImpl.this)) != null && (attributeDescriptor = elementDescriptor.getAttributeDescriptor("xmlns", XmlTagImpl.this)) != null && attributeDescriptor.isFixed() && (defaultValue = attributeDescriptor.getDefaultValue()) != null && defaultValue.equals(namespace)) {
                        return new CachedValueProvider.Result<XmlNSDescriptor>(descriptor, descriptor.getDependences(), XmlTagImpl.this, ExternalResourceManager.getInstance());
                    }
                }
                if ((currentOwner = XmlTagImpl.this.retrieveOwner(currentFile, namespace)) != null && (descriptor = (XmlNSDescriptor)currentOwner.getMetaData()) != null) {
                    return new CachedValueProvider.Result<XmlNSDescriptor>(descriptor, descriptor.getDependences(), XmlTagImpl.this, ExternalResourceManager.getInstance());
                }
                return new CachedValueProvider.Result<Object>(null, XmlTagImpl.this, currentFile == null ? XmlTagImpl.this : currentFile, ExternalResourceManager.getInstance());
            }
        }, false));
        return map;
    }

    @Nullable
    private XmlNSDescriptor getImplicitNamespaceDescriptor(String ns) {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(file);
        if (module != null) {
            for (ImplicitNamespaceDescriptorProvider provider : Extensions.getExtensions(ImplicitNamespaceDescriptorProvider.EP_NAME)) {
                XmlNSDescriptor nsDescriptor = provider.getNamespaceDescriptor(module, ns, file);
                if (nsDescriptor == null) continue;
                return nsDescriptor;
            }
        }
        return null;
    }

    @Nullable
    private XmlFile retrieveFile(String fileLocation, String version, String namespace, boolean nsDecl) {
        String targetNs = XmlUtil.getTargetSchemaNsFromTag(this);
        if (fileLocation.equals(targetNs)) {
            return null;
        }
        XmlFile file = XmlUtil.getContainingFile(this);
        PsiFile psiFile = ExternalResourceManager.getInstance().getResourceLocation(fileLocation, file, version);
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return XmlNamespaceIndex.guessSchema(namespace, nsDecl ? null : this.myLocalName, version, fileLocation, file);
    }

    @Nullable
    private PsiMetaOwner retrieveOwner(XmlFile file, @NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/psi/impl/source/xml/XmlTagImpl", "retrieveOwner"));
        }
        if (file == null) {
            return namespace.equals(XmlUtil.getTargetSchemaNsFromTag(this)) ? this : null;
        }
        return file.getDocument();
    }

    @Override
    public PsiReference getReference() {
        return ArrayUtil.getFirstElement(this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    @Override
    public XmlElementDescriptor getDescriptor() {
        long curModCount = this.getManager().getModificationTracker().getModificationCount();
        long curExtResourcesModCount = ExternalResourceManagerEx.getInstanceEx().getModificationCount(this.getProject());
        if (this.myDescriptorModCount != curModCount || this.myExtResourcesModCount != curExtResourcesModCount) {
            if (this.myExtResourcesModCount != curExtResourcesModCount) {
                this.myNSDescriptorsMap = null;
            }
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            XmlElementDescriptor descriptor = this.computeElementDescriptor();
            if (!stamp.mayCacheNow()) {
                return descriptor;
            }
            this.myCachedDescriptor = descriptor;
            this.myDescriptorModCount = curModCount;
            this.myExtResourcesModCount = curExtResourcesModCount;
        }
        return this.myCachedDescriptor;
    }

    @Nullable
    protected XmlElementDescriptor computeElementDescriptor() {
        XmlElementDescriptor fromParent;
        XmlElementDescriptor descriptor;
        XmlTag parent;
        for (XmlElementDescriptorProvider provider : Extensions.getExtensions(XmlElementDescriptorProvider.EP_NAME)) {
            XmlElementDescriptor elementDescriptor = provider.getDescriptor(this);
            if (elementDescriptor == null) continue;
            return elementDescriptor;
        }
        String namespace = this.getNamespace();
        if ("".equals(namespace) && (parent = this.getParentTag()) != null && (descriptor = parent.getDescriptor()) != null && (fromParent = descriptor.getElementDescriptor(this, parent)) != null && !(fromParent instanceof AnyXmlElementDescriptor)) {
            return fromParent;
        }
        XmlElementDescriptor elementDescriptor = null;
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor(namespace, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor for namespace " + namespace + " is " + (nsDescriptor != null ? nsDescriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (nsDescriptor != null && (!DumbService.getInstance(this.getProject()).isDumb() || DumbService.isDumbAware(nsDescriptor))) {
            elementDescriptor = nsDescriptor.getElementDescriptor(this);
        }
        if (elementDescriptor == null) {
            return XmlUtil.findXmlDescriptorByType(this);
        }
        return elementDescriptor;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlTokenType.XML_NAME || i == XmlTokenType.XML_TAG_NAME) {
            return 224;
        }
        if (i == XmlElementType.XML_ATTRIBUTE) {
            return 240;
        }
        return 0;
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.myName;
        if (name == null) {
            ASTNode nameElement = XmlChildRole.START_TAG_NAME_FINDER.findChild(this);
            name = nameElement != null ? nameElement.getText() : "";
            this.myName = name;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(final @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/xml/XmlTagImpl", "setName"));
        }
        final PomModel model = PomManager.getModel(this.getProject());
        XmlAspect aspect = model.getModelAspect(XmlAspect.class);
        model.runTransaction(new PomTransactionBase(this, aspect){

            @Override
            public PomModelEvent runInner() throws IncorrectOperationException {
                TreeElement treeElement;
                String oldName = XmlTagImpl.this.getName();
                XmlTagImpl dummyTag = (XmlTagImpl)XmlElementFactory.getInstance(XmlTagImpl.this.getProject()).createTagFromText(XmlTagUtil.composeTagText(name, "aa"));
                XmlTagImpl tag = XmlTagImpl.this;
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(tag);
                ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag);
                LOG.assertTrue(child != null, "It seems '" + name + "' is not a valid tag name");
                TreeElement tagElement = (TreeElement)XmlChildRole.START_TAG_NAME_FINDER.findChild(dummyTag);
                LOG.assertTrue(tagElement != null, "What's wrong with it? '" + name + "'");
                tag.replaceChild(child, ChangeUtil.copyElement(tagElement, charTableByTree));
                ASTNode childByRole = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag);
                if (childByRole != null && (treeElement = (TreeElement)XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(dummyTag)) != null) {
                    tag.replaceChild(childByRole, ChangeUtil.copyElement(treeElement, charTableByTree));
                }
                return XmlTagNameChangedImpl.createXmlTagNameChanged(model, tag, oldName);
            }
        });
        return this;
    }

    @Override
    @NotNull
    public XmlAttribute[] getAttributes() {
        XmlAttribute[] attributes = this.myAttributes;
        if (attributes == null) {
            attributes = this.calculateAttributes();
            this.myAttributes = attributes;
        }
        if (attributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getAttributes"));
        }
        return attributes;
    }

    @NotNull
    private XmlAttribute[] calculateAttributes() {
        final ArrayList result = new ArrayList(10);
        this.processChildren(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlTagImpl$6", "execute"));
                }
                if (element instanceof XmlAttribute) {
                    XmlAttribute attribute = (XmlAttribute)element;
                    result.add(attribute);
                    XmlTagImpl.this.myHasNamespaceDeclarations = XmlTagImpl.this.myHasNamespaceDeclarations || attribute.isNamespaceDeclaration();
                } else if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_TAG_END) {
                    return false;
                }
                return true;
            }
        });
        if (result.isEmpty()) {
            if (XmlAttribute.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "calculateAttributes"));
            }
            return XmlAttribute.EMPTY_ARRAY;
        }
        XmlAttribute[] xmlAttributeArray = ContainerUtil.toArray(result, new XmlAttribute[result.size()]);
        if (xmlAttributeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "calculateAttributes"));
        }
        return xmlAttributeArray;
    }

    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        attributesValueMap.put(name, value);
    }

    @Override
    public String getAttributeValue(String qname) {
        THashMap map = this.myAttributeValueMap;
        if (map == null) {
            map = new THashMap();
            for (XmlAttribute attribute : this.getAttributes()) {
                this.cacheOneAttributeValue(attribute.getName(), attribute.getValue(), (Map<String, String>)map);
            }
            this.myAttributeValueMap = map;
        }
        return map.get(qname);
    }

    @Override
    public String getAttributeValue(String _name, String namespace) {
        if (namespace == null) {
            return this.getAttributeValue(_name);
        }
        XmlTagImpl current = this;
        PsiElement parent = this.getParent();
        while (current != null) {
            List<String> keysByValue;
            BidirectionalMap<String, String> map = current.initNamespaceMaps(parent);
            if (map != null && (keysByValue = map.getKeysByValue(namespace)) != null && !keysByValue.isEmpty()) {
                for (String prefix : keysByValue) {
                    String value;
                    if (prefix == null || prefix.isEmpty() || (value = this.getAttributeValue(prefix + ":" + _name)) == null) continue;
                    return value;
                }
            }
            current = parent instanceof XmlTag ? (XmlTagImpl)parent : null;
            parent = parent.getParent();
        }
        if (namespace.isEmpty() || this.getNamespace().equals(namespace)) {
            return this.getAttributeValue(_name);
        }
        return null;
    }

    @Override
    @NotNull
    public XmlTag[] getSubTags() {
        XmlTag[] xmlTagArray = CachedValuesManager.getManager(this.getProject()).getParameterizedCachedValue(this, SUBTAGS_KEY, CACHED_VALUE_PROVIDER, false, this);
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getSubTags"));
        }
        return xmlTagArray;
    }

    protected void fillSubTags(final List<XmlTag> result) {
        this.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlTagImpl$7", "execute"));
                }
                if (element instanceof XmlTag) {
                    assert (element.isValid());
                    result.add((XmlTag)element);
                }
                return true;
            }
        }, this);
    }

    @Override
    @NotNull
    public XmlTag[] findSubTags(String name) {
        XmlTag[] xmlTagArray = this.findSubTags(name, null);
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "findSubTags"));
        }
        return xmlTagArray;
    }

    @Override
    @NotNull
    public XmlTag[] findSubTags(String name, @Nullable String namespace) {
        XmlTag[] subTags = this.getSubTags();
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (XmlTag subTag : subTags) {
            if (namespace == null) {
                if (!name.equals(subTag.getName())) continue;
                result.add(subTag);
                continue;
            }
            if (!name.equals(subTag.getLocalName()) || !namespace.equals(subTag.getNamespace())) continue;
            result.add(subTag);
        }
        XmlTag[] xmlTagArray = ContainerUtil.toArray(result, new XmlTag[result.size()]);
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "findSubTags"));
        }
        return xmlTagArray;
    }

    @Override
    public XmlTag findFirstSubTag(String name) {
        XmlTag[] subTags = this.findSubTags(name);
        if (subTags.length > 0) {
            return subTags[0];
        }
        return null;
    }

    @Override
    public XmlAttribute getAttribute(String name, String namespace) {
        if (name != null && name.indexOf(58) != -1 || namespace == null || "".equals(namespace)) {
            return this.getAttribute(name);
        }
        String prefix = this.getPrefixByNamespace(namespace);
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        return this.getAttribute(prefix + ":" + name);
    }

    @Override
    @Nullable
    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        XmlAttribute[] attributes = this.getAttributes();
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            if (!(child instanceof LeafElement)) continue;
            LeafElement attrNameElement = (LeafElement)child;
            if ((!caseSensitive || !Comparing.equal(attrNameElement.getChars(), (CharSequence)qname)) && (caseSensitive || !Comparing.equal(attrNameElement.getChars(), (CharSequence)qname, false))) continue;
            return attribute;
        }
        return null;
    }

    protected boolean isCaseSensitive() {
        return true;
    }

    @Override
    @NotNull
    public String getNamespace() {
        String cachedNamespace = this.myCachedNamespace;
        long curModCount = this.getManager().getModificationTracker().getModificationCount();
        if (cachedNamespace != null && this.myModCount == curModCount) {
            String string = cachedNamespace;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespace"));
            }
            return string;
        }
        RecursionGuard.StackStamp stamp = ourGuard.markStack();
        cachedNamespace = this.getNamespaceByPrefix(this.getNamespacePrefix());
        if (!stamp.mayCacheNow()) {
            String string = cachedNamespace;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespace"));
            }
            return string;
        }
        this.myCachedNamespace = cachedNamespace;
        this.myModCount = curModCount;
        String string = cachedNamespace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespace"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getNamespacePrefix() {
        String string = XmlUtil.findPrefixByQualifiedName(this.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespacePrefix"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        String result;
        String ns;
        BidirectionalMap<String, String> map;
        PsiElement parent = this.getParent();
        if (!parent.isValid()) {
            LOG.error(this.isValid());
        }
        if ((map = this.initNamespaceMaps(parent)) != null && (ns = map.get(prefix)) != null) {
            String string = ns;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespaceByPrefix"));
            }
            return string;
        }
        if (parent instanceof XmlTag) {
            String string = ((XmlTag)parent).getNamespaceByPrefix(prefix);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespaceByPrefix"));
            }
            return string;
        }
        if (XML_NS_PREFIX.equals(prefix)) {
            if ("http://www.w3.org/XML/1998/namespace" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespaceByPrefix"));
            }
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (!prefix.isEmpty() && !this.hasNamespaceDeclarations() && this.getNamespacePrefix().equals(prefix) && (result = ourGuard.doPreventingRecursion("getNsByPrefix", true, new Computable<String>(){

            @Override
            public String compute() {
                String nameFromRealDescriptor;
                String nsFromEmptyPrefix = XmlTagImpl.this.getNamespaceByPrefix("");
                XmlNSDescriptor nsDescriptor = XmlTagImpl.this.getNSDescriptor(nsFromEmptyPrefix, false);
                XmlElementDescriptor descriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(XmlTagImpl.this) : null;
                String string = nameFromRealDescriptor = descriptor != null && descriptor.getDeclaration() != null && descriptor.getDeclaration().isPhysical() ? descriptor.getName() : "";
                if (nameFromRealDescriptor.equals(XmlTagImpl.this.getName())) {
                    return nsFromEmptyPrefix;
                }
                return "";
            }
        })) != null) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespaceByPrefix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getNamespaceByPrefix"));
        }
        return "";
    }

    @Override
    public String getPrefixByNamespace(String namespace) {
        PsiElement parent = this.getParent();
        BidirectionalMap<String, String> map = this.initNamespaceMaps(parent);
        if (map != null) {
            String ns;
            List<String> keysByValue = map.getKeysByValue(namespace);
            String string = ns = keysByValue == null || keysByValue.isEmpty() ? null : keysByValue.get(0);
            if (ns != null) {
                return ns;
            }
        }
        if (parent instanceof XmlTag) {
            return ((XmlTag)parent).getPrefixByNamespace(namespace);
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return XML_NS_PREFIX;
        }
        return null;
    }

    @Override
    public String[] knownNamespaces() {
        PsiElement parentElement = this.getParent();
        BidirectionalMap<String, String> map = this.initNamespaceMaps(parentElement);
        Set<String> known = Collections.emptySet();
        if (map != null) {
            known = new HashSet<String>(map.values());
        }
        if (parentElement instanceof XmlTag) {
            if (known.isEmpty()) {
                return ((XmlTag)parentElement).knownNamespaces();
            }
            ContainerUtil.addAll(known, ((XmlTag)parentElement).knownNamespaces());
        } else {
            XmlTag rootTag;
            XmlFile xmlFile;
            XmlExtension xmlExtension = XmlExtension.getExtensionByElement(this);
            if (xmlExtension != null && (xmlFile = xmlExtension.getContainingFile(this)) != null && (rootTag = xmlFile.getRootTag()) != null && rootTag != this) {
                if (known.isEmpty()) {
                    return rootTag.knownNamespaces();
                }
                ContainerUtil.addAll(known, rootTag.knownNamespaces());
            }
        }
        return ArrayUtil.toStringArray(known);
    }

    @Nullable
    private BidirectionalMap<String, String> initNamespaceMaps(PsiElement parent) {
        BidirectionalMap<String, String> map = this.myNamespaceMap;
        if (map == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            map = this.computeNamespaceMap(parent);
            if (stamp.mayCacheNow()) {
                this.myNamespaceMap = map;
            }
        }
        return map;
    }

    @Nullable
    private BidirectionalMap<String, String> computeNamespaceMap(PsiElement parent) {
        String[][] namespacesFromDocument;
        XmlExtension extension;
        BidirectionalMap<String, String> map = null;
        boolean hasNamespaceDeclarations = this.hasNamespaceDeclarations();
        if (hasNamespaceDeclarations) {
            XmlAttribute[] attributes;
            map = new BidirectionalMap<String, String>();
            for (XmlAttribute attribute : attributes = this.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String name = attribute.getName();
                int splitIndex = name.indexOf(58);
                String value = this.getRealNs(attribute.getValue());
                if (value == null) continue;
                if (splitIndex < 0) {
                    map.put("", value);
                    continue;
                }
                map.put(XmlUtil.findLocalNameByQualifiedName(name), value);
            }
        }
        if (parent instanceof XmlDocument && (extension = XmlExtension.getExtensionByElement(parent)) != null && (namespacesFromDocument = extension.getNamespacesFromDocument((XmlDocument)parent, hasNamespaceDeclarations)) != null) {
            if (map == null) {
                map = new BidirectionalMap();
            }
            for (String[] prefix2ns : namespacesFromDocument) {
                map.put(prefix2ns[0], this.getRealNs(prefix2ns[1]));
            }
        }
        return map;
    }

    private String getNsLocation(String ns) {
        if ("http://www.w3.org/1999/xhtml".equals(ns)) {
            return XmlUtil.getDefaultXhtmlNamespace(this.getProject());
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(this, "schema")) {
            for (XmlTag subTag : this.getSubTags()) {
                String location;
                if (!XmlNSDescriptorImpl.equalsToSchemaName(subTag, "import") || !ns.equals(subTag.getAttributeValue("namespace")) || (location = subTag.getAttributeValue("schemaLocation")) == null) continue;
                return location;
            }
        }
        return XmlUtil.getSchemaLocation(this, ns);
    }

    protected String getRealNs(String value) {
        return value;
    }

    @Override
    @NotNull
    public String getLocalName() {
        String localName = this.myLocalName;
        if (localName == null) {
            String name = this.getName();
            this.myLocalName = localName = name.substring(name.indexOf(58) + 1);
        }
        String string = localName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getLocalName"));
        }
        return string;
    }

    @Override
    public boolean hasNamespaceDeclarations() {
        this.getAttributes();
        return this.myHasNamespaceDeclarations;
    }

    @Override
    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        THashMap namespaces = new THashMap();
        for (XmlAttribute attribute : this.getAttributes()) {
            if (!attribute.isNamespaceDeclaration() || attribute.getValue() == null) continue;
            String localName = attribute.getLocalName();
            namespaces.put(localName.equals(attribute.getName()) ? "" : localName, attribute.getValue());
        }
        THashMap tHashMap = namespaces;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getLocalNamespaceDeclarations"));
        }
        return tHashMap;
    }

    @Override
    public XmlAttribute setAttribute(String qname, String value) throws IncorrectOperationException {
        XmlAttribute attribute = this.getAttribute(qname);
        if (attribute != null) {
            if (value == null) {
                this.deleteChildInternal(attribute.getNode());
                return null;
            }
            attribute.setValue(value);
            return attribute;
        }
        if (value == null) {
            return null;
        }
        PsiElement xmlAttribute = this.add(XmlElementFactory.getInstance(this.getProject()).createXmlAttribute(qname, value));
        while (!(xmlAttribute instanceof XmlAttribute)) {
            xmlAttribute = xmlAttribute.getNextSibling();
        }
        return (XmlAttribute)xmlAttribute;
    }

    @Override
    public XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        String prefix;
        if (!Comparing.equal(namespace, "") && (prefix = this.getPrefixByNamespace(namespace)) != null && !prefix.isEmpty()) {
            name = prefix + ":" + name;
        }
        return this.setAttribute(name, value);
    }

    @Override
    public XmlTag createChildTag(String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        return XmlUtil.createChildTag(this, localName, namespace, bodyText, enforceNamespacesDeep);
    }

    @Override
    public XmlTag addSubTag(XmlTag subTag, boolean first) {
        XmlTagChild[] children = this.getSubTags();
        if (children.length == 0) {
            children = this.getValue().getChildren();
        }
        if (children.length == 0) {
            return (XmlTag)this.add(subTag);
        }
        if (first) {
            return (XmlTag)this.addBefore(subTag, children[0]);
        }
        return (XmlTag)this.addAfter(subTag, ArrayUtil.getLastElement(children));
    }

    @Override
    @NotNull
    public XmlTagValue getValue() {
        XmlTagValue tagValue = this.myValue;
        if (tagValue == null) {
            this.myValue = tagValue = XmlTagValueImpl.createXmlTagValue(this);
        }
        XmlTagValue xmlTagValue = tagValue;
        if (xmlTagValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlTagImpl", "getValue"));
        }
        return xmlTagValue;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/xml/XmlTagImpl", "accept"));
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlTag(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "XmlTag:" + this.getName();
    }

    @Override
    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean beforeB) {
        TreeElement firstAppended = null;
        boolean before = beforeB == null || beforeB != false;
        try {
            TreeElement next;
            do {
                next = first.getTreeNext();
                if (firstAppended == null) {
                    firstAppended = this.addInternal(first, anchor, before);
                    anchor = firstAppended;
                    continue;
                }
                anchor = this.addInternal(first, anchor, false);
            } while (first != last && (first = next) != null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
        }
        finally {
            this.clearCaches();
        }
        return firstAppended;
    }

    private TreeElement addInternal(TreeElement child, ASTNode anchor, boolean before) throws IncorrectOperationException {
        PomModel model = PomManager.getModel(this.getProject());
        if (anchor != null && child.getElementType() == XmlElementType.XML_TEXT) {
            XmlText psi = null;
            if (anchor.getPsi() instanceof XmlText) {
                psi = (XmlText)anchor.getPsi();
            } else {
                ASTNode other;
                ASTNode aSTNode = other = before ? anchor.getTreePrev() : anchor.getTreeNext();
                if (other != null && other.getPsi() instanceof XmlText) {
                    before = !before;
                    psi = (XmlText)other.getPsi();
                }
            }
            if (psi != null) {
                if (before) {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), 0);
                } else {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), psi.getValue().length());
                }
                return (TreeElement)psi.getNode();
            }
        }
        LOG.assertTrue(child.getPsi() instanceof XmlAttribute || child.getPsi() instanceof XmlTagChild);
        InsertTransaction transaction = child.getElementType() == XmlElementType.XML_ATTRIBUTE ? new InsertAttributeTransaction(child, anchor, before, model) : (anchor == null ? this.getBodyInsertTransaction(child) : new GenericInsertTransaction(child, anchor, before));
        model.runTransaction(transaction);
        return transaction.getFirstInserted();
    }

    protected InsertTransaction getBodyInsertTransaction(TreeElement child) {
        return new BodyInsertTransaction(child);
    }

    @Override
    public void deleteChildInternal(final @NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/xml/XmlTagImpl", "deleteChildInternal"));
        }
        final PomModel model = PomManager.getModel(this.getProject());
        XmlAspect aspect = model.getModelAspect(XmlAspect.class);
        if (child.getElementType() == XmlElementType.XML_ATTRIBUTE) {
            try {
                model.runTransaction(new PomTransactionBase(this, aspect){

                    @Override
                    public PomModelEvent runInner() {
                        String name = ((XmlAttribute)((Object)child)).getName();
                        XmlTagImpl.super.deleteChildInternal(child);
                        return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlTagImpl.this, name, null);
                    }
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        } else {
            ASTNode treePrev = child.getTreePrev();
            ASTNode treeNext = child.getTreeNext();
            XmlTagImpl.super.deleteChildInternal(child);
            if (treePrev != null && treeNext != null && treePrev.getElementType() == XmlElementType.XML_TEXT && treeNext.getElementType() == XmlElementType.XML_TEXT) {
                final XmlText prevText = (XmlText)treePrev.getPsi();
                final XmlText nextText = (XmlText)treeNext.getPsi();
                final String newValue = prevText.getValue() + nextText.getValue();
                ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                    @Override
                    public void makeChange(TreeChangeEvent destinationTreeChange) {
                        PsiElement anchor = prevText.getPrevSibling();
                        prevText.delete();
                        nextText.delete();
                        XmlText text = (XmlText)XmlTagImpl.this.addAfter(XmlElementFactory.getInstance(XmlTagImpl.this.getProject()).createDisplayText("x"), anchor);
                        text.setValue(newValue);
                    }
                }, this);
            }
        }
    }

    private ASTNode expandTag() throws IncorrectOperationException {
        ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this);
        if (endTagStart == null) {
            XmlTagImpl tagFromText = (XmlTagImpl)XmlElementFactory.getInstance(this.getProject()).createTagFromText("<" + this.getName() + "></" + this.getName() + ">");
            ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(tagFromText);
            endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tagFromText);
            LeafElement emptyTagEnd = (LeafElement)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(this);
            if (emptyTagEnd != null) {
                this.removeChild(emptyTagEnd);
            }
            this.addChildren(startTagStart, null, null);
        }
        return endTagStart;
    }

    @Override
    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    @Override
    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    @Override
    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    @Override
    public Icon getElementIcon(int flags) {
        return PlatformIcons.XML_TAG_ICON;
    }

    protected abstract class InsertTransaction
    extends PomTransactionBase {
        public InsertTransaction(PsiElement scope) {
            super(scope, PomManager.getModel(XmlTagImpl.this.getProject()).getModelAspect(XmlAspect.class));
        }

        public abstract TreeElement getFirstInserted();
    }

    protected class GenericInsertTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private final ASTNode myAnchor;
        private final boolean myBefore;
        private TreeElement myRetHolder;

        public GenericInsertTransaction(TreeElement child, ASTNode anchor, boolean before) {
            super(XmlTagImpl.this);
            this.myChild = child;
            this.myAnchor = anchor;
            this.myBefore = before;
        }

        @Override
        public PomModelEvent runInner() {
            this.myRetHolder = XmlTagImpl.super.addInternal(this.myChild, this.myChild, this.myAnchor, this.myBefore);
            return null;
        }

        @Override
        public TreeElement getFirstInserted() {
            return this.myRetHolder;
        }
    }

    protected class InsertAttributeTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private final ASTNode myAnchor;
        private final boolean myBefore;
        private final PomModel myModel;
        private TreeElement myFirstInserted;

        public InsertAttributeTransaction(TreeElement child, ASTNode anchor, boolean before, PomModel model) {
            super(XmlTagImpl.this);
            this.myFirstInserted = null;
            this.myChild = child;
            this.myAnchor = anchor;
            this.myBefore = before;
            this.myModel = model;
        }

        @Override
        public PomModelEvent runInner() {
            String value = ((XmlAttribute)((Object)this.myChild)).getValue();
            String name = ((XmlAttribute)((Object)this.myChild)).getName();
            if (this.myAnchor == null) {
                ASTNode anchor;
                ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(XmlTagImpl.this);
                if (startTagEnd == null) {
                    startTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(XmlTagImpl.this);
                }
                if (startTagEnd == null) {
                    anchor = XmlTagImpl.this.getLastChildNode();
                    while (anchor instanceof PsiWhiteSpace) {
                        anchor = anchor.getTreePrev();
                    }
                    if (anchor instanceof PsiErrorElement) {
                        LeafElement token = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, SharedImplUtil.findCharTableByTree(anchor), XmlTagImpl.this.getManager());
                        XmlTagImpl.this.replaceChild(anchor, token);
                        startTagEnd = token;
                    }
                }
                if (startTagEnd == null) {
                    anchor = XmlChildRole.START_TAG_NAME_FINDER.findChild(XmlTagImpl.this);
                    this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, anchor, Boolean.FALSE);
                } else {
                    this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, startTagEnd, Boolean.TRUE);
                }
            } else {
                this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, this.myAnchor, this.myBefore);
            }
            return XmlAttributeSetImpl.createXmlAttributeSet(this.myModel, XmlTagImpl.this, name, value);
        }

        @Override
        public TreeElement getFirstInserted() {
            return this.myFirstInserted;
        }
    }

    protected class BodyInsertTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private ASTNode myNewElement;

        public BodyInsertTransaction(TreeElement child) {
            super(XmlTagImpl.this);
            this.myChild = child;
        }

        @Override
        public PomModelEvent runInner() throws IncorrectOperationException {
            ASTNode anchor = XmlTagImpl.this.expandTag();
            if (this.myChild.getElementType() == XmlElementType.XML_TAG) {
                PsiElement declaration;
                XmlElementDescriptor parentDescriptor = XmlTagImpl.this.getDescriptor();
                XmlTag[] subTags = XmlTagImpl.this.getSubTags();
                PsiElement psiElement = declaration = parentDescriptor != null ? parentDescriptor.getDeclaration() : null;
                if (declaration != null && declaration.getContainingFile() != null && declaration.getContainingFile().isPhysical() && subTags.length > 0) {
                    XmlElementDescriptor[] childElementDescriptors = parentDescriptor.getElementsDescriptors(XmlTagImpl.this);
                    int subTagNum = -1;
                    for (XmlElementDescriptor childElementDescriptor : childElementDescriptors) {
                        String childElementName = childElementDescriptor.getName();
                        while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                            ++subTagNum;
                        }
                        if (!childElementName.equals(XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myChild).getText())) continue;
                        if (subTagNum >= 0) {
                            ASTNode subTag = (ASTNode)((Object)subTags[subTagNum]);
                            if (subTag.getTreeParent() != XmlTagImpl.this) {
                                XmlEntityRef entityRef = PsiTreeUtil.getParentOfType((PsiElement)subTags[subTagNum], XmlEntityRef.class);
                                throw new IncorrectOperationException("Can't insert subtag to the entity. Entity reference text: " + (entityRef == null ? "" : entityRef.getText()));
                            }
                            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, subTag, Boolean.FALSE);
                        } else {
                            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(XmlTagImpl.this);
                            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, child, Boolean.FALSE);
                        }
                        return null;
                    }
                } else {
                    ASTNode child = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(XmlTagImpl.this);
                    this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, child, Boolean.TRUE);
                    return null;
                }
            }
            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, anchor, Boolean.TRUE);
            return null;
        }

        @Override
        public TreeElement getFirstInserted() {
            return (TreeElement)this.myNewElement;
        }
    }
}

