/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchSectionFix
extends InspectionGadgetsFix {
    private final boolean removeTryCatch;

    public DeleteCatchSectionFix(boolean removeTryCatch) {
        this.removeTryCatch = removeTryCatch;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.removeTryCatch) {
            String string = InspectionGadgetsBundle.message("remove.try.catch.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/DeleteCatchSectionFix", "getName"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("delete.catch.section.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/DeleteCatchSectionFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Delete catch statement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/DeleteCatchSectionFix", "getFamilyName"));
        }
        return "Delete catch statement";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiParameter)) {
            return;
        }
        PsiParameter parameter = (PsiParameter)parent;
        PsiElement grandParent = parameter.getParent();
        if (!(grandParent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)grandParent;
        PsiTryStatement tryStatement = catchSection.getTryStatement();
        if (this.removeTryCatch) {
            boolean keepBlock;
            PsiCodeBlock codeBlock = tryStatement.getTryBlock();
            if (codeBlock == null) {
                return;
            }
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length == 0) {
                tryStatement.delete();
                return;
            }
            PsiElement containingElement = tryStatement.getParent();
            if (containingElement instanceof PsiCodeBlock) {
                PsiCodeBlock parentBlock = (PsiCodeBlock)containingElement;
                keepBlock = VariableSearchUtils.containsConflictingDeclarations(codeBlock, parentBlock);
            } else {
                keepBlock = true;
            }
            if (keepBlock) {
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
                PsiElementFactory factory = psiFacade.getElementFactory();
                PsiBlockStatement resultStatement = (PsiBlockStatement)factory.createStatementFromText("{}", element);
                PsiCodeBlock resultBlock = resultStatement.getCodeBlock();
                for (PsiStatement statement : statements) {
                    resultBlock.add(statement);
                }
                tryStatement.replace(resultStatement);
            } else {
                for (PsiStatement statement : statements) {
                    containingElement.addBefore(statement, tryStatement);
                }
                tryStatement.delete();
            }
        } else {
            catchSection.delete();
        }
    }
}

