/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceChecker {
    private static final Decision EXACTLY_MATCHES = new Decision(true);
    private static final Decision EXACTLY_UN_MATCHES = new Decision(false);

    private EquivalenceChecker() {
    }

    public static boolean statementsAreEquivalent(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        return EquivalenceChecker.statementsAreEquivalentDecision(statement1, statement2).getExactlyMatches();
    }

    public static Decision statementsAreEquivalentDecision(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        String text2;
        statement1 = ControlFlowUtils.stripBraces(statement1);
        statement2 = ControlFlowUtils.stripBraces(statement2);
        if (statement1 == null) {
            return statement2 == null ? EXACTLY_MATCHES : EXACTLY_UN_MATCHES;
        }
        if (statement2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        if (statement1.getClass() != statement2.getClass()) {
            return EXACTLY_UN_MATCHES;
        }
        if (statement1 instanceof PsiAssertStatement) {
            return EquivalenceChecker.assertstatementsAreEquivalentDecision((PsiAssertStatement)statement1, (PsiAssertStatement)statement2);
        }
        if (statement1 instanceof PsiBlockStatement) {
            return EquivalenceChecker.blockstatementsAreEquivalentDecision((PsiBlockStatement)statement1, (PsiBlockStatement)statement2);
        }
        if (statement1 instanceof PsiBreakStatement) {
            return EquivalenceChecker.breakstatementsAreEquivalentDecision((PsiBreakStatement)statement1, (PsiBreakStatement)statement2);
        }
        if (statement1 instanceof PsiContinueStatement) {
            return EquivalenceChecker.continuestatementsAreEquivalentDecision((PsiContinueStatement)statement1, (PsiContinueStatement)statement2);
        }
        if (statement1 instanceof PsiDeclarationStatement) {
            return EquivalenceChecker.declarationstatementsAreEquivalentDecision((PsiDeclarationStatement)statement1, (PsiDeclarationStatement)statement2);
        }
        if (statement1 instanceof PsiDoWhileStatement) {
            return EquivalenceChecker.doWhilestatementsAreEquivalentDecision((PsiDoWhileStatement)statement1, (PsiDoWhileStatement)statement2);
        }
        if (statement1 instanceof PsiEmptyStatement) {
            return EXACTLY_MATCHES;
        }
        if (statement1 instanceof PsiExpressionListStatement) {
            return EquivalenceChecker.expressionListstatementsAreEquivalentDecision((PsiExpressionListStatement)statement1, (PsiExpressionListStatement)statement2);
        }
        if (statement1 instanceof PsiExpressionStatement) {
            return EquivalenceChecker.expressionstatementsAreEquivalentDecision((PsiExpressionStatement)statement1, (PsiExpressionStatement)statement2);
        }
        if (statement1 instanceof PsiForStatement) {
            return EquivalenceChecker.forstatementsAreEquivalentDecision((PsiForStatement)statement1, (PsiForStatement)statement2);
        }
        if (statement1 instanceof PsiForeachStatement) {
            return EquivalenceChecker.forEachstatementsAreEquivalentDecision((PsiForeachStatement)statement1, (PsiForeachStatement)statement2);
        }
        if (statement1 instanceof PsiIfStatement) {
            return EquivalenceChecker.ifstatementsAreEquivalentDecision((PsiIfStatement)statement1, (PsiIfStatement)statement2);
        }
        if (statement1 instanceof PsiLabeledStatement) {
            return EquivalenceChecker.labeledstatementsAreEquivalentDecision((PsiLabeledStatement)statement1, (PsiLabeledStatement)statement2);
        }
        if (statement1 instanceof PsiReturnStatement) {
            return EquivalenceChecker.returnstatementsAreEquivalentDecision((PsiReturnStatement)statement1, (PsiReturnStatement)statement2);
        }
        if (statement1 instanceof PsiSwitchStatement) {
            return EquivalenceChecker.switchstatementsAreEquivalentDecision((PsiSwitchStatement)statement1, (PsiSwitchStatement)statement2);
        }
        if (statement1 instanceof PsiSwitchLabelStatement) {
            return EquivalenceChecker.switchLabelstatementsAreEquivalentDecision((PsiSwitchLabelStatement)statement1, (PsiSwitchLabelStatement)statement2);
        }
        if (statement1 instanceof PsiSynchronizedStatement) {
            return EquivalenceChecker.synchronizedstatementsAreEquivalentDecision((PsiSynchronizedStatement)statement1, (PsiSynchronizedStatement)statement2);
        }
        if (statement1 instanceof PsiThrowStatement) {
            return EquivalenceChecker.throwstatementsAreEquivalentDecision((PsiThrowStatement)statement1, (PsiThrowStatement)statement2);
        }
        if (statement1 instanceof PsiTryStatement) {
            return EquivalenceChecker.trystatementsAreEquivalentDecision((PsiTryStatement)statement1, (PsiTryStatement)statement2);
        }
        if (statement1 instanceof PsiWhileStatement) {
            return EquivalenceChecker.whilestatementsAreEquivalentDecision((PsiWhileStatement)statement1, (PsiWhileStatement)statement2);
        }
        String text1 = statement1.getText();
        return text1.equals(text2 = statement2.getText()) ? EXACTLY_MATCHES : EXACTLY_UN_MATCHES;
    }

    private static Decision declarationstatementsAreEquivalentDecision(@NotNull PsiDeclarationStatement statement1, @NotNull PsiDeclarationStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "declarationstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "declarationstatementsAreEquivalentDecision"));
        }
        PsiElement[] elements1 = statement1.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars1 = new ArrayList<PsiLocalVariable>(elements1.length);
        for (PsiElement anElement : elements1) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars1.add((PsiLocalVariable)anElement);
        }
        PsiElement[] elements2 = statement2.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars2 = new ArrayList<PsiLocalVariable>(elements2.length);
        for (PsiElement anElement : elements2) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars2.add((PsiLocalVariable)anElement);
        }
        int size = vars1.size();
        if (size != vars2.size()) {
            return EXACTLY_UN_MATCHES;
        }
        for (int i = 0; i < size; ++i) {
            PsiLocalVariable var2;
            PsiLocalVariable var1 = (PsiLocalVariable)vars1.get(i);
            if (EquivalenceChecker.localVariablesAreEquivalent(var1, var2 = (PsiLocalVariable)vars2.get(i)).getExactlyMatches()) continue;
            return EXACTLY_UN_MATCHES;
        }
        return EXACTLY_MATCHES;
    }

    private static Decision localVariablesAreEquivalent(@NotNull PsiLocalVariable localVariable1, @NotNull PsiLocalVariable localVariable2) {
        PsiType type2;
        if (localVariable1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariable1", "com/siyeh/ig/psiutils/EquivalenceChecker", "localVariablesAreEquivalent"));
        }
        if (localVariable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariable2", "com/siyeh/ig/psiutils/EquivalenceChecker", "localVariablesAreEquivalent"));
        }
        PsiType type1 = localVariable1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = localVariable2.getType())) {
            return EXACTLY_UN_MATCHES;
        }
        String name1 = localVariable1.getName();
        String name2 = localVariable2.getName();
        if (name1 == null) {
            return Decision.exact(name2 == null);
        }
        if (!name1.equals(name2)) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression initializer1 = localVariable1.getInitializer();
        PsiExpression initializer2 = localVariable2.getInitializer();
        return EquivalenceChecker.expressionsAreEquivalentDecision(initializer1, initializer2).setConcreteIfExactUnMatches(initializer1, initializer2);
    }

    private static Decision trystatementsAreEquivalentDecision(@NotNull PsiTryStatement statement1, @NotNull PsiTryStatement statement2) {
        PsiParameter[] catchParameters2;
        PsiParameter[] catchParameters1;
        int i;
        PsiCodeBlock[] catchBlocks2;
        PsiCodeBlock finallyBlock2;
        PsiCodeBlock tryBlock2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "trystatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "trystatementsAreEquivalentDecision"));
        }
        PsiCodeBlock tryBlock1 = statement1.getTryBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalentDecision(tryBlock1, tryBlock2 = statement2.getTryBlock()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiCodeBlock finallyBlock1 = statement1.getFinallyBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalentDecision(finallyBlock1, finallyBlock2 = statement2.getFinallyBlock()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiCodeBlock[] catchBlocks1 = statement1.getCatchBlocks();
        if (catchBlocks1.length != (catchBlocks2 = statement2.getCatchBlocks()).length) {
            return EXACTLY_UN_MATCHES;
        }
        for (int i2 = 0; i2 < catchBlocks2.length; ++i2) {
            if (EquivalenceChecker.codeBlocksAreEquivalentDecision(catchBlocks1[i2], catchBlocks2[i2]).getExactlyMatches()) continue;
            return EXACTLY_UN_MATCHES;
        }
        PsiResourceList resourceList1 = statement1.getResourceList();
        PsiResourceList resourceList2 = statement2.getResourceList();
        if (resourceList1 != null) {
            if (resourceList2 == null) {
                return EXACTLY_UN_MATCHES;
            }
            if (resourceList1.getResourceVariablesCount() != resourceList2.getResourceVariablesCount()) {
                return EXACTLY_UN_MATCHES;
            }
            List<PsiResourceListElement> resources1 = PsiTreeUtil.getChildrenOfTypeAsList(resourceList1, PsiResourceListElement.class);
            List<PsiResourceListElement> resources2 = PsiTreeUtil.getChildrenOfTypeAsList(resourceList2, PsiResourceListElement.class);
            int size = resources1.size();
            for (i = 0; i < size; ++i) {
                PsiResourceListElement resource1 = resources1.get(i);
                PsiResourceListElement resource2 = resources2.get(i);
                if (resource1 instanceof PsiResourceVariable && resource2 instanceof PsiResourceVariable) {
                    if (EquivalenceChecker.localVariablesAreEquivalent((PsiLocalVariable)((Object)resource1), (PsiLocalVariable)((Object)resource2)).getExactlyMatches()) continue;
                    return EXACTLY_UN_MATCHES;
                }
                if (resource1 instanceof PsiResourceExpression && resource2 instanceof PsiResourceExpression) {
                    if (EquivalenceChecker.expressionsAreEquivalentDecision(((PsiResourceExpression)resource1).getExpression(), ((PsiResourceExpression)resource2).getExpression()).getExactlyMatches()) continue;
                    return EXACTLY_UN_MATCHES;
                }
                return EXACTLY_UN_MATCHES;
            }
        } else if (resourceList2 != null) {
            return EXACTLY_UN_MATCHES;
        }
        if ((catchParameters1 = statement1.getCatchBlockParameters()).length != (catchParameters2 = statement2.getCatchBlockParameters()).length) {
            return EXACTLY_UN_MATCHES;
        }
        for (i = 0; i < catchParameters2.length; ++i) {
            if (EquivalenceChecker.parametersAreEquivalent(catchParameters2[i], catchParameters1[i]).getExactlyMatches()) continue;
            return EXACTLY_UN_MATCHES;
        }
        return EXACTLY_MATCHES;
    }

    private static Decision parametersAreEquivalent(@NotNull PsiParameter parameter1, @NotNull PsiParameter parameter2) {
        PsiType type2;
        if (parameter1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter1", "com/siyeh/ig/psiutils/EquivalenceChecker", "parametersAreEquivalent"));
        }
        if (parameter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter2", "com/siyeh/ig/psiutils/EquivalenceChecker", "parametersAreEquivalent"));
        }
        PsiType type1 = parameter1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = parameter2.getType())) {
            return EXACTLY_UN_MATCHES;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        if (name1 == null) {
            return Decision.exact(name2 == null);
        }
        return Decision.exact(name1.equals(name2));
    }

    public static boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        String type1Text = type1.getCanonicalText();
        String type2Text = type2.getCanonicalText();
        return type1Text.equals(type2Text);
    }

    private static Decision whilestatementsAreEquivalentDecision(@NotNull PsiWhileStatement statement1, @NotNull PsiWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "whilestatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "whilestatementsAreEquivalentDecision"));
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        Decision conditionEquivalence = EquivalenceChecker.expressionsAreEquivalentDecision(condition1, condition2);
        Decision bodyEquivalence = EquivalenceChecker.statementsAreEquivalentDecision(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(bodyEquivalence, conditionEquivalence, body1, body2, condition1, condition2);
    }

    private static Decision forstatementsAreEquivalentDecision(@NotNull PsiForStatement statement1, @NotNull PsiForStatement statement2) {
        PsiStatement update2;
        PsiStatement initialization2;
        PsiExpression condition2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "forstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "forstatementsAreEquivalentDecision"));
        }
        PsiExpression condition1 = statement1.getCondition();
        if (!EquivalenceChecker.expressionsAreEquivalentDecision(condition1, condition2 = statement2.getCondition()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiStatement initialization1 = statement1.getInitialization();
        if (!EquivalenceChecker.statementsAreEquivalentDecision(initialization1, initialization2 = statement2.getInitialization()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiStatement update1 = statement1.getUpdate();
        if (!EquivalenceChecker.statementsAreEquivalentDecision(update1, update2 = statement2.getUpdate()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalentDecision(body1, body2).setConcreteIfExactUnMatches(body1, body2);
    }

    private static Decision forEachstatementsAreEquivalentDecision(@NotNull PsiForeachStatement statement1, @NotNull PsiForeachStatement statement2) {
        PsiExpression value2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "forEachstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "forEachstatementsAreEquivalentDecision"));
        }
        PsiExpression value1 = statement1.getIteratedValue();
        if (!EquivalenceChecker.expressionsAreEquivalentDecision(value1, value2 = statement2.getIteratedValue()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiParameter parameter1 = statement1.getIterationParameter();
        PsiParameter parameter2 = statement1.getIterationParameter();
        String name1 = parameter1.getName();
        if (name1 == null) {
            return Decision.exact(parameter2.getName() == null);
        }
        if (!name1.equals(parameter2.getName())) {
            return EXACTLY_UN_MATCHES;
        }
        PsiType type1 = parameter1.getType();
        if (!type1.equals(parameter2.getType())) {
            return EXACTLY_UN_MATCHES;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalentDecision(body1, body2).setConcreteIfExactUnMatches(body1, body2);
    }

    private static Decision switchstatementsAreEquivalentDecision(@NotNull PsiSwitchStatement statement1, @NotNull PsiSwitchStatement statement2) {
        PsiCodeBlock body2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchstatementsAreEquivalentDecision"));
        }
        PsiExpression switchExpression1 = statement1.getExpression();
        PsiExpression switchExpression2 = statement2.getExpression();
        PsiCodeBlock body1 = statement1.getBody();
        Decision bodyEq = EquivalenceChecker.codeBlocksAreEquivalentDecision(body1, body2 = statement2.getBody());
        if (bodyEq != EXACTLY_MATCHES) {
            return EXACTLY_UN_MATCHES;
        }
        return EquivalenceChecker.expressionsAreEquivalentDecision(switchExpression1, switchExpression2).setConcreteIfExactUnMatches(switchExpression1, switchExpression2);
    }

    private static Decision doWhilestatementsAreEquivalentDecision(@NotNull PsiDoWhileStatement statement1, @NotNull PsiDoWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "doWhilestatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "doWhilestatementsAreEquivalentDecision"));
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        Decision conditionEq = EquivalenceChecker.expressionsAreEquivalentDecision(condition1, condition2);
        Decision bodyEq = EquivalenceChecker.statementsAreEquivalentDecision(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(bodyEq, conditionEq, body1, body2, condition1, condition2);
    }

    private static Decision assertstatementsAreEquivalentDecision(@NotNull PsiAssertStatement statement1, @NotNull PsiAssertStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "assertstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "assertstatementsAreEquivalentDecision"));
        }
        PsiExpression condition1 = statement1.getAssertCondition();
        PsiExpression condition2 = statement2.getAssertCondition();
        PsiExpression description1 = statement1.getAssertDescription();
        PsiExpression description2 = statement2.getAssertDescription();
        Decision condEq = EquivalenceChecker.expressionsAreEquivalentDecision(condition1, condition2);
        Decision exprEq = EquivalenceChecker.expressionsAreEquivalentDecision(description1, description2);
        return EquivalenceChecker.getComplexElementDecision(condEq, exprEq, condition1, condition2, description1, description2);
    }

    private static Decision synchronizedstatementsAreEquivalentDecision(@NotNull PsiSynchronizedStatement statement1, @NotNull PsiSynchronizedStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "synchronizedstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "synchronizedstatementsAreEquivalentDecision"));
        }
        PsiExpression lock1 = statement1.getLockExpression();
        PsiExpression lock2 = statement2.getLockExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        Decision lockEq = EquivalenceChecker.expressionsAreEquivalentDecision(lock1, lock2);
        Decision blockEq = EquivalenceChecker.codeBlocksAreEquivalentDecision(body1, body2);
        return EquivalenceChecker.getComplexElementDecision(blockEq, lockEq, body1, body2, lock1, lock2);
    }

    private static Decision blockstatementsAreEquivalentDecision(@NotNull PsiBlockStatement statement1, @NotNull PsiBlockStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "blockstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "blockstatementsAreEquivalentDecision"));
        }
        PsiCodeBlock block1 = statement1.getCodeBlock();
        PsiCodeBlock block2 = statement2.getCodeBlock();
        return EquivalenceChecker.codeBlocksAreEquivalentDecision(block1, block2);
    }

    private static Decision breakstatementsAreEquivalentDecision(@NotNull PsiBreakStatement statement1, @NotNull PsiBreakStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "breakstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "breakstatementsAreEquivalentDecision"));
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return Decision.exact(identifier2 == null);
        }
        if (identifier2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return Decision.exact(text1.equals(text2));
    }

    private static Decision continuestatementsAreEquivalentDecision(@NotNull PsiContinueStatement statement1, @NotNull PsiContinueStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "continuestatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "continuestatementsAreEquivalentDecision"));
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return Decision.exact(identifier2 == null);
        }
        if (identifier2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return Decision.exact(text1.equals(text2));
    }

    private static Decision switchLabelstatementsAreEquivalentDecision(@NotNull PsiSwitchLabelStatement statement1, @NotNull PsiSwitchLabelStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchLabelstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchLabelstatementsAreEquivalentDecision"));
        }
        if (statement1.isDefaultCase()) {
            return Decision.exact(statement2.isDefaultCase());
        }
        if (statement2.isDefaultCase()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression caseExpression1 = statement1.getCaseValue();
        PsiExpression caseExpression2 = statement2.getCaseValue();
        return EquivalenceChecker.expressionsAreEquivalentDecision(caseExpression1, caseExpression2).setConcreteIfExactUnMatches(caseExpression1, caseExpression2);
    }

    private static Decision labeledstatementsAreEquivalentDecision(@NotNull PsiLabeledStatement statement1, @NotNull PsiLabeledStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "labeledstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "labeledstatementsAreEquivalentDecision"));
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return Decision.exact(text1.equals(text2));
    }

    public static boolean codeBlocksAreEquivalent(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        return EquivalenceChecker.codeBlocksAreEquivalentDecision(block1, block2).getExactlyMatches();
    }

    public static Decision codeBlocksAreEquivalentDecision(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        if (block1 == null && block2 == null) {
            return EXACTLY_MATCHES;
        }
        if (block1 == null || block2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        PsiStatement[] statements1 = block1.getStatements();
        PsiStatement[] statements2 = block2.getStatements();
        if (statements2.length != statements1.length) {
            return EXACTLY_UN_MATCHES;
        }
        for (int i = 0; i < statements2.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalentDecision(statements2[i], statements1[i]).getExactlyMatches()) continue;
            return EXACTLY_UN_MATCHES;
        }
        return EXACTLY_MATCHES;
    }

    private static Decision ifstatementsAreEquivalentDecision(@NotNull PsiIfStatement statement1, @NotNull PsiIfStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "ifstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "ifstatementsAreEquivalentDecision"));
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement thenBranch1 = statement1.getThenBranch();
        PsiStatement thenBranch2 = statement2.getThenBranch();
        PsiStatement elseBranch1 = statement1.getElseBranch();
        PsiStatement elseBranch2 = statement2.getElseBranch();
        Decision conditionEq = EquivalenceChecker.expressionsAreEquivalentDecision(condition1, condition2);
        Decision thenEq = EquivalenceChecker.statementsAreEquivalentDecision(thenBranch1, thenBranch2);
        Decision elseEq = EquivalenceChecker.statementsAreEquivalentDecision(elseBranch1, elseBranch2);
        if (conditionEq == EXACTLY_MATCHES && thenEq == EXACTLY_MATCHES && elseEq == EXACTLY_MATCHES) {
            return EXACTLY_MATCHES;
        }
        return EXACTLY_UN_MATCHES;
    }

    private static Decision expressionstatementsAreEquivalentDecision(@NotNull PsiExpressionStatement statement1, @NotNull PsiExpressionStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionstatementsAreEquivalentDecision"));
        }
        PsiExpression expression1 = statement1.getExpression();
        PsiExpression expression2 = statement2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalentDecision(expression1, expression2);
    }

    private static Decision returnstatementsAreEquivalentDecision(@NotNull PsiReturnStatement statement1, @NotNull PsiReturnStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "returnstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "returnstatementsAreEquivalentDecision"));
        }
        PsiExpression returnValue1 = statement1.getReturnValue();
        PsiExpression returnValue2 = statement2.getReturnValue();
        return EquivalenceChecker.expressionsAreEquivalentDecision(returnValue1, returnValue2);
    }

    private static Decision throwstatementsAreEquivalentDecision(@NotNull PsiThrowStatement statement1, @NotNull PsiThrowStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "throwstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "throwstatementsAreEquivalentDecision"));
        }
        PsiExpression exception1 = statement1.getException();
        PsiExpression exception2 = statement2.getException();
        return EquivalenceChecker.expressionsAreEquivalentDecision(exception1, exception2);
    }

    private static Decision expressionListstatementsAreEquivalentDecision(@NotNull PsiExpressionListStatement statement1, @NotNull PsiExpressionListStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionListstatementsAreEquivalentDecision"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionListstatementsAreEquivalentDecision"));
        }
        PsiExpressionList expressionList1 = statement1.getExpressionList();
        PsiExpression[] expressions1 = expressionList1.getExpressions();
        PsiExpressionList expressionList2 = statement2.getExpressionList();
        PsiExpression[] expressions2 = expressionList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(expressions1, expressions2);
    }

    public static boolean expressionsAreEquivalent(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        return EquivalenceChecker.expressionsAreEquivalentDecision(expression1, expression2).getExactlyMatches();
    }

    public static Decision expressionsAreEquivalentDecision(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        expression1 = ParenthesesUtils.stripParentheses(expression1);
        expression2 = ParenthesesUtils.stripParentheses(expression2);
        if (expression1 == null) {
            return Decision.exact(expression2 == null);
        }
        if (expression2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        if (expression1.getClass() != expression2.getClass()) {
            return EXACTLY_UN_MATCHES;
        }
        if (expression1 instanceof PsiThisExpression) {
            return EXACTLY_MATCHES;
        }
        if (expression1 instanceof PsiSuperExpression) {
            return EXACTLY_MATCHES;
        }
        if (expression1 instanceof PsiLiteralExpression) {
            return EquivalenceChecker.literalexpressionsAreEquivalentDecision((PsiLiteralExpression)expression1, (PsiLiteralExpression)expression2);
        }
        if (expression1 instanceof PsiClassObjectAccessExpression) {
            return EquivalenceChecker.classObjectAccessexpressionsAreEquivalentDecision((PsiClassObjectAccessExpression)expression1, (PsiClassObjectAccessExpression)expression2);
        }
        if (expression1 instanceof PsiReferenceExpression) {
            return EquivalenceChecker.referenceexpressionsAreEquivalentDecision((PsiReferenceExpression)expression1, (PsiReferenceExpression)expression2);
        }
        if (expression1 instanceof PsiMethodCallExpression) {
            return EquivalenceChecker.methodCallexpressionsAreEquivalentDecision((PsiMethodCallExpression)expression1, (PsiMethodCallExpression)expression2);
        }
        if (expression1 instanceof PsiNewExpression) {
            return EquivalenceChecker.newexpressionsAreEquivalentDecision((PsiNewExpression)expression1, (PsiNewExpression)expression2);
        }
        if (expression1 instanceof PsiArrayInitializerExpression) {
            return EquivalenceChecker.arrayInitializerexpressionsAreEquivalentDecision((PsiArrayInitializerExpression)expression1, (PsiArrayInitializerExpression)expression2);
        }
        if (expression1 instanceof PsiTypeCastExpression) {
            return EquivalenceChecker.typeCastexpressionsAreEquivalentDecision((PsiTypeCastExpression)expression1, (PsiTypeCastExpression)expression2);
        }
        if (expression1 instanceof PsiArrayAccessExpression) {
            return EquivalenceChecker.arrayAccessexpressionsAreEquivalentDecision((PsiArrayAccessExpression)expression2, (PsiArrayAccessExpression)expression1);
        }
        if (expression1 instanceof PsiPrefixExpression) {
            return EquivalenceChecker.prefixexpressionsAreEquivalentDecision((PsiPrefixExpression)expression1, (PsiPrefixExpression)expression2);
        }
        if (expression1 instanceof PsiPostfixExpression) {
            return EquivalenceChecker.postfixexpressionsAreEquivalentDecision((PsiPostfixExpression)expression1, (PsiPostfixExpression)expression2);
        }
        if (expression1 instanceof PsiPolyadicExpression) {
            return EquivalenceChecker.polyadicexpressionsAreEquivalentDecision((PsiPolyadicExpression)expression1, (PsiPolyadicExpression)expression2);
        }
        if (expression1 instanceof PsiAssignmentExpression) {
            return EquivalenceChecker.assignmentexpressionsAreEquivalentDecision((PsiAssignmentExpression)expression1, (PsiAssignmentExpression)expression2);
        }
        if (expression1 instanceof PsiConditionalExpression) {
            return EquivalenceChecker.conditionalexpressionsAreEquivalentDecision((PsiConditionalExpression)expression1, (PsiConditionalExpression)expression2);
        }
        if (expression1 instanceof PsiInstanceOfExpression) {
            return EquivalenceChecker.instanceofexpressionsAreEquivalentDecision((PsiInstanceOfExpression)expression1, (PsiInstanceOfExpression)expression2);
        }
        return EXACTLY_UN_MATCHES;
    }

    private static Decision literalexpressionsAreEquivalentDecision(PsiLiteralExpression expression1, PsiLiteralExpression expression2) {
        Object value1 = expression1.getValue();
        Object value2 = expression2.getValue();
        if (value1 == null) {
            return Decision.exact(value2 == null);
        }
        if (value2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        return Decision.exact(value1.equals(value2));
    }

    private static Decision classObjectAccessexpressionsAreEquivalentDecision(PsiClassObjectAccessExpression expression1, PsiClassObjectAccessExpression expression2) {
        PsiTypeElement operand1 = expression1.getOperand();
        PsiTypeElement operand2 = expression2.getOperand();
        return EquivalenceChecker.typeElementsAreEquivalent(operand1, operand2);
    }

    private static Decision referenceexpressionsAreEquivalentDecision(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
        PsiElement element1 = referenceExpression1.resolve();
        PsiElement element2 = referenceExpression2.resolve();
        if (element1 != null) {
            if (!element1.equals(element2)) {
                return EXACTLY_UN_MATCHES;
            }
        } else {
            return EXACTLY_UN_MATCHES;
        }
        if (element1 instanceof PsiMember) {
            PsiMember member1 = (PsiMember)element1;
            if (member1.hasModifierProperty("static")) {
                return EXACTLY_MATCHES;
            }
            if (member1 instanceof PsiClass) {
                return EXACTLY_MATCHES;
            }
        } else {
            return EXACTLY_MATCHES;
        }
        PsiExpression qualifier1 = referenceExpression1.getQualifierExpression();
        PsiExpression qualifier2 = referenceExpression2.getQualifierExpression();
        if (qualifier1 != null && !(qualifier1 instanceof PsiThisExpression) && !(qualifier1 instanceof PsiSuperExpression)) {
            if (qualifier2 == null) {
                return EXACTLY_UN_MATCHES;
            }
            if (!EquivalenceChecker.expressionsAreEquivalentDecision(qualifier1, qualifier2).getExactlyMatches()) {
                return EXACTLY_UN_MATCHES;
            }
        } else if (qualifier2 != null && !(qualifier2 instanceof PsiThisExpression) && !(qualifier2 instanceof PsiSuperExpression)) {
            return EXACTLY_UN_MATCHES;
        }
        String text1 = referenceExpression1.getText();
        String text2 = referenceExpression2.getText();
        return Decision.exact(text1.equals(text2));
    }

    private static Decision instanceofexpressionsAreEquivalentDecision(PsiInstanceOfExpression instanceOfExpression1, PsiInstanceOfExpression instanceOfExpression2) {
        PsiExpression operand2;
        PsiExpression operand1 = instanceOfExpression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalentDecision(operand1, operand2 = instanceOfExpression2.getOperand()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiTypeElement typeElement1 = instanceOfExpression1.getCheckType();
        PsiTypeElement typeElement2 = instanceOfExpression2.getCheckType();
        return EquivalenceChecker.typeElementsAreEquivalent(typeElement1, typeElement2);
    }

    private static Decision typeElementsAreEquivalent(PsiTypeElement typeElement1, PsiTypeElement typeElement2) {
        if (typeElement1 == null) {
            return Decision.exact(typeElement2 == null);
        }
        if (typeElement2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        PsiType type1 = typeElement1.getType();
        PsiType type2 = typeElement2.getType();
        return Decision.exact(EquivalenceChecker.typesAreEquivalent(type1, type2));
    }

    private static Decision methodCallexpressionsAreEquivalentDecision(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
        PsiReferenceExpression methodExpression2;
        if (methodCallExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "methodCallexpressionsAreEquivalentDecision"));
        }
        if (methodCallExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "methodCallexpressionsAreEquivalentDecision"));
        }
        PsiReferenceExpression methodExpression1 = methodCallExpression1.getMethodExpression();
        if (!EquivalenceChecker.expressionsAreEquivalentDecision(methodExpression1, methodExpression2 = methodCallExpression2.getMethodExpression()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpressionList argumentList1 = methodCallExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1.getExpressions();
        PsiExpressionList argumentList2 = methodCallExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static Decision newexpressionsAreEquivalentDecision(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
        PsiExpression qualifier2;
        PsiArrayInitializerExpression arrayInitializer2;
        PsiExpression[] arrayDimensions2;
        if (newExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "newexpressionsAreEquivalentDecision"));
        }
        if (newExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "newexpressionsAreEquivalentDecision"));
        }
        PsiJavaCodeReferenceElement classReference1 = newExpression1.getClassReference();
        PsiJavaCodeReferenceElement classReference2 = newExpression2.getClassReference();
        if (classReference1 == null || classReference2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        PsiElement target1 = classReference1.resolve();
        if (target1 == null) {
            return EXACTLY_UN_MATCHES;
        }
        PsiElement target2 = classReference2.resolve();
        if (!target1.equals(target2)) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression[] arrayDimensions1 = newExpression1.getArrayDimensions();
        if (!EquivalenceChecker.expressionListsAreEquivalent(arrayDimensions1, arrayDimensions2 = newExpression2.getArrayDimensions()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiArrayInitializerExpression arrayInitializer1 = newExpression1.getArrayInitializer();
        if (!EquivalenceChecker.expressionsAreEquivalentDecision(arrayInitializer1, arrayInitializer2 = newExpression2.getArrayInitializer()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression qualifier1 = newExpression1.getQualifier();
        if (!EquivalenceChecker.expressionsAreEquivalentDecision(qualifier1, qualifier2 = newExpression2.getQualifier()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpressionList argumentList1 = newExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1 == null ? null : argumentList1.getExpressions();
        PsiExpressionList argumentList2 = newExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2 == null ? null : argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static Decision arrayInitializerexpressionsAreEquivalentDecision(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
        if (arrayInitializerExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializerExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayInitializerexpressionsAreEquivalentDecision"));
        }
        if (arrayInitializerExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializerExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayInitializerexpressionsAreEquivalentDecision"));
        }
        PsiExpression[] initializers1 = arrayInitializerExpression1.getInitializers();
        PsiExpression[] initializers2 = arrayInitializerExpression2.getInitializers();
        return EquivalenceChecker.expressionListsAreEquivalent(initializers1, initializers2);
    }

    private static Decision typeCastexpressionsAreEquivalentDecision(@NotNull PsiTypeCastExpression typeCastExpression1, @NotNull PsiTypeCastExpression typeCastExpression2) {
        PsiTypeElement typeElement2;
        if (typeCastExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "typeCastexpressionsAreEquivalentDecision"));
        }
        if (typeCastExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "typeCastexpressionsAreEquivalentDecision"));
        }
        PsiTypeElement typeElement1 = typeCastExpression1.getCastType();
        if (!EquivalenceChecker.typeElementsAreEquivalent(typeElement1, typeElement2 = typeCastExpression2.getCastType()).getExactlyMatches()) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression operand1 = typeCastExpression1.getOperand();
        PsiExpression operand2 = typeCastExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalentDecision(operand1, operand2).setConcreteIfExactUnMatches(operand1, operand2);
    }

    private static Decision arrayAccessexpressionsAreEquivalentDecision(@NotNull PsiArrayAccessExpression arrayAccessExpression1, @NotNull PsiArrayAccessExpression arrayAccessExpression2) {
        if (arrayAccessExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayAccessexpressionsAreEquivalentDecision"));
        }
        if (arrayAccessExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayAccessexpressionsAreEquivalentDecision"));
        }
        PsiExpression arrayExpression2 = arrayAccessExpression1.getArrayExpression();
        PsiExpression arrayExpression1 = arrayAccessExpression2.getArrayExpression();
        PsiExpression indexExpression2 = arrayAccessExpression1.getIndexExpression();
        PsiExpression indexExpression1 = arrayAccessExpression2.getIndexExpression();
        Decision arrayExpressionEq = EquivalenceChecker.expressionsAreEquivalentDecision(arrayExpression2, arrayExpression1);
        if (arrayExpressionEq != EXACTLY_MATCHES) {
            return EXACTLY_UN_MATCHES;
        }
        return EquivalenceChecker.expressionsAreEquivalentDecision(indexExpression1, indexExpression2).setConcreteIfExactUnMatches(indexExpression1, indexExpression2);
    }

    private static Decision prefixexpressionsAreEquivalentDecision(@NotNull PsiPrefixExpression prefixExpression1, @NotNull PsiPrefixExpression prefixExpression2) {
        if (prefixExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "prefixexpressionsAreEquivalentDecision"));
        }
        if (prefixExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "prefixexpressionsAreEquivalentDecision"));
        }
        IElementType tokenType1 = prefixExpression1.getOperationTokenType();
        if (!tokenType1.equals(prefixExpression2.getOperationTokenType())) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression operand1 = prefixExpression1.getOperand();
        PsiExpression operand2 = prefixExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalentDecision(operand1, operand2);
    }

    private static Decision postfixexpressionsAreEquivalentDecision(@NotNull PsiPostfixExpression postfixExpression1, @NotNull PsiPostfixExpression postfixExpression2) {
        if (postfixExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "postfixexpressionsAreEquivalentDecision"));
        }
        if (postfixExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "postfixexpressionsAreEquivalentDecision"));
        }
        IElementType tokenType1 = postfixExpression1.getOperationTokenType();
        if (!tokenType1.equals(postfixExpression2.getOperationTokenType())) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression operand1 = postfixExpression1.getOperand();
        PsiExpression operand2 = postfixExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalentDecision(operand1, operand2);
    }

    private static Decision polyadicexpressionsAreEquivalentDecision(@NotNull PsiPolyadicExpression polyadicExpression1, @NotNull PsiPolyadicExpression polyadicExpression2) {
        PsiExpression[] operands2;
        IElementType tokenType2;
        if (polyadicExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "polyadicExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "polyadicexpressionsAreEquivalentDecision"));
        }
        if (polyadicExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "polyadicExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "polyadicexpressionsAreEquivalentDecision"));
        }
        IElementType tokenType1 = polyadicExpression1.getOperationTokenType();
        if (!tokenType1.equals(tokenType2 = polyadicExpression2.getOperationTokenType())) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression[] operands1 = polyadicExpression1.getOperands();
        if (operands1.length != (operands2 = polyadicExpression2.getOperands()).length) {
            return EXACTLY_UN_MATCHES;
        }
        Decision incompleteDecision = null;
        int length = operands1.length;
        for (int i = 0; i < length; ++i) {
            Decision decisionForCurrentOperand = EquivalenceChecker.expressionsAreEquivalentDecision(operands1[i], operands2[i]);
            if (decisionForCurrentOperand.getExactlyMatches()) continue;
            if (incompleteDecision == null) {
                incompleteDecision = decisionForCurrentOperand.isExactUnMatches() ? new Decision(operands1[i], operands2[i]) : decisionForCurrentOperand;
                continue;
            }
            return EXACTLY_UN_MATCHES;
        }
        return incompleteDecision != null ? incompleteDecision : EXACTLY_MATCHES;
    }

    private static Decision assignmentexpressionsAreEquivalentDecision(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
        if (assignmentExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "assignmentexpressionsAreEquivalentDecision"));
        }
        if (assignmentExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "assignmentexpressionsAreEquivalentDecision"));
        }
        IElementType tokenType1 = assignmentExpression1.getOperationTokenType();
        if (!tokenType1.equals(assignmentExpression2.getOperationTokenType())) {
            return EXACTLY_UN_MATCHES;
        }
        PsiExpression lhs1 = assignmentExpression1.getLExpression();
        PsiExpression lhs2 = assignmentExpression2.getLExpression();
        PsiExpression rhs1 = assignmentExpression1.getRExpression();
        PsiExpression rhs2 = assignmentExpression2.getRExpression();
        Decision leftEq = EquivalenceChecker.expressionsAreEquivalentDecision(lhs1, lhs2);
        Decision rightEq = EquivalenceChecker.expressionsAreEquivalentDecision(rhs1, rhs2);
        return EquivalenceChecker.getComplexElementDecision(leftEq, rightEq, lhs1, lhs2, rhs1, rhs2);
    }

    private static Decision conditionalexpressionsAreEquivalentDecision(@NotNull PsiConditionalExpression conditionalExpression1, @NotNull PsiConditionalExpression conditionalExpression2) {
        if (conditionalExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionalExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "conditionalexpressionsAreEquivalentDecision"));
        }
        if (conditionalExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionalExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "conditionalexpressionsAreEquivalentDecision"));
        }
        PsiExpression condition1 = conditionalExpression1.getCondition();
        PsiExpression condition2 = conditionalExpression2.getCondition();
        PsiExpression thenExpression1 = conditionalExpression1.getThenExpression();
        PsiExpression thenExpression2 = conditionalExpression2.getThenExpression();
        PsiExpression elseExpression1 = conditionalExpression1.getElseExpression();
        PsiExpression elseExpression2 = conditionalExpression2.getElseExpression();
        if (EquivalenceChecker.expressionsAreEquivalentDecision(condition1, condition2) == EXACTLY_MATCHES && EquivalenceChecker.expressionsAreEquivalentDecision(thenExpression1, thenExpression2) == EXACTLY_MATCHES && EquivalenceChecker.expressionsAreEquivalentDecision(elseExpression1, elseExpression2) == EXACTLY_MATCHES) {
            return EXACTLY_MATCHES;
        }
        return EXACTLY_UN_MATCHES;
    }

    private static Decision expressionListsAreEquivalent(@Nullable PsiExpression[] expressions1, @Nullable PsiExpression[] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return Decision.exact(true);
        }
        if (expressions1 == null || expressions2 == null) {
            return EXACTLY_UN_MATCHES;
        }
        if (expressions1.length != expressions2.length) {
            return EXACTLY_UN_MATCHES;
        }
        Decision oneUnMatchedDecision = null;
        for (int i = 0; i < expressions1.length; ++i) {
            Decision currentDecision = EquivalenceChecker.expressionsAreEquivalentDecision(expressions1[i], expressions2[i]);
            if (currentDecision.getExactlyMatches()) continue;
            if (oneUnMatchedDecision == null) {
                oneUnMatchedDecision = currentDecision.isExactUnMatches() ? new Decision(expressions1[i], expressions2[i]) : currentDecision;
                continue;
            }
            return EXACTLY_UN_MATCHES;
        }
        return oneUnMatchedDecision == null ? EXACTLY_MATCHES : oneUnMatchedDecision;
    }

    @NotNull
    private static Decision getComplexElementDecision(Decision equivalence1, Decision equivalence2, PsiElement left1, PsiElement right1, PsiElement left2, PsiElement right2) {
        if (equivalence2 == EXACTLY_MATCHES) {
            if (equivalence1 == EXACTLY_MATCHES) {
                Decision decision = EXACTLY_MATCHES;
                if (decision == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/EquivalenceChecker", "getComplexElementDecision"));
                }
                return decision;
            }
            if (equivalence1 == EXACTLY_UN_MATCHES) {
                Decision decision = new Decision(left1, right1);
                if (decision == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/EquivalenceChecker", "getComplexElementDecision"));
                }
                return decision;
            }
        } else if (equivalence2 == EXACTLY_UN_MATCHES) {
            if (equivalence1 == EXACTLY_UN_MATCHES) {
                Decision decision = EXACTLY_UN_MATCHES;
                if (decision == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/EquivalenceChecker", "getComplexElementDecision"));
                }
                return decision;
            }
            if (equivalence1 == EXACTLY_MATCHES) {
                Decision decision = new Decision(left2, right2);
                if (decision == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/EquivalenceChecker", "getComplexElementDecision"));
                }
                return decision;
            }
        }
        Decision decision = EXACTLY_UN_MATCHES;
        if (decision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/EquivalenceChecker", "getComplexElementDecision"));
        }
        return decision;
    }

    public static class Decision {
        private final PsiElement myLeftDiff;
        private final PsiElement myRightDiff;
        private final Boolean myExactlyMatches;

        private Decision(boolean exactlyMatches) {
            this.myExactlyMatches = exactlyMatches;
            this.myLeftDiff = null;
            this.myRightDiff = null;
        }

        private Decision(PsiElement leftDiff, PsiElement rightDiff) {
            this.myExactlyMatches = null;
            this.myLeftDiff = leftDiff;
            this.myRightDiff = rightDiff;
        }

        public PsiElement getLeftDiff() {
            return this.myLeftDiff;
        }

        public PsiElement getRightDiff() {
            return this.myRightDiff;
        }

        public boolean isExact() {
            return this.myExactlyMatches != null;
        }

        public boolean getExactlyMatches() {
            return this.myExactlyMatches != null && this.myExactlyMatches != false;
        }

        public boolean isExactUnMatches() {
            return this.myExactlyMatches != null && this.myExactlyMatches == false;
        }

        private Decision setConcreteIfExactUnMatches(PsiElement left, PsiElement right) {
            return this == EXACTLY_UN_MATCHES ? new Decision(left, right) : this;
        }

        private static Decision exact(boolean exactMatches) {
            return exactMatches ? EXACTLY_MATCHES : EXACTLY_UN_MATCHES;
        }
    }
}

