/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import org.jetbrains.annotations.NotNull;

class SerializableInnerClassHasSerialVersionUIDFieldVisitor
extends BaseInspectionVisitor {
    private final SerializableInspectionBase inspection;

    public SerializableInnerClassHasSerialVersionUIDFieldVisitor(SerializableInspectionBase inspection) {
        this.inspection = inspection;
    }

    @Override
    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerializableInnerClassHasSerialVersionUIDFieldVisitor", "visitClass"));
        }
        if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
            return;
        }
        if (aClass instanceof PsiTypeParameter) {
            return;
        }
        if (this.inspection.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
            return;
        }
        if (aClass.findFieldByName("serialVersionUID", false) != null) {
            return;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        if (containingClass == null) {
            return;
        }
        if (aClass.hasModifierProperty("static")) {
            return;
        }
        PsiModifierListOwner staticElement = PsiUtil.getEnclosingStaticElement(aClass, containingClass);
        if (staticElement != null) {
            return;
        }
        if (!SerializationUtils.isSerializable(aClass)) {
            return;
        }
        if (this.inspection.isIgnoredSubclass(aClass)) {
            return;
        }
        this.registerClassError(aClass, new Object[0]);
    }
}

