/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class PausesStat {
    private static final int N_MAX = 200000;
    private final TIntArrayList pauses;
    private final long epochStart;
    @NotNull
    private final String myName;
    private volatile boolean started;
    private int maxDuration;
    private Object maxDurationDescription;
    private int totalNumberRecorded;

    public PausesStat(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/PausesStat", "<init>"));
        }
        this.pauses = new TIntArrayList();
        this.myName = name;
        this.epochStart = System.currentTimeMillis();
    }

    private int register() {
        int stamp = (int)(System.currentTimeMillis() - this.epochStart);
        this.pauses.add(stamp);
        return stamp;
    }

    public void started() {
        assert (!this.started);
        if (this.pauses.size() > 200000) {
            int toDelete = 50000;
            assert (toDelete % 2 == 0) : toDelete;
            this.pauses.remove(0, toDelete);
            this.maxDuration = 0;
        }
        this.register();
        this.started = true;
    }

    public void finished(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/PausesStat", "finished"));
        }
        assert (this.started);
        int startStamp = this.pauses.get(this.pauses.size() - 1);
        int finishStamp = this.register();
        int duration = finishStamp - startStamp;
        this.started = false;
        if (duration > this.maxDuration) {
            this.maxDuration = duration;
            this.maxDurationDescription = description;
        }
        ++this.totalNumberRecorded;
    }

    public String statistics() {
        int total = 0;
        int number = this.pauses.size() / 2;
        int[] duration = new int[number];
        for (int i = 0; i < number * 2; i += 2) {
            int start = this.pauses.get(i);
            int finish = this.pauses.get(i + 1);
            int thisDuration = finish - start;
            total += thisDuration;
            duration[i / 2] = thisDuration;
        }
        return this.myName + " Statistics:" + "\nTotal number:     " + number + (this.totalNumberRecorded == number ? "" : " (Total number recorded: " + this.totalNumberRecorded + ")") + "\nTotal time spent: " + total + "ms" + "\nAverage duration: " + (number == 0 ? 0 : total / number) + "ms" + "\nMedian  duration: " + ArrayUtil.averageAmongMedians(duration, 3) + "ms" + "\nMax  duration:    " + this.maxDuration + "ms (it was '" + this.maxDurationDescription + "')";
    }
}

