/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.objectTree.ThrowableInterner;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceableDisposable {
    private final Throwable CREATE_TRACE;
    private Throwable KILL_TRACE;

    public TraceableDisposable(boolean debug) {
        this.CREATE_TRACE = debug ? ThrowableInterner.intern(new Throwable()) : null;
    }

    public void kill(@NonNls @Nullable String msg) {
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = ThrowableInterner.intern(new Throwable(msg));
        }
    }

    public void killExceptionally(@NotNull Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/intellij/openapi/util/TraceableDisposable", "killExceptionally"));
        }
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = throwable;
        }
    }

    public void throwDisposalError(@NonNls String msg) throws RuntimeException {
        throw new DisposalException(msg);
    }

    @NotNull
    public String getStackTrace() {
        StringWriter out = new StringWriter();
        new DisposalException("").printStackTrace(new PrintWriter(out));
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TraceableDisposable", "getStackTrace"));
        }
        return string;
    }

    private class DisposalException
    extends RuntimeException {
        private DisposalException(String message) {
            super(message);
        }

        @Override
        public void printStackTrace(@NotNull PrintStream s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/TraceableDisposable$DisposalException", "printStackTrace"));
            }
            PrintWriter writer = new PrintWriter(s);
            this.printStackTrace(writer);
            writer.flush();
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (TraceableDisposable.this.CREATE_TRACE != null) {
                s.println("--------------Creation trace: ");
                TraceableDisposable.this.CREATE_TRACE.printStackTrace(s);
            }
            if (TraceableDisposable.this.KILL_TRACE != null) {
                s.println("--------------Kill trace: ");
                TraceableDisposable.this.KILL_TRACE.printStackTrace(s);
            }
            s.println("-------------Own trace:");
            super.printStackTrace(s);
        }
    }
}

