/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create("java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        super(manager, file);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        super(manager, file, eventSystemEnabled, JavaClassFileType.INSTANCE);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        FileIndexFacade fileIndex = ServiceManager.getService(project, FileIndexFacade.class);
        if (!fileIndex.isInLibraryClasses(file) && fileIndex.isInSource(file)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (ClassFileViewProvider.isInnerClass(file)) {
            return null;
        }
        return new ClsFileImpl(this);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        String name = file.getNameWithoutExtension();
        int index = name.lastIndexOf(36);
        if (index > 0 && index < name.length() - 1) {
            String parentName = name.substring(0, index);
            String childName = name.substring(index + 1);
            if (file.getParent().findChild(parentName + ".class") != null) {
                return ClassFileViewProvider.isInnerClass(file, parentName, childName);
            }
        }
        return false;
    }

    private static boolean isInnerClass(VirtualFile file, final String parentName, final String childName) {
        Boolean isInner = IS_INNER_CLASS.get(file);
        if (isInner != null) {
            return isInner;
        }
        final Ref<Boolean> ref = Ref.create(Boolean.FALSE);
        try {
            new MyClassReader(file.contentsToByteArray(false)).accept(new ClassVisitor(327680){

                public void visitOuterClass(String owner, String name, String desc) {
                    ref.set(Boolean.TRUE);
                    throw new ProcessCanceledException();
                }

                public void visitInnerClass(String name, String outer, String inner, int access) {
                    if ((inner == null || childName.equals(inner)) && outer != null && parentName.equals(outer.substring(outer.lastIndexOf(47) + 1)) || inner == null && outer == null && name.substring(name.lastIndexOf(47) + 1).equals(parentName + '$' + childName)) {
                        ref.set(Boolean.TRUE);
                        throw new ProcessCanceledException();
                    }
                }
            }, 7);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Exception e) {
            Logger.getInstance(ClassFileViewProvider.class).warn(file.getPath(), e);
        }
        isInner = ref.get();
        IS_INNER_CLASS.set(file, isInner);
        return isInner;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(this.getManager(), copy, false);
        if (classFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        return classFileViewProvider;
    }

    private static class MyClassReader
    extends ClassReader {
        public MyClassReader(byte[] b) {
            super(b);
        }

        protected Label readLabel(int offset, Label[] labels) {
            return null;
        }
    }
}

