/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.unusedImport.UnusedImportLocalInspection;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import org.jetbrains.annotations.NotNull;

public final class JavaHighlightInfoTypes {
    public static final HighlightInfoType UNUSED_IMPORT = new HighlightInfoType.HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister("UNUSED_IMPORT", UnusedImportLocalInspection.DISPLAY_NAME), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
    public static final HighlightInfoType JAVA_KEYWORD = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, JavaHighlightingColors.KEYWORD);
    public static final HighlightInfoType CLASS_NAME = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.CLASS_NAME_ATTRIBUTES);
    public static final HighlightInfoType LOCAL_VARIABLE = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.LOCAL_VARIABLE_ATTRIBUTES);
    public static final HighlightInfoType INSTANCE_FIELD = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.INSTANCE_FIELD_ATTRIBUTES);
    public static final HighlightInfoType INSTANCE_FINAL_FIELD = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.INSTANCE_FINAL_FIELD_ATTRIBUTES);
    public static final HighlightInfoType STATIC_FIELD = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.STATIC_FIELD_ATTRIBUTES);
    public static final HighlightInfoType STATIC_FINAL_FIELD = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.STATIC_FINAL_FIELD_ATTRIBUTES);
    public static final HighlightInfoType PARAMETER = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.PARAMETER_ATTRIBUTES);
    public static final HighlightInfoType METHOD_CALL = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.METHOD_CALL_ATTRIBUTES);
    public static final HighlightInfoType METHOD_DECLARATION = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.METHOD_DECLARATION_ATTRIBUTES);
    public static final HighlightInfoType CONSTRUCTOR_CALL = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.CONSTRUCTOR_CALL_ATTRIBUTES);
    public static final HighlightInfoType CONSTRUCTOR_DECLARATION = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.CONSTRUCTOR_DECLARATION_ATTRIBUTES);
    public static final HighlightInfoType STATIC_METHOD = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.STATIC_METHOD_ATTRIBUTES);
    public static final HighlightInfoType ABSTRACT_METHOD = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.ABSTRACT_METHOD_ATTRIBUTES);
    public static final HighlightInfoType INHERITED_METHOD = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.INHERITED_METHOD_ATTRIBUTES);
    public static final HighlightInfoType ANONYMOUS_CLASS_NAME = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.ANONYMOUS_CLASS_NAME_ATTRIBUTES);
    public static final HighlightInfoType INTERFACE_NAME = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.INTERFACE_NAME_ATTRIBUTES);
    public static final HighlightInfoType ENUM_NAME = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.ENUM_NAME_ATTRIBUTES);
    public static final HighlightInfoType TYPE_PARAMETER_NAME = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.TYPE_PARAMETER_NAME_ATTRIBUTES);
    public static final HighlightInfoType ABSTRACT_CLASS_NAME = JavaHighlightInfoTypes.createSymbolTypeInfo(CodeInsightColors.ABSTRACT_CLASS_NAME_ATTRIBUTES);
    public static final HighlightInfoType ANNOTATION_NAME = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.ANNOTATION_NAME_ATTRIBUTES);
    public static final HighlightInfoType ANNOTATION_ATTRIBUTE_NAME = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.ANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES);
    public static final HighlightInfoType REASSIGNED_LOCAL_VARIABLE = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.REASSIGNED_LOCAL_VARIABLE_ATTRIBUTES);
    public static final HighlightInfoType REASSIGNED_PARAMETER = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.REASSIGNED_PARAMETER_ATTRIBUTES);
    public static final HighlightInfoType IMPLICIT_ANONYMOUS_CLASS_PARAMETER = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.IMPLICIT_ANONYMOUS_CLASS_PARAMETER_ATTRIBUTES);

    private JavaHighlightInfoTypes() {
    }

    private static HighlightInfoType createSymbolTypeInfo(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributesKey", "com/intellij/codeInsight/daemon/impl/JavaHighlightInfoTypes", "createSymbolTypeInfo"));
        }
        return new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, attributesKey, false);
    }
}

