/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoreProjectJdkTable
extends ProjectJdkTable {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sdk findJdk(String name) {
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            for (Sdk jdk : this.mySdks) {
                if (!Comparing.strEqual(name, jdk.getName())) continue;
                return jdk;
            }
        }
        return null;
    }

    @Override
    public Sdk findJdk(String name, String type) {
        return this.findJdk(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sdk[] getAllJdks() {
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            return this.mySdks.toArray(new Sdk[this.mySdks.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Sdk> getSdksOfType(SdkTypeId type) {
        ArrayList<Sdk> result = new ArrayList<Sdk>();
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            for (Sdk sdk : this.mySdks) {
                if (sdk.getSdkType() != type) continue;
                result.add(sdk);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJdk(Sdk jdk) {
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            this.mySdks.add(jdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJdk(Sdk jdk) {
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            this.mySdks.remove(jdk);
        }
    }

    @Override
    public void updateJdk(Sdk originalJdk, Sdk modifiedJdk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(ProjectJdkTable.Listener listener) {
    }

    @Override
    public void removeListener(ProjectJdkTable.Listener listener) {
    }

    @Override
    public SdkTypeId getDefaultSdkType() {
        return CoreSdkType.INSTANCE;
    }

    @Override
    public SdkTypeId getSdkTypeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreProjectJdkTable", "getSdkTypeByName"));
        }
        return CoreSdkType.INSTANCE;
    }

    @Override
    public Sdk createSdk(String name, SdkTypeId sdkType) {
        throw new UnsupportedOperationException();
    }
}

