/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileReferenceHelperRegistrar {
    private FileReferenceHelperRegistrar() {
    }

    public static FileReferenceHelper[] getHelpers() {
        return Extensions.getExtensions(FileReferenceHelper.EP_NAME);
    }

    @Deprecated
    @NotNull
    public static <T extends PsiFileSystemItem> FileReferenceHelper getNotNullHelper(@NotNull T psiFileSystemItem) {
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileSystemItem", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar", "getNotNullHelper"));
        }
        FileReferenceHelper helper = FileReferenceHelperRegistrar.getHelper(psiFileSystemItem);
        if (helper != null) {
            FileReferenceHelper fileReferenceHelper = helper;
            if (fileReferenceHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar", "getNotNullHelper"));
            }
            return fileReferenceHelper;
        }
        FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
        FileReferenceHelper fileReferenceHelper = helpers[helpers.length - 1];
        if (fileReferenceHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar", "getNotNullHelper"));
        }
        return fileReferenceHelper;
    }

    @Deprecated
    public static <T extends PsiFileSystemItem> FileReferenceHelper getHelper(@NotNull T psiFileSystemItem) {
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileSystemItem", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar", "getHelper"));
        }
        final VirtualFile file = psiFileSystemItem.getVirtualFile();
        if (file == null) {
            return null;
        }
        final Project project = psiFileSystemItem.getProject();
        return ContainerUtil.find(FileReferenceHelperRegistrar.getHelpers(), new Condition<FileReferenceHelper>(){

            @Override
            public boolean value(FileReferenceHelper fileReferenceHelper) {
                return fileReferenceHelper.isMine(project, file);
            }
        });
    }

    public static <T extends PsiFileSystemItem> List<FileReferenceHelper> getHelpers(@NotNull T psiFileSystemItem) {
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileSystemItem", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar", "getHelpers"));
        }
        final VirtualFile file = psiFileSystemItem.getVirtualFile();
        if (file == null) {
            return null;
        }
        final Project project = psiFileSystemItem.getProject();
        return ContainerUtil.findAll(FileReferenceHelperRegistrar.getHelpers(), new Condition<FileReferenceHelper>(){

            @Override
            public boolean value(FileReferenceHelper fileReferenceHelper) {
                return fileReferenceHelper.isMine(project, file);
            }
        });
    }

    public static boolean areElementsEquivalent(@NotNull PsiFileSystemItem element1, @NotNull PsiFileSystemItem element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelperRegistrar", "areElementsEquivalent"));
        }
        return element2.getManager().areElementsEquivalent(element1, element2);
    }
}

