/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.BaseInspection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MethodMatcher {
    private final List<String> myMethodNamePatterns = ContainerUtil.newArrayList();
    private final List<String> myClassNames = ContainerUtil.newArrayList();
    private final Map<String, Pattern> myPatternCache = ContainerUtil.newHashMap();
    private final boolean myWriteDefaults;
    private final String myOptionName;
    private String myDefaultSettings = null;

    public MethodMatcher() {
        this(false, "METHOD_MATCHER_CONFIG");
    }

    public MethodMatcher(boolean writeDefaults, String optionName) {
        this.myWriteDefaults = writeDefaults;
        this.myOptionName = optionName;
    }

    public MethodMatcher add(@NotNull String className, @NotNull String methodNamePattern) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/siyeh/ig/psiutils/MethodMatcher", "add"));
        }
        if (methodNamePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNamePattern", "com/siyeh/ig/psiutils/MethodMatcher", "add"));
        }
        this.myClassNames.add(className);
        this.myMethodNamePatterns.add(methodNamePattern);
        return this;
    }

    @NotNull
    protected String getOptionName() {
        String string = this.myOptionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/MethodMatcher", "getOptionName"));
        }
        return string;
    }

    public List<String> getMethodNamePatterns() {
        return this.myMethodNamePatterns;
    }

    public List<String> getClassNames() {
        return this.myClassNames;
    }

    public boolean matches(PsiMethod method) {
        String methodName = method.getName();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        int size = this.myMethodNamePatterns.size();
        for (int i = 0; i < size; ++i) {
            String className;
            Pattern pattern = this.getPattern(i);
            if (pattern == null || !pattern.matcher(methodName).matches() || !InheritanceUtil.isInheritor(aClass, className = this.myClassNames.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean matches(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (methodName == null) {
            return false;
        }
        PsiClass aClass = null;
        int size = this.myMethodNamePatterns.size();
        for (int i = 0; i < size; ++i) {
            String className;
            Pattern pattern = this.getPattern(i);
            if (pattern == null || !pattern.matcher(methodName).matches()) continue;
            if (aClass == null) {
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null || method.isConstructor()) {
                    return false;
                }
                aClass = method.getContainingClass();
            }
            if (!InheritanceUtil.isInheritor(aClass, className = this.myClassNames.get(i))) continue;
            return true;
        }
        return false;
    }

    private Pattern getPattern(int i) {
        String methodNamePattern = this.myMethodNamePatterns.get(i);
        Pattern pattern = this.myPatternCache.get(methodNamePattern);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(methodNamePattern);
                this.myPatternCache.put(methodNamePattern, pattern);
            }
            catch (PatternSyntaxException ignore) {
                return null;
            }
            catch (NullPointerException ignore) {
                return null;
            }
        }
        return pattern;
    }

    public MethodMatcher finishDefault() {
        if (this.myDefaultSettings != null) {
            throw new IllegalStateException();
        }
        this.myDefaultSettings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        return this;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/psiutils/MethodMatcher", "readSettings"));
        }
        String settings = null;
        for (Element option : node.getChildren("option")) {
            if (!option.getAttributeValue("name").equals(this.getOptionName())) continue;
            settings = option.getAttributeValue("value");
            break;
        }
        if (settings == null) {
            return;
        }
        this.myPatternCache.clear();
        this.myClassNames.clear();
        this.myMethodNamePatterns.clear();
        BaseInspection.parseString(settings, this.myClassNames, this.myMethodNamePatterns);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/psiutils/MethodMatcher", "writeSettings"));
        }
        String settings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        if (!this.myWriteDefaults && settings.equals(this.myDefaultSettings)) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", this.getOptionName()).setAttribute("value", settings));
    }
}

