/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.psi.DummyHolderViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyHolder
extends PsiFileImpl {
    protected final PsiElement myContext;
    private final CharTable myTable;
    private final Boolean myExplicitlyValid;
    private final Language myLanguage;
    private volatile FileElement myFileElement;
    private final DummyHolderTreeLock myTreeElementLock;
    private FileViewProvider myViewProvider;

    public DummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, contentElement, context, SharedImplUtil.findCharTableByTree(contentElement));
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table, boolean validity) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, null, table, validity, PlainTextLanguage.INSTANCE);
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, context, null);
    }

    public DummyHolder(@NotNull PsiManager manager, @Nullable TreeElement contentElement, PsiElement context, @Nullable CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, contentElement, context, table, null, DummyHolder.language(context, PlainTextLanguage.INSTANCE));
    }

    protected static Language language(PsiElement context, Language defaultLanguage) {
        if (context == null) {
            return defaultLanguage;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return defaultLanguage;
        }
        Language contextLanguage = context.getLanguage();
        Language language = file.getLanguage();
        if (language.isKindOf(contextLanguage)) {
            return language;
        }
        return contextLanguage;
    }

    public DummyHolder(@NotNull PsiManager manager, @Nullable TreeElement contentElement, @Nullable PsiElement context, @Nullable CharTable table, @Nullable Boolean validity, Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        super(TokenType.DUMMY_HOLDER, TokenType.DUMMY_HOLDER, new DummyHolderViewProvider(manager));
        this.myFileElement = null;
        this.myTreeElementLock = new DummyHolderTreeLock();
        this.myViewProvider = null;
        this.myLanguage = language;
        ((DummyHolderViewProvider)this.getViewProvider()).setDummyHolder(this);
        this.myContext = context;
        CharTable charTable = this.myTable = table != null ? table : IdentityCharTable.INSTANCE;
        if (contentElement instanceof FileElement) {
            this.myFileElement = (FileElement)contentElement;
            this.myFileElement.setPsi(this);
            this.myFileElement.setCharTable(this.myTable);
        } else if (contentElement != null) {
            this.getTreeElement().rawAddChildren(contentElement);
            this.clearCaches();
        }
        this.myExplicitlyValid = validity;
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, context, table);
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table, Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, null, table, null, language);
    }

    public DummyHolder(@NotNull PsiManager manager, Language language, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, context, null, null, language);
    }

    @Override
    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    @Override
    public boolean isValid() {
        if (this.myExplicitlyValid != null) {
            return this.myExplicitlyValid;
        }
        return super.isValid();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/DummyHolder", "accept"));
        }
        visitor.visitFile(this);
    }

    @Override
    public String toString() {
        return "DummyHolder";
    }

    @Override
    @NotNull
    public FileType getFileType() {
        PsiFile containingFile;
        PsiElement context = this.getContext();
        if (context != null && (containingFile = context.getContainingFile()) != null) {
            FileType fileType = containingFile.getFileType();
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getFileType"));
            }
            return fileType;
        }
        LanguageFileType fileType = this.myLanguage.getAssociatedFileType();
        LanguageFileType languageFileType = fileType != null ? fileType : PlainTextFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getFileType"));
        }
        return languageFileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileElement getTreeElement() {
        FileElement fileElement = this.myFileElement;
        if (fileElement != null) {
            return fileElement;
        }
        DummyHolderTreeLock dummyHolderTreeLock = this.myTreeElementLock;
        synchronized (dummyHolderTreeLock) {
            fileElement = this.myFileElement;
            if (fileElement == null) {
                fileElement = new FileElement(TokenType.DUMMY_HOLDER, null);
                fileElement.setPsi(this);
                if (this.myTable != null) {
                    fileElement.setCharTable(this.myTable);
                }
                this.myFileElement = fileElement;
                this.clearCaches();
            }
            return fileElement;
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getLanguage"));
        }
        return language;
    }

    @Override
    protected PsiFileImpl clone() {
        PsiFileImpl psiClone = this.cloneImpl(this.myFileElement);
        DummyHolderViewProvider dummyHolderViewProvider = new DummyHolderViewProvider(this.getManager());
        this.myViewProvider = dummyHolderViewProvider;
        dummyHolderViewProvider.setDummyHolder((DummyHolder)psiClone);
        FileElement treeClone = (FileElement)this.calcTreeElement().clone();
        psiClone.setTreeElementPointer(treeClone);
        psiClone.myOriginalFile = this.isPhysical() ? this : this.myOriginalFile;
        treeClone.setPsi(psiClone);
        return psiClone;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getViewProvider"));
        }
        return fileViewProvider;
    }

    private static class DummyHolderTreeLock {
        private DummyHolderTreeLock() {
        }
    }
}

