/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightClassUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    @Nullable
    static HighlightInfo checkAbstractInstantiation(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkAbstractInstantiation"));
        }
        PsiElement parent = ref.getParent();
        HighlightInfo highlightInfo = null;
        if (parent instanceof PsiAnonymousClass && parent.getParent() instanceof PsiNewExpression && !PsiUtilCore.hasErrorElementChild(parent.getParent())) {
            PsiAnonymousClass aClass = (PsiAnonymousClass)parent;
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods(aClass, ref.getTextRange());
        }
        return highlightInfo;
    }

    @Nullable
    private static HighlightInfo checkClassWithAbstractMethods(PsiClass aClass, TextRange range) {
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, aClass, range);
    }

    @Nullable
    static HighlightInfo checkClassWithAbstractMethods(PsiClass aClass, PsiElement implementsFixElement, TextRange range) {
        PsiMethod abstractMethod = ClassUtil.getAnyAbstractMethod(aClass);
        if (abstractMethod == null) {
            return null;
        }
        PsiClass superClass = abstractMethod.getContainingClass();
        if (superClass == null) {
            return null;
        }
        String baseClassName = HighlightUtil.formatClass(aClass, false);
        String methodName = JavaHighlightUtil.formatMethod(abstractMethod);
        String message = JavaErrorMessages.message(aClass instanceof PsiEnumConstantInitializer || implementsFixElement instanceof PsiEnumConstant ? "enum.constant.should.implement.method" : "class.must.be.abstract", baseClassName, methodName, HighlightUtil.formatClass(superClass, false));
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        PsiMethod anyMethodToImplement = ClassUtil.getAnyMethodToImplement(aClass);
        if (anyMethodToImplement != null) {
            if (!anyMethodToImplement.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance(aClass.getProject()).arePackagesTheSame(aClass, superClass)) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createImplementMethodsFix(implementsFixElement));
            } else {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(anyMethodToImplement, "protected", true, true));
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(anyMethodToImplement, "public", true, true));
            }
        }
        if (!(aClass instanceof PsiAnonymousClass) && HighlightUtil.getIncompatibleModifier("abstract", aClass.getModifierList()) == null) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(aClass, "abstract", true, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkClassMustBeAbstract(PsiClass aClass, TextRange textRange) {
        if (aClass.hasModifierProperty("abstract") || aClass.getRBrace() == null || aClass.isEnum() && HighlightClassUtil.hasEnumConstants(aClass)) {
            return null;
        }
        return HighlightClassUtil.checkClassWithAbstractMethods(aClass, textRange);
    }

    @Nullable
    static HighlightInfo checkInstantiationOfAbstractClass(PsiClass aClass, @NotNull PsiElement highlightElement) {
        if (highlightElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightElement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkInstantiationOfAbstractClass"));
        }
        HighlightInfo errorResult = null;
        if (!(aClass == null || !aClass.hasModifierProperty("abstract") || highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getType() instanceof PsiArrayType)) {
            String baseClassName = aClass.getName();
            String message = JavaErrorMessages.message("abstract.cannot.be.instantiated", baseClassName);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(highlightElement).descriptionAndTooltip(message).create();
            PsiMethod anyAbstractMethod = ClassUtil.getAnyAbstractMethod(aClass);
            if (!aClass.isInterface() && anyAbstractMethod == null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(aClass, "abstract", false, false));
            }
            if (anyAbstractMethod != null && highlightElement instanceof PsiNewExpression && ((PsiNewExpression)highlightElement).getClassReference() != null) {
                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createImplementAbstractClassMethodsFix(highlightElement));
            }
        }
        return errorResult;
    }

    private static boolean hasEnumConstants(PsiClass aClass) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getFields()) {
            if (!(field instanceof PsiEnumConstant)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkDuplicateTopLevelClass(PsiClass aClass) {
        if (!(aClass.getParent() instanceof PsiFile)) {
            return null;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        int numOfClassesToFind = 2;
        if (qualifiedName.contains("$")) {
            qualifiedName = qualifiedName.replaceAll("\\$", ".");
            numOfClassesToFind = 1;
        }
        PsiManager manager = aClass.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement(aClass);
        if (module == null) {
            return null;
        }
        PsiClass[] classes = JavaPsiFacade.getInstance(aClass.getProject()).findClasses(qualifiedName, GlobalSearchScope.moduleScope(module));
        if (classes.length < numOfClassesToFind) {
            return null;
        }
        String dupFileName = null;
        for (PsiClass dupClass : classes) {
            VirtualFile file;
            if (dupClass == aClass || (file = dupClass.getContainingFile().getVirtualFile()) == null || !manager.isInProject(dupClass)) continue;
            dupFileName = FileUtil.toSystemDependentName(file.getPath());
            break;
        }
        if (dupFileName == null) {
            return null;
        }
        String message = JavaErrorMessages.message("duplicate.class.in.other.file", dupFileName);
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message).create();
    }

    @Nullable
    static HighlightInfo checkDuplicateNestedClass(PsiClass aClass) {
        String name;
        if (aClass == null) {
            return null;
        }
        PsiElement parent = aClass;
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            parent = aClass.getParent();
        }
        if ((name = aClass.getName()) == null) {
            return null;
        }
        boolean duplicateFound = false;
        boolean checkSiblings = true;
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiElement element;
            PsiElement psiElement = element = checkSiblings ? parent.getPrevSibling() : null;
            if (element == null && ((element = parent.getParent()) instanceof PsiMethod || element instanceof PsiClass || element instanceof PsiCodeBlock && element.getParent() instanceof PsiClassInitializer)) {
                checkSiblings = false;
            }
            parent = element;
            if (element instanceof PsiDeclarationStatement) {
                element = PsiTreeUtil.getChildOfType(element, PsiClass.class);
            }
            if (!(element instanceof PsiClass) || !name.equals(((PsiClass)element).getName())) continue;
            duplicateFound = true;
            break;
        }
        if (duplicateFound) {
            String message = JavaErrorMessages.message("duplicate.class", name);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPublicClassInRightFile(PsiClass aClass) {
        PsiFile containingFile = aClass.getContainingFile();
        if (aClass.getParent() != containingFile || !aClass.hasModifierProperty("public") || !(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile file = (PsiJavaFile)containingFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || aClass.getName().equals(virtualFile.getNameWithoutExtension())) {
            return null;
        }
        String message = JavaErrorMessages.message("public.class.should.be.named.after.file", aClass.getName());
        TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(aClass, range.getStartOffset(), range.getEndOffset()).descriptionAndTooltip(message).create();
        PsiModifierList psiModifierList = aClass.getModifierList();
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(psiModifierList, "public", false, false));
        PsiClass[] classes = file.getClasses();
        if (classes.length > 1) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMoveClassToSeparateFileFix(aClass));
        }
        for (PsiClass otherClass : classes) {
            if (otherClass.getManager().areElementsEquivalent(otherClass, aClass) || !otherClass.hasModifierProperty("public") || !otherClass.getName().equals(virtualFile.getNameWithoutExtension())) continue;
            return errorResult;
        }
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createRenameFileFix(aClass.getName() + ".java"));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createRenameElementFix(aClass));
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkClassAndPackageConflict(@NotNull PsiClass aClass) {
        String simpleName;
        PsiDirectory subDirectory;
        PsiElement directory;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkClassAndPackageConflict"));
        }
        String name = aClass.getQualifiedName();
        if ("java.lang".equals(name)) {
            String message = JavaErrorMessages.message("class.clashes.with.package", name);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        }
        PsiElement file = aClass.getParent();
        if (file instanceof PsiJavaFile && !((PsiJavaFile)file).getPackageName().isEmpty() && (directory = file.getParent()) instanceof PsiDirectory && (subDirectory = ((PsiDirectory)directory).findSubdirectory(simpleName = aClass.getName())) != null && simpleName.equals(subDirectory.getName())) {
            String message = JavaErrorMessages.message("class.clashes.with.package", name);
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkStaticFieldDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkStaticFieldDeclarationInInnerClass"));
        }
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiField.class) == null) {
            return null;
        }
        PsiField field = (PsiField)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild(field) || PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
            return null;
        }
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(result, QUICK_FIX_FACTORY.createModifierListFix(field, "static", false, false));
        PsiClass aClass = field.getContainingClass();
        if (aClass != null) {
            QuickFixAction.registerQuickFixAction(result, QUICK_FIX_FACTORY.createModifierListFix(aClass, "static", true, false));
        }
        return result;
    }

    @Nullable
    private static HighlightInfo checkStaticMethodDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiMethod.class) == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild(method)) {
            return null;
        }
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(result, QUICK_FIX_FACTORY.createModifierListFix(method, "static", false, false));
        QuickFixAction.registerQuickFixAction(result, QUICK_FIX_FACTORY.createModifierListFix((PsiClass)keyword.getParent().getParent().getParent(), "static", true, false));
        return result;
    }

    @Nullable
    private static HighlightInfo checkStaticInitializerDeclarationInInnerClass(PsiKeyword keyword) {
        if (HighlightClassUtil.getEnclosingStaticClass(keyword, PsiClassInitializer.class) == null) {
            return null;
        }
        PsiClassInitializer initializer = (PsiClassInitializer)keyword.getParent().getParent();
        if (PsiUtilCore.hasErrorElementChild(initializer)) {
            return null;
        }
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo result = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(keyword).descriptionAndTooltip(message).create();
        QuickFixAction.registerQuickFixAction(result, QUICK_FIX_FACTORY.createModifierListFix(initializer, "static", false, false));
        PsiClass owner = (PsiClass)keyword.getParent().getParent().getParent();
        QuickFixAction.registerQuickFixAction(result, QUICK_FIX_FACTORY.createModifierListFix(owner, "static", true, false));
        return result;
    }

    private static PsiElement getEnclosingStaticClass(@NotNull PsiKeyword keyword, @NotNull Class<?> parentClass) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "getEnclosingStaticClass"));
        }
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "getEnclosingStaticClass"));
        }
        return new PsiMatcherImpl(keyword).dot(PsiMatchers.hasText("static")).parent(PsiMatchers.hasClass(PsiModifierList.class)).parent(PsiMatchers.hasClass(parentClass)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement();
    }

    @Nullable
    private static HighlightInfo checkStaticClassDeclarationInInnerClass(PsiKeyword keyword) {
        PsiClass containingClass;
        if (new PsiMatcherImpl(keyword).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", true)).parent(PsiMatchers.hasClass(PsiClass.class)).dot(JavaMatchers.hasModifier("static", false)).parent(PsiMatchers.hasClass(PsiClass.class, PsiDeclarationStatement.class, PsiNewExpression.class, PsiEnumConstant.class)).getElement() == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)keyword.getParent();
        if (PsiUtilCore.hasErrorElementChild(aClass)) {
            return null;
        }
        PsiElement context = null;
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList != null) {
            for (PsiElement element : modifierList.getChildren()) {
                if (!Comparing.equal(element.getText(), "static")) continue;
                context = element;
                break;
            }
        }
        TextRange range = context != null ? context.getTextRange() : HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        String message = JavaErrorMessages.message("static.declaration.in.inner.class", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message).create();
        if (context != keyword) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(aClass, "static", false, false));
        }
        if ((containingClass = aClass.getContainingClass()) != null) {
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(containingClass, "static", true, false));
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkStaticDeclarationInInnerClass(PsiKeyword keyword) {
        HighlightInfo errorResult = HighlightClassUtil.checkStaticFieldDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticMethodDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticClassDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        errorResult = HighlightClassUtil.checkStaticInitializerDeclarationInInnerClass(keyword);
        if (errorResult != null) {
            return errorResult;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsAllowed(PsiReferenceList list) {
        boolean isExtends;
        PsiClass aClass;
        if (list.getParent() instanceof PsiClass && (aClass = (PsiClass)list.getParent()).isEnum() && (isExtends = list.equals(aClass.getExtendsList()))) {
            String description = JavaErrorMessages.message("extends.after.enum", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkImplementsAllowed(PsiReferenceList list) {
        boolean isImplements;
        PsiClass aClass;
        if (list.getParent() instanceof PsiClass && (aClass = (PsiClass)list.getParent()).isInterface() && (isImplements = list.equals(aClass.getImplementsList()))) {
            String description = JavaErrorMessages.message("implements.after.interface", new Object[0]);
            HighlightInfo result = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list).descriptionAndTooltip(description).create();
            PsiClassType[] referencedTypes = list.getReferencedTypes();
            if (referencedTypes.length > 0) {
                QuickFixAction.registerQuickFixAction(result, QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, referencedTypes[0]));
            }
            return result;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsClassAndImplementsInterface(PsiReferenceList referenceList, JavaResolveResult resolveResult, PsiJavaCodeReferenceElement ref) {
        PsiClass aClass = (PsiClass)referenceList.getParent();
        boolean isImplements = referenceList.equals(aClass.getImplementsList());
        boolean isInterface = aClass.isInterface();
        if (isInterface && isImplements) {
            return null;
        }
        boolean mustBeInterface = isImplements || isInterface;
        HighlightInfo errorResult = null;
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom.isInterface() != mustBeInterface) {
            String message = JavaErrorMessages.message(mustBeInterface ? "interface.expected" : "no.interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ref).descriptionAndTooltip(message).create();
            PsiClassType type = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory().createType(ref);
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createChangeExtendsToImplementsFix(aClass, type));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkCannotInheritFromFinal(PsiClass superClass, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (superClass.hasModifierProperty("final") || superClass.isEnum()) {
            String message = JavaErrorMessages.message("inheritance.from.final.class", superClass.getQualifiedName());
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createModifierListFix(superClass, "final", false, false));
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAnonymousInheritFinal(PsiNewExpression expression) {
        PsiAnonymousClass aClass = PsiTreeUtil.getChildOfType(expression, PsiAnonymousClass.class);
        if (aClass == null) {
            return null;
        }
        PsiClassType baseClassReference = aClass.getBaseClassType();
        PsiClass baseClass = baseClassReference.resolve();
        if (baseClass == null) {
            return null;
        }
        return HighlightClassUtil.checkCannotInheritFromFinal(baseClass, aClass.getBaseClassReference());
    }

    @Nullable
    private static String checkDefaultConstructorThrowsException(PsiMethod constructor, @NotNull PsiClassType[] handledExceptions) {
        if (handledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handledExceptions", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkDefaultConstructorThrowsException"));
        }
        PsiClassType[] referencedTypes = constructor.getThrowsList().getReferencedTypes();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        for (PsiClassType referencedType : referencedTypes) {
            if (ExceptionUtil.isUncheckedException(referencedType) || ExceptionUtil.isHandledBy(referencedType, handledExceptions)) continue;
            exceptions.add(referencedType);
        }
        if (!exceptions.isEmpty()) {
            return HighlightUtil.getUnhandledExceptionsDescriptor(exceptions);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassDoesNotCallSuperConstructorOrHandleExceptions(@NotNull PsiClass aClass, RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkClassDoesNotCallSuperConstructorOrHandleExceptions"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkClassDoesNotCallSuperConstructorOrHandleExceptions"));
        }
        if (aClass.isEnum()) {
            return null;
        }
        if (aClass.getConstructors().length != 0) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, PsiClassType.EMPTY_ARRAY);
    }

    static HighlightInfo checkBaseClassDefaultConstructorProblem(@NotNull PsiClass aClass, RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper, @NotNull TextRange range, @NotNull PsiClassType[] handledExceptions) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (handledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handledExceptions", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkBaseClassDefaultConstructorProblem"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass == null) {
            return null;
        }
        PsiMethod[] constructors = baseClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        for (PsiMethod constructor : constructors) {
            if (!resolveHelper.isAccessible(constructor, aClass, null) || constructor.getParameterList().getParametersCount() != 0 && (constructor.getParameterList().getParametersCount() != 1 || !constructor.isVarArgs())) continue;
            String description = HighlightClassUtil.checkDefaultConstructorThrowsException(constructor, handledExceptions);
            if (description != null) {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
                return info;
            }
            if (refCountHolder != null) {
                refCountHolder.registerLocallyReferenced(constructor);
            }
            return null;
        }
        String description = JavaErrorMessages.message("no.default.constructor.available", HighlightUtil.formatClass(baseClass));
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createCreateConstructorMatchingSuperFix(aClass));
        return info;
    }

    @Nullable
    static HighlightInfo checkInterfaceCannotBeLocal(PsiClass aClass) {
        if (PsiUtil.isLocalClass(aClass)) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            String description = JavaErrorMessages.message("interface.cannot.be.local", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCyclicInheritance(PsiClass aClass) {
        PsiClass circularClass = HighlightClassUtil.getCircularClass(aClass, new HashSet<PsiClass>());
        if (circularClass != null) {
            String description = JavaErrorMessages.message("cyclic.inheritance", HighlightUtil.formatClass(circularClass));
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiClass getCircularClass(PsiClass aClass, Collection<PsiClass> usedClasses) {
        if (usedClasses.contains(aClass)) {
            return aClass;
        }
        try {
            PsiClass[] superTypes;
            usedClasses.add(aClass);
            for (PsiElement superType : superTypes = aClass.getSupers()) {
                while (superType instanceof PsiClass) {
                    PsiClass circularClass;
                    if (!"java.lang.Object".equals(superType.getQualifiedName()) && (circularClass = HighlightClassUtil.getCircularClass(superType, usedClasses)) != null) {
                        PsiClass psiClass = circularClass;
                        return psiClass;
                    }
                    superType = superType.getParent();
                }
            }
        }
        finally {
            usedClasses.remove(aClass);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkExtendsDuplicate(PsiJavaCodeReferenceElement element, PsiElement resolved, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkExtendsDuplicate"));
        }
        if (!(element.getParent() instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList list = (PsiReferenceList)element.getParent();
        if (!(list.getParent() instanceof PsiClass)) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)resolved;
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        int dupCount = 0;
        PsiManager manager = containingFile.getManager();
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass resolvedElement = referencedType.resolve();
            if (resolvedElement == null || !manager.areElementsEquivalent(resolvedElement, aClass)) continue;
            ++dupCount;
        }
        if (dupCount > 1) {
            String description = JavaErrorMessages.message("duplicate.class", HighlightUtil.formatClass(aClass));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassAlreadyImported(PsiClass aClass, PsiElement elementToHighlight) {
        PsiImportStatementBase[] importStatements;
        PsiFile file = aClass.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        if (aClass.getParent() != javaFile) {
            return null;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return null;
        }
        for (PsiImportStatementBase importStatement : importStatements = importList.getAllImportStatements()) {
            PsiElement resolved;
            if (importStatement.isOnDemand() || !((resolved = importStatement.resolve()) instanceof PsiClass) || resolved.equals(aClass) || !Comparing.equal(aClass.getName(), ((PsiClass)resolved).getName(), true)) continue;
            String description = JavaErrorMessages.message("class.already.imported", HighlightUtil.formatClass(aClass, false));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkClassExtendsOnlyOneClass(PsiReferenceList list) {
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.isInterface() && referencedTypes.length > 1 && aClass.getExtendsList() == list) {
            String description = JavaErrorMessages.message("class.cannot.extend.multiple.classes", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkThingNotAllowedInInterface(PsiElement element, PsiClass aClass) {
        if (aClass == null || !aClass.isInterface()) {
            return null;
        }
        String description = JavaErrorMessages.message("not.allowed.in.interface", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
    }

    @Nullable
    static HighlightInfo checkQualifiedNew(PsiNewExpression expression, PsiType type, PsiClass aClass) {
        PsiExpression qualifier = expression.getQualifier();
        if (qualifier == null) {
            return null;
        }
        if (type instanceof PsiArrayType) {
            String description = JavaErrorMessages.message("invalid.qualified.new", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression, null));
            return info;
        }
        HighlightInfo info = null;
        if (aClass != null) {
            PsiClass baseClass;
            if (aClass.hasModifierProperty("static")) {
                String description = JavaErrorMessages.message("qualified.new.of.static.class", new Object[0]);
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
                if (!aClass.isEnum()) {
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createModifierListFix(aClass, "static", false, false));
                }
            } else if (aClass instanceof PsiAnonymousClass && (baseClass = PsiUtil.resolveClassInType(((PsiAnonymousClass)aClass).getBaseClassType())) != null && baseClass.isInterface()) {
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip("Anonymous class implements interface; cannot have qualifier for new").create();
            }
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveNewQualifierFix(expression, aClass));
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkClassExtendsForeignInnerClass(final PsiJavaCodeReferenceElement extendRef, final PsiElement resolved) {
        PsiClass containerClass;
        PsiElement parent = extendRef.getParent();
        if (!(parent instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiClass)) {
            return null;
        }
        final PsiClass aClass = (PsiClass)grand;
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)aClass).getOwner();
            if (!(owner instanceof PsiClass)) {
                return null;
            }
            containerClass = (PsiClass)owner;
        } else {
            containerClass = aClass;
        }
        if (aClass.getExtendsList() != parent && aClass.getImplementsList() != parent) {
            return null;
        }
        if (!(resolved instanceof PsiClass)) {
            String description = JavaErrorMessages.message("class.name.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(extendRef).descriptionAndTooltip(description).create();
        }
        final HighlightInfo[] infos = new HighlightInfo[1];
        extendRef.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (infos[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiClass) {
                    PsiClass base = (PsiClass)resolve;
                    PsiClass baseClass = base.getContainingClass();
                    if (baseClass != null && base.hasModifierProperty("private") && baseClass == containerClass) {
                        String description = JavaErrorMessages.message("private.symbol", HighlightUtil.formatClass(base), HighlightUtil.formatClass(baseClass));
                        infos[0] = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(extendRef).descriptionAndTooltip(description).create();
                        return;
                    }
                    if (!PsiUtil.isInnerClass(base)) {
                        return;
                    }
                    if (!(resolve != resolved || baseClass == null || PsiTreeUtil.isAncestor(baseClass, extendRef, true) && !aClass.hasModifierProperty("static") || InheritanceUtil.hasEnclosingInstanceInScope(baseClass, extendRef, !aClass.hasModifierProperty("static"), true) || HighlightClassUtil.qualifiedNewCalledInConstructors(aClass))) {
                        String description = JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.formatClass(baseClass));
                        infos[0] = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(extendRef).descriptionAndTooltip(description).create();
                    }
                }
            }
        });
        return infos[0];
    }

    private static boolean qualifiedNewCalledInConstructors(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            PsiReferenceExpression referenceExpression;
            PsiExpression qualifierExpression;
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return false;
            }
            PsiStatement firstStatement = statements[0];
            if (!(firstStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpression expression = ((PsiExpressionStatement)firstStatement).getExpression();
            if (!RefactoringChangeUtil.isSuperOrThisMethodCall(expression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            if ("this".equals(methodCallExpression.getMethodExpression().getReferenceName()) || (qualifierExpression = PsiUtil.skipParenthesizedExprDown((referenceExpression = methodCallExpression.getMethodExpression()).getQualifierExpression())) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(PsiNewExpression expression, PsiType type, PsiClass aClass) {
        if (type == null || type instanceof PsiArrayType || type instanceof PsiPrimitiveType) {
            return null;
        }
        if (aClass == null) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve()) == null) {
            return null;
        }
        PsiExpression qualifier = expression.getQualifier();
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)expression, qualifier, aClass);
    }

    @Nullable
    public static HighlightInfo checkCreateInnerClassFromStaticContext(PsiElement element, @Nullable PsiExpression qualifier, PsiClass aClass) {
        PsiElement placeToSearchEnclosingFrom;
        if (qualifier != null) {
            PsiType qType = qualifier.getType();
            placeToSearchEnclosingFrom = PsiUtil.resolveClassInType(qType);
        } else {
            placeToSearchEnclosingFrom = element;
        }
        return HighlightClassUtil.checkCreateInnerClassFromStaticContext(element, placeToSearchEnclosingFrom, aClass);
    }

    @Nullable
    static HighlightInfo checkCreateInnerClassFromStaticContext(PsiElement element, PsiElement placeToSearchEnclosingFrom, PsiClass aClass) {
        if (aClass == null || !PsiUtil.isInnerClass(aClass)) {
            return null;
        }
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null) {
            return null;
        }
        if (outerClass instanceof PsiSyntheticClass || InheritanceUtil.hasEnclosingInstanceInScope(outerClass, placeToSearchEnclosingFrom, true, false)) {
            return null;
        }
        return HighlightClassUtil.reportIllegalEnclosingUsage(placeToSearchEnclosingFrom, aClass, outerClass, element);
    }

    @Nullable
    static HighlightInfo checkSuperQualifierType(@NotNull Project project, @NotNull PsiMethodCallExpression superCall) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkSuperQualifierType"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightClassUtil", "checkSuperQualifierType"));
        }
        if (!RefactoringChangeUtil.isSuperMethodCall(superCall)) {
            return null;
        }
        PsiMethod ctr = PsiTreeUtil.getParentOfType((PsiElement)superCall, PsiMethod.class, true, PsiMember.class);
        if (ctr == null) {
            return null;
        }
        PsiClass aClass = ctr.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiClass targetClass = aClass.getSuperClass();
        if (targetClass == null) {
            return null;
        }
        PsiExpression qualifier = superCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            if (PsiUtil.isInnerClass(targetClass)) {
                PsiClass outerClass = targetClass.getContainingClass();
                if (outerClass != null) {
                    PsiClassType outerType = JavaPsiFacade.getInstance(project).getElementFactory().createType(outerClass);
                    return HighlightUtil.checkAssignability(outerType, null, qualifier, qualifier);
                }
            } else {
                String description = "'" + HighlightUtil.formatClass(targetClass) + "' is not an inner class";
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo reportIllegalEnclosingUsage(PsiElement place, @Nullable PsiClass aClass, PsiClass outerClass, PsiElement elementToHighlight) {
        if (outerClass != null && !PsiTreeUtil.isContextAncestor(outerClass, place, false)) {
            String description = JavaErrorMessages.message("is.not.an.enclosing.class", HighlightUtil.formatClass(outerClass));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
        }
        PsiModifierListOwner staticParent = PsiUtil.getEnclosingStaticElement(place, outerClass);
        if (staticParent != null) {
            String element = outerClass == null ? "" : HighlightUtil.formatClass(outerClass) + "." + (place instanceof PsiSuperExpression ? "super" : "this");
            String description = JavaErrorMessages.message("cannot.be.referenced.from.static.context", element);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
            if (aClass != null && HighlightUtil.getIncompatibleModifier("static", aClass.getModifierList()) == null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(aClass, "static", true, false));
            }
            return highlightInfo;
        }
        return null;
    }
}

