/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHelper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.find.findUsages.JavaFindUsagesHelper");

    @NotNull
    public static Set<String> getElementNames(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getElementNames"));
        }
        if (element instanceof PsiDirectory) {
            PsiPackage aPackage = ApplicationManager.getApplication().runReadAction(new Computable<PsiPackage>(){

                @Override
                public PsiPackage compute() {
                    return JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
                }
            });
            Set<Object> set = aPackage == null ? Collections.emptySet() : JavaFindUsagesHelper.getElementNames(aPackage);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getElementNames"));
            }
            return set;
        }
        final HashSet<String> result = new HashSet<String>();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (element instanceof PsiPackage) {
                    ContainerUtil.addIfNotNull(result, ((PsiPackage)element).getQualifiedName());
                } else if (element instanceof PsiClass) {
                    String qname = ((PsiClass)element).getQualifiedName();
                    if (qname != null) {
                        result.add(qname);
                        PsiClass topLevelClass = PsiUtil.getTopLevelClass(element);
                        if (topLevelClass != null) {
                            String topName = topLevelClass.getQualifiedName();
                            assert (topName != null);
                            if (qname.length() > topName.length()) {
                                result.add(topName + qname.substring(topName.length()).replace('.', '$'));
                            }
                        }
                    }
                } else if (element instanceof PsiMethod) {
                    ContainerUtil.addIfNotNull(result, ((PsiMethod)element).getName());
                } else if (element instanceof PsiVariable) {
                    ContainerUtil.addIfNotNull(result, ((PsiVariable)element).getName());
                } else if (element instanceof PsiMetaOwner) {
                    PsiMetaData metaData = ((PsiMetaOwner)((Object)element)).getMetaData();
                    if (metaData != null) {
                        ContainerUtil.addIfNotNull(result, metaData.getName());
                    }
                } else if (element instanceof PsiNamedElement) {
                    ContainerUtil.addIfNotNull(result, ((PsiNamedElement)element).getName());
                } else if (element instanceof XmlAttributeValue) {
                    ContainerUtil.addIfNotNull(result, ((XmlAttributeValue)element).getValue());
                } else {
                    LOG.error("Unknown element type: " + element);
                }
            }
        });
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getElementNames"));
        }
        return hashSet;
    }

    public static boolean processElementUsages(final @NotNull PsiElement element, final @NotNull FindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        Collection<String> stringsToSearch;
        boolean success;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processElementUsages"));
        }
        if (options instanceof JavaVariableFindUsagesOptions) {
            final JavaVariableFindUsagesOptions varOptions = (JavaVariableFindUsagesOptions)options;
            if ((varOptions.isReadAccess || varOptions.isWriteAccess) && (varOptions.isReadAccess && varOptions.isWriteAccess ? !JavaFindUsagesHelper.addElementUsages(element, options, processor) : !JavaFindUsagesHelper.addElementUsages(element, varOptions, new Processor<UsageInfo>(){

                @Override
                public boolean process(UsageInfo info) {
                    boolean isWrite;
                    PsiElement element = info.getElement();
                    boolean bl = isWrite = element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)element);
                    return isWrite != varOptions.isWriteAccess || processor.process(info);
                }
            }))) {
                return false;
            }
        } else if (options.isUsages && !JavaFindUsagesHelper.addElementUsages(element, options, processor)) {
            return false;
        }
        if (!(success = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                if (ThrowSearchUtil.isSearchable(element) && options instanceof JavaThrowFindUsagesOptions && options.isUsages) {
                    ThrowSearchUtil.Root[] roots;
                    ThrowSearchUtil.Root root = ((JavaThrowFindUsagesOptions)options).getRoot();
                    if (root == null && (roots = ThrowSearchUtil.getSearchRoots(element)) != null && roots.length > 0) {
                        root = roots[0];
                    }
                    if (root != null) {
                        return ThrowSearchUtil.addThrowUsages(processor, root, options);
                    }
                }
                return true;
            }
        }).booleanValue())) {
            return false;
        }
        if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isClassesUsages && !JavaFindUsagesHelper.addClassesUsages((PsiPackage)element, (JavaPackageFindUsagesOptions)options, processor)) {
            return false;
        }
        if (options instanceof JavaClassFindUsagesOptions) {
            JavaClassFindUsagesOptions classOptions = (JavaClassFindUsagesOptions)options;
            final PsiClass psiClass = (PsiClass)element;
            PsiManager manager = ApplicationManager.getApplication().runReadAction(new Computable<PsiManager>(){

                @Override
                public PsiManager compute() {
                    return psiClass.getManager();
                }
            });
            if (classOptions.isMethodsUsages && !JavaFindUsagesHelper.addMethodsUsages(psiClass, manager, classOptions, processor)) {
                return false;
            }
            if (classOptions.isFieldsUsages && !JavaFindUsagesHelper.addFieldsUsages(psiClass, manager, classOptions, processor)) {
                return false;
            }
            if (psiClass.isInterface()) {
                if (classOptions.isDerivedInterfaces ? (classOptions.isImplementingClasses ? !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor) : !JavaFindUsagesHelper.addDerivedInterfaces(psiClass, classOptions, processor)) : classOptions.isImplementingClasses && !JavaFindUsagesHelper.addImplementingClasses(psiClass, classOptions, processor)) {
                    return false;
                }
                if (classOptions.isImplementingClasses) {
                    FunctionalExpressionSearch.search(psiClass, classOptions.searchScope).forEach(new PsiElementProcessorAdapter<PsiFunctionalExpression>(new PsiElementProcessor<PsiFunctionalExpression>(){

                        @Override
                        public boolean execute(@NotNull PsiFunctionalExpression expression) {
                            if (expression == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/find/findUsages/JavaFindUsagesHelper$6", "execute"));
                            }
                            return JavaFindUsagesHelper.addResult(expression, options, (Processor<UsageInfo>)processor);
                        }
                    }));
                }
            } else if (classOptions.isDerivedClasses && !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor)) {
                return false;
            }
        }
        if (options instanceof JavaMethodFindUsagesOptions) {
            final PsiMethod psiMethod = (PsiMethod)element;
            boolean isAbstract = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                @Override
                public Boolean compute() {
                    return psiMethod.hasModifierProperty("abstract");
                }
            });
            JavaMethodFindUsagesOptions methodOptions = (JavaMethodFindUsagesOptions)options;
            if (isAbstract && methodOptions.isImplementingMethods || methodOptions.isOverridingMethods) {
                if (!JavaFindUsagesHelper.processOverridingMethods(psiMethod, processor, methodOptions)) {
                    return false;
                }
                FunctionalExpressionSearch.search(psiMethod, methodOptions.searchScope).forEach(new PsiElementProcessorAdapter<PsiFunctionalExpression>(new PsiElementProcessor<PsiFunctionalExpression>(){

                    @Override
                    public boolean execute(@NotNull PsiFunctionalExpression expression) {
                        if (expression == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/find/findUsages/JavaFindUsagesHelper$8", "execute"));
                        }
                        return JavaFindUsagesHelper.addResult(expression, options, (Processor<UsageInfo>)processor);
                    }
                }));
            }
        }
        if (element instanceof PomTarget && !JavaFindUsagesHelper.addAliasingUsages((PomTarget)((Object)element), options, processor)) {
            return false;
        }
        Boolean isSearchable = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return ThrowSearchUtil.isSearchable(element);
            }
        });
        return isSearchable != false || !options.isSearchForTextOccurrences || !(options.searchScope instanceof GlobalSearchScope) || FindUsagesHelper.processUsagesInText(element, stringsToSearch = ApplicationManager.getApplication().runReadAction(new NullableComputable<Collection<String>>(){

            @Override
            public Collection<String> compute() {
                return JavaFindUsagesHelper.getElementNames(element);
            }
        }), (GlobalSearchScope)options.searchScope, processor);
    }

    private static boolean addAliasingUsages(@NotNull PomTarget pomTarget, final @NotNull FindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (pomTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pomTarget", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addAliasingUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addAliasingUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addAliasingUsages"));
        }
        for (AliasingPsiTargetMapper aliasingPsiTargetMapper : Extensions.getExtensions(AliasingPsiTargetMapper.EP_NAME)) {
            for (final AliasingPsiTarget psiTarget : aliasingPsiTargetMapper.getTargets(pomTarget)) {
                boolean success = ReferencesSearch.search(new ReferencesSearch.SearchParameters(ApplicationManager.getApplication().runReadAction(new Computable<PsiElement>(){

                    @Override
                    public PsiElement compute() {
                        return PomService.convertToPsi(psiTarget);
                    }
                }), options.searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResult(reference, options, (Processor<UsageInfo>)processor);
                    }
                });
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOverridingMethods(@NotNull PsiMethod psiMethod, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaMethodFindUsagesOptions options) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processOverridingMethods"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processOverridingMethods"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processOverridingMethods"));
        }
        return OverridingMethodsSearch.search(psiMethod, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiMethod>(new PsiElementProcessor<PsiMethod>(){

            @Override
            public boolean execute(@NotNull PsiMethod element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper$13", "execute"));
                }
                return JavaFindUsagesHelper.addResult(element.getNavigationElement(), options, (Processor<UsageInfo>)processor);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addClassesUsages(@NotNull PsiPackage aPackage, final @NotNull JavaPackageFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesUsages"));
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.pushState();
        }
        try {
            ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
            JavaFindUsagesHelper.addClassesInPackage(aPackage, options.isIncludeSubpackages, classes);
            for (final PsiClass aClass : classes) {
                boolean success;
                if (progress != null) {
                    String name = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                        @Override
                        public String compute() {
                            return aClass.getName();
                        }
                    });
                    progress.setText(FindBundle.message("find.searching.for.references.to.class.progress", name));
                    progress.checkCanceled();
                }
                if (success = ReferencesSearch.search(new ReferencesSearch.SearchParameters(aClass, options.searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference psiReference) {
                        return JavaFindUsagesHelper.addResult(psiReference, options, (Processor<UsageInfo>)processor);
                    }
                })) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
        return true;
    }

    private static void addClassesInPackage(final @NotNull PsiPackage aPackage, boolean includeSubpackages, @NotNull List<PsiClass> array) {
        PsiDirectory[] dirs;
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInPackage"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInPackage"));
        }
        for (PsiDirectory dir : dirs = ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory[]>(){

            @Override
            public PsiDirectory[] compute() {
                return aPackage.getDirectories();
            }
        })) {
            JavaFindUsagesHelper.addClassesInDirectory(dir, includeSubpackages, array);
        }
    }

    private static void addClassesInDirectory(final @NotNull PsiDirectory dir, final boolean includeSubdirs, final @NotNull List<PsiClass> array) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInDirectory"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInDirectory"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir);
                ContainerUtil.addAll(array, classes);
                if (includeSubdirs) {
                    PsiDirectory[] dirs;
                    for (PsiDirectory directory : dirs = dir.getSubdirectories()) {
                        JavaFindUsagesHelper.addClassesInDirectory(directory, true, array);
                    }
                }
            }
        });
    }

    private static boolean addMethodsUsages(final @NotNull PsiClass aClass, final @NotNull PsiManager manager, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (options.isIncludeInherited) {
            final PsiMethod[] methods = ApplicationManager.getApplication().runReadAction(new Computable<PsiMethod[]>(){

                @Override
                public PsiMethod[] compute() {
                    return aClass.getAllMethods();
                }
            });
            for (int i = 0; i < methods.length; ++i) {
                MethodReferencesSearch.SearchParameters parameters;
                boolean success;
                boolean equivalent;
                final PsiMethod method = methods[i];
                final int finalI = i;
                final PsiClass methodClass = ApplicationManager.getApplication().runReadAction(new Computable<PsiClass>(){

                    @Override
                    public PsiClass compute() {
                        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
                        for (int j = 0; j < finalI; ++j) {
                            if (!methodSignature.equals(methods[j].getSignature(PsiSubstitutor.EMPTY))) continue;
                            return null;
                        }
                        return method.getContainingClass();
                    }
                });
                if (methodClass == null || !((equivalent = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                    @Override
                    public Boolean compute() {
                        return manager.areElementsEquivalent(methodClass, aClass);
                    }
                }).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages(method, options, processor) : !(success = MethodReferencesSearch.search(parameters = new MethodReferencesSearch.SearchParameters(method, options.searchScope, true, options.fastTrack)).forEach(new PsiReferenceProcessorAdapter(new PsiReferenceProcessor(){

                    @Override
                    public boolean execute(PsiReference reference) {
                        JavaFindUsagesHelper.addResultFromReference(reference, methodClass, manager, aClass, options, processor);
                        return true;
                    }
                }))))) continue;
                return false;
            }
        } else {
            PsiMethod[] methods;
            for (PsiMethod method : methods = ApplicationManager.getApplication().runReadAction(new Computable<PsiMethod[]>(){

                @Override
                public PsiMethod[] compute() {
                    return aClass.getMethods();
                }
            })) {
                if (JavaFindUsagesHelper.addElementUsages(method, options, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addFieldsUsages(final @NotNull PsiClass aClass, final @NotNull PsiManager manager, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (options.isIncludeInherited) {
            final PsiField[] fields = ApplicationManager.getApplication().runReadAction(new Computable<PsiField[]>(){

                @Override
                public PsiField[] compute() {
                    return aClass.getAllFields();
                }
            });
            for (int i = 0; i < fields.length; ++i) {
                boolean success;
                boolean equivalent;
                final PsiField field = fields[i];
                final int finalI = i;
                final PsiClass fieldClass = ApplicationManager.getApplication().runReadAction(new Computable<PsiClass>(){

                    @Override
                    public PsiClass compute() {
                        for (int j = 0; j < finalI; ++j) {
                            if (!Comparing.strEqual(field.getName(), fields[j].getName())) continue;
                            return null;
                        }
                        return field.getContainingClass();
                    }
                });
                if (fieldClass == null || !((equivalent = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                    @Override
                    public Boolean compute() {
                        return manager.areElementsEquivalent(fieldClass, aClass);
                    }
                }).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages(fields[i], options, processor) : !(success = ReferencesSearch.search(new ReferencesSearch.SearchParameters(field, options.searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResultFromReference(reference, fieldClass, manager, aClass, options, processor);
                    }
                })))) continue;
                return false;
            }
        } else {
            PsiField[] fields;
            for (PsiField field : fields = ApplicationManager.getApplication().runReadAction(new Computable<PsiField[]>(){

                @Override
                public PsiField[] compute() {
                    return aClass.getFields();
                }
            })) {
                if (JavaFindUsagesHelper.addElementUsages(field, options, processor)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiClass getFieldOrMethodAccessedClass(@NotNull PsiReferenceExpression ref, @NotNull PsiClass fieldOrMethodClass) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getFieldOrMethodAccessedClass"));
        }
        if (fieldOrMethodClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldOrMethodClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getFieldOrMethodAccessedClass"));
        }
        PsiElement[] children = ref.getChildren();
        if (children.length > 1 && children[0] instanceof PsiExpression) {
            PsiElement refElement;
            PsiExpression expr = (PsiExpression)children[0];
            PsiType type = expr.getType();
            if (type != null) {
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return PsiUtil.resolveClassInType(type);
            }
            if (expr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)expr).resolve()) instanceof PsiClass) {
                return (PsiClass)refElement;
            }
            return null;
        }
        PsiManager manager = ref.getManager();
        for (PsiElement parent = ref; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass) || !manager.areElementsEquivalent(parent, fieldOrMethodClass) && !((PsiClass)parent).isInheritor(fieldOrMethodClass, true)) continue;
            return (PsiClass)parent;
        }
        return null;
    }

    private static boolean addInheritors(@NotNull PsiClass aClass, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addInheritors"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addInheritors"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addInheritors"));
        }
        return ClassInheritorsSearch.search(aClass, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiClass>(new PsiElementProcessor<PsiClass>(){

            @Override
            public boolean execute(@NotNull PsiClass element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper$28", "execute"));
                }
                return JavaFindUsagesHelper.addResult(element, options, (Processor<UsageInfo>)processor);
            }
        }));
    }

    private static boolean addDerivedInterfaces(@NotNull PsiClass anInterface, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addDerivedInterfaces"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addDerivedInterfaces"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addDerivedInterfaces"));
        }
        return ClassInheritorsSearch.search(anInterface, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiClass>(new PsiElementProcessor<PsiClass>(){

            @Override
            public boolean execute(@NotNull PsiClass inheritor) {
                if (inheritor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/find/findUsages/JavaFindUsagesHelper$29", "execute"));
                }
                return !inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, options, (Processor<UsageInfo>)processor);
            }
        }));
    }

    private static boolean addImplementingClasses(@NotNull PsiClass anInterface, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addImplementingClasses"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addImplementingClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addImplementingClasses"));
        }
        return ClassInheritorsSearch.search(anInterface, options.searchScope, options.isCheckDeepInheritance).forEach(new PsiElementProcessorAdapter<PsiClass>(new PsiElementProcessor<PsiClass>(){

            @Override
            public boolean execute(@NotNull PsiClass inheritor) {
                if (inheritor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/find/findUsages/JavaFindUsagesHelper$30", "execute"));
                }
                return inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, options, (Processor<UsageInfo>)processor);
            }
        }));
    }

    private static boolean addResultFromReference(@NotNull PsiReference reference, @NotNull PsiClass methodClass, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        PsiClass usedClass;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (methodClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        PsiElement refElement = reference.getElement();
        return !(refElement instanceof PsiReferenceExpression) || (usedClass = JavaFindUsagesHelper.getFieldOrMethodAccessedClass((PsiReferenceExpression)refElement, methodClass)) == null || !manager.areElementsEquivalent(usedClass, aClass) && !usedClass.isInheritor(aClass, true) || JavaFindUsagesHelper.addResult(refElement, options, processor);
    }

    private static boolean addElementUsages(final @NotNull PsiElement element, final @NotNull FindUsagesOptions options, final @NotNull Processor<UsageInfo> processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addElementUsages"));
        }
        SearchScope searchScope = options.searchScope;
        final PsiClass[] parentClass = new PsiClass[1];
        if (element instanceof PsiMethod && ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                PsiMethod method = (PsiMethod)element;
                parentClass[0] = method.getContainingClass();
                return method.isConstructor();
            }
        }).booleanValue()) {
            PsiMethod method = (PsiMethod)element;
            if (parentClass[0] != null) {
                boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
                return MethodReferencesSearch.search(new MethodReferencesSearch.SearchParameters(method, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                    @Override
                    public boolean processInReadAction(PsiReference ref) {
                        return JavaFindUsagesHelper.addResult(ref, options, (Processor<UsageInfo>)processor);
                    }
                });
            }
            return true;
        }
        ReadActionProcessor<PsiReference> consumer = new ReadActionProcessor<PsiReference>(){

            @Override
            public boolean processInReadAction(PsiReference ref) {
                return JavaFindUsagesHelper.addResult(ref, options, (Processor<UsageInfo>)processor);
            }
        };
        if (element instanceof PsiMethod) {
            boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
            return MethodReferencesSearch.search(new MethodReferencesSearch.SearchParameters((PsiMethod)element, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor<PsiReference>)consumer);
        }
        return ReferencesSearch.search(new ReferencesSearch.SearchParameters(element, searchScope, false, options.fastTrack)).forEach((Processor<PsiReference>)consumer);
    }

    private static boolean addResult(@NotNull PsiElement element, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        return !JavaFindUsagesHelper.filterUsage(element, options) || processor.process(new UsageInfo(element));
    }

    private static boolean addResult(@NotNull PsiReference ref, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (JavaFindUsagesHelper.filterUsage(ref.getElement(), options)) {
            TextRange rangeInElement = ref.getRangeInElement();
            return processor.process(new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
        }
        return true;
    }

    private static boolean filterUsage(PsiElement usage, @NotNull FindUsagesOptions options) {
        PsiElement parent;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "filterUsage"));
        }
        if (!(usage instanceof PsiJavaCodeReferenceElement)) {
            return true;
        }
        if (options instanceof JavaPackageFindUsagesOptions && !((JavaPackageFindUsagesOptions)options).isIncludeSubpackages && ((PsiReference)((Object)usage)).resolve() instanceof PsiPackage && (parent = usage.getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)parent).resolve() instanceof PsiPackage) {
            return false;
        }
        if (!(usage instanceof PsiReferenceExpression)) {
            if (options instanceof JavaFindUsagesOptions && ((JavaFindUsagesOptions)options).isSkipImportStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiImportStatement) {
                    return false;
                }
            }
            if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isSkipPackageStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiPackageStatement) {
                    return false;
                }
            }
        }
        return true;
    }
}

