/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.LocalTimeCounter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightVirtualFileBase
extends VirtualFile {
    private FileType myFileType;
    private String myName = "";
    private long myModStamp = LocalTimeCounter.currentTime();
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFileBase(String name, FileType fileType, long modificationStamp) {
        this.myName = name;
        this.myFileType = fileType;
        this.myModStamp = modificationStamp;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFileBase", "getFileSystem"));
        }
        return myVirtualFileSystem;
    }

    @Nullable
    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = "/" + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFileBase", "getPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFileBase", "getName"));
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    protected void setModificationStamp(long stamp) {
        this.myModStamp = stamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/LightVirtualFileBase", "rename"));
        }
        this.myName = newName;
    }

    private static class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        @NonNls
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        @NotNull
        public String getProtocol() {
            if (PROTOCOL == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem", "getProtocol"));
            }
            return PROTOCOL;
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem", "findFileByPath"));
            }
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem", "refreshAndFindFileByPath"));
            }
            return null;
        }
    }
}

