/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptorBase
extends CommonProblemDescriptorImpl
implements ProblemDescriptor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.ex.ProblemDescriptorImpl");
    @NotNull
    private final SmartPsiElementPointer myStartSmartPointer;
    @Nullable
    private final SmartPsiElementPointer myEndSmartPointer;
    private final ProblemHighlightType myHighlightType;
    private Navigatable myNavigatable;
    private final boolean myAfterEndOfLine;
    private final TextRange myTextRangeInElement;
    private final boolean myShowTooltip;
    private TextAttributesKey myEnforcedTextAttributes;
    private int myLineNumber;
    private ProblemGroup myProblemGroup;

    public ProblemDescriptorBase(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, @NotNull ProblemHighlightType highlightType, boolean isAfterEndOfLine, @Nullable TextRange rangeInElement, boolean tooltip, boolean onTheFly) {
        TextRange startElementRange;
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/ProblemDescriptorBase", "<init>"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/ProblemDescriptorBase", "<init>"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/intellij/codeInspection/ProblemDescriptorBase", "<init>"));
        }
        if (highlightType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightType", "com/intellij/codeInspection/ProblemDescriptorBase", "<init>"));
        }
        super(fixes, descriptionTemplate);
        this.myLineNumber = -1;
        this.myShowTooltip = tooltip;
        PsiFile startContainingFile = startElement.getContainingFile();
        LOG.assertTrue(startContainingFile != null && startContainingFile.isValid() || startElement.isValid(), startElement);
        PsiFile endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        LOG.assertTrue(startElement == endElement || endContainingFile != null && endContainingFile.isValid() || endElement.isValid(), endElement);
        this.assertPhysical(startElement);
        if (startElement != endElement) {
            this.assertPhysical(endElement);
        }
        LOG.assertTrue((startElementRange = startElement.getTextRange()) != null, startElement);
        TextRange endElementRange = endElement.getTextRange();
        LOG.assertTrue(endElementRange != null, endElement);
        if (!(startElementRange.getStartOffset() < endElementRange.getEndOffset() || startElement instanceof PsiFile && endElement instanceof PsiFile)) {
            LOG.error("Empty PSI elements should not be passed to createDescriptor. Start: " + startElement + ", end: " + endElement);
        }
        this.myHighlightType = highlightType;
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        SmartPointerManager manager = SmartPointerManager.getInstance(project);
        this.myStartSmartPointer = manager.createSmartPsiElementPointer(startElement, startContainingFile);
        this.myEndSmartPointer = startElement == endElement ? null : manager.createSmartPsiElementPointer(endElement, endContainingFile);
        this.myAfterEndOfLine = isAfterEndOfLine;
        this.myTextRangeInElement = rangeInElement;
    }

    protected void assertPhysical(PsiElement element) {
        if (!element.isPhysical()) {
            LOG.error("Non-physical PsiElement. Physical element is required to be able to anchor the problem in the source tree: " + element + "; file: " + element.getContainingFile());
        }
    }

    @Override
    public PsiElement getPsiElement() {
        PsiElement startElement = this.getStartElement();
        if (this.myEndSmartPointer == null) {
            return startElement;
        }
        PsiElement endElement = this.getEndElement();
        if (startElement == endElement) {
            return startElement;
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent(startElement, endElement);
    }

    @Override
    @Nullable
    public TextRange getTextRangeInElement() {
        return this.myTextRangeInElement;
    }

    @Override
    public PsiElement getStartElement() {
        return this.myStartSmartPointer.getElement();
    }

    @Override
    public PsiElement getEndElement() {
        return this.myEndSmartPointer == null ? this.getStartElement() : this.myEndSmartPointer.getElement();
    }

    @Override
    public int getLineNumber() {
        if (this.myLineNumber == -1) {
            int textLength;
            PsiElement psiElement = this.getPsiElement();
            if (psiElement == null) {
                return -1;
            }
            if (!psiElement.isValid()) {
                return -1;
            }
            LOG.assertTrue(psiElement.isPhysical());
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance(psiElement.getProject());
            PsiFile containingFile = manager.getTopLevelFile(psiElement);
            Document document = PsiDocumentManager.getInstance(psiElement.getProject()).getDocument(containingFile);
            if (document == null) {
                return -1;
            }
            TextRange textRange = this.getTextRange();
            if (textRange == null) {
                return -1;
            }
            int startOffset = (textRange = manager.injectedToHost(psiElement, textRange)).getStartOffset();
            LOG.assertTrue(startOffset <= (textLength = document.getTextLength()), this.getDescriptionTemplate() + " at " + startOffset + ", " + textLength);
            this.myLineNumber = document.getLineNumber(startOffset) + 1;
        }
        return this.myLineNumber;
    }

    @Override
    @NotNull
    public ProblemHighlightType getHighlightType() {
        ProblemHighlightType problemHighlightType = this.myHighlightType;
        if (problemHighlightType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ProblemDescriptorBase", "getHighlightType"));
        }
        return problemHighlightType;
    }

    @Override
    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    @Override
    public void setTextAttributes(TextAttributesKey key) {
        this.myEnforcedTextAttributes = key;
    }

    public TextAttributesKey getEnforcedTextAttributes() {
        return this.myEnforcedTextAttributes;
    }

    public TextRange getTextRangeForNavigation() {
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            return null;
        }
        PsiElement element = this.getPsiElement();
        return InjectedLanguageManager.getInstance(element.getProject()).injectedToHost(element, textRange);
    }

    public TextRange getTextRange() {
        PsiElement endElement;
        PsiElement startElement = this.getStartElement();
        PsiElement psiElement = endElement = this.myEndSmartPointer == null ? startElement : this.getEndElement();
        if (startElement == null || endElement == null) {
            return null;
        }
        TextRange textRange = startElement.getTextRange();
        if (startElement == endElement) {
            if (this.isAfterEndOfLine()) {
                return new TextRange(textRange.getEndOffset(), textRange.getEndOffset());
            }
            if (this.myTextRangeInElement != null) {
                return new TextRange(textRange.getStartOffset() + this.myTextRangeInElement.getStartOffset(), textRange.getStartOffset() + this.myTextRangeInElement.getEndOffset());
            }
            return textRange;
        }
        return new TextRange(textRange.getStartOffset(), endElement.getTextRange().getEndOffset());
    }

    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    public void setNavigatable(Navigatable navigatable) {
        this.myNavigatable = navigatable;
    }

    @Override
    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @Override
    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    @Override
    public boolean showTooltip() {
        return this.myShowTooltip;
    }

    @Override
    public String toString() {
        PsiElement element = this.getPsiElement();
        return ProblemDescriptorUtil.renderDescriptionMessage(this, element);
    }
}

