/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TrivialMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/TrivialMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiElement resolve;
                PsiMethod interfaceMethod;
                PsiExpression qualifierExpression = expression.getQualifierExpression();
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                if (qualifierExpression != null && referenceNameElement != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(expression)) != null && (resolve = expression.resolve()) instanceof PsiMethod && (interfaceMethod == resolve || MethodSignatureUtil.isSuperMethod(interfaceMethod, (PsiMethod)resolve))) {
                    holder.registerProblem(referenceNameElement, "Method reference can be replaced with qualifier", new ReplaceMethodRefWithQualifierFix());
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ReplaceMethodRefWithQualifierFix
    implements LocalQuickFix {
        private ReplaceMethodRefWithQualifierFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with qualifier" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "getFamilyName"));
            }
            return "Replace with qualifier";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression qualifierExpression;
            PsiElement parent;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element != null ? element.getParent() : null;
            if (parent instanceof PsiMethodReferenceExpression && (qualifierExpression = ((PsiMethodReferenceExpression)parent).getQualifierExpression()) != null) {
                parent.replace(qualifierExpression);
            }
        }
    }
}

