/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.core.CoreASTFactory;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.CoreVirtualFilePointerManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiReferenceServiceImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public class CoreApplicationEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    protected final MockApplication myApplication;
    private final CoreLocalFileSystem myLocalFileSystem;
    protected final VirtualFileSystem myJarFileSystem;
    @NotNull
    private final Disposable myParentDisposable;

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/core/CoreApplicationEnvironment", "<init>"));
        }
        this.myParentDisposable = parentDisposable;
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myApplication = this.createApplication(this.myParentDisposable);
        ApplicationManager.setApplication(this.myApplication, new StaticGetter<FileTypeRegistry>(this.myFileTypeRegistry), this.myParentDisposable);
        this.myLocalFileSystem = this.createLocalFileSystem();
        this.myJarFileSystem = this.createJarFileSystem();
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        MutablePicoContainer appContainer = this.myApplication.getPicoContainer();
        CoreApplicationEnvironment.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(new Function<CharSequence, Document>(){

            @Override
            public Document fun(CharSequence charSequence) {
                return new DocumentImpl(charSequence);
            }
        }, null));
        VirtualFileSystem[] fs = new VirtualFileSystem[]{this.myLocalFileSystem, this.myJarFileSystem};
        VirtualFileManagerImpl virtualFileManager = new VirtualFileManagerImpl(fs, this.myApplication.getMessageBus());
        CoreApplicationEnvironment.registerComponentInstance(appContainer, VirtualFileManager.class, virtualFileManager);
        this.registerApplicationService(EncodingManager.class, new CoreEncodingRegistry());
        this.registerApplicationService(VirtualFilePointerManager.class, this.createVirtualFilePointerManager());
        this.registerApplicationService(DefaultASTFactory.class, new CoreASTFactory());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.registerApplicationService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.registerApplicationService(PsiReferenceService.class, new PsiReferenceServiceImpl());
        this.registerApplicationService(MetaDataRegistrar.class, new MetaRegistry());
        this.registerApplicationService(ProgressManager.class, this.createProgressIndicatorProvider());
        this.registerApplicationService(JobLauncher.class, this.createJobLauncher());
        this.registerApplicationService(CodeFoldingSettings.class, new CodeFoldingSettings());
        this.registerApplicationService(CommandProcessor.class, new CoreCommandProcessor());
        this.myApplication.registerService(ApplicationInfo.class, ApplicationInfoImpl.class);
    }

    public <T> void registerApplicationService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceInterface", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationService"));
        }
        if (serviceImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceImplementation", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationService"));
        }
        this.myApplication.registerService(serviceInterface, serviceImplementation);
    }

    @NotNull
    protected VirtualFilePointerManager createVirtualFilePointerManager() {
        CoreVirtualFilePointerManager coreVirtualFilePointerManager = new CoreVirtualFilePointerManager();
        if (coreVirtualFilePointerManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createVirtualFilePointerManager"));
        }
        return coreVirtualFilePointerManager;
    }

    @NotNull
    protected MockApplication createApplication(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/core/CoreApplicationEnvironment", "createApplication"));
        }
        MockApplicationEx mockApplicationEx = new MockApplicationEx(parentDisposable);
        if (mockApplicationEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createApplication"));
        }
        return mockApplicationEx;
    }

    @NotNull
    protected JobLauncher createJobLauncher() {
        JobLauncher jobLauncher = new JobLauncher(){

            @Override
            public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) {
                if (things == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgress"));
                }
                if (thingProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgress"));
                }
                for (T thing : things) {
                    if (thingProcessor.process(thing)) continue;
                    return false;
                }
                return true;
            }

            @Override
            @NotNull
            public <T> AsyncFuture<Boolean> invokeConcurrentlyUnderProgressAsync(@NotNull List<T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) {
                if (things == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgressAsync"));
                }
                if (thingProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgressAsync"));
                }
                AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.invokeConcurrentlyUnderProgress(things, progress, failFastOnAcquireReadAction, thingProcessor));
                if (asyncFuture == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment$2", "invokeConcurrentlyUnderProgressAsync"));
                }
                return asyncFuture;
            }

            @Override
            @NotNull
            public Job<Void> submitToJobThread(@NotNull Runnable action, Consumer<Future> onDoneCallback) {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/core/CoreApplicationEnvironment$2", "submitToJobThread"));
                }
                action.run();
                if (onDoneCallback != null) {
                    onDoneCallback.consume(new Future(){

                        @Override
                        public boolean cancel(boolean mayInterruptIfRunning) {
                            return false;
                        }

                        @Override
                        public boolean isCancelled() {
                            return false;
                        }

                        @Override
                        public boolean isDone() {
                            return true;
                        }

                        public Object get() {
                            return null;
                        }

                        public Object get(long timeout, @NotNull TimeUnit timeUnit) {
                            if (timeUnit == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/core/CoreApplicationEnvironment$2$1", "get"));
                            }
                            return null;
                        }
                    });
                }
                Job job = Job.NULL_JOB;
                if (job == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment$2", "submitToJobThread"));
                }
                return job;
            }
        };
        if (jobLauncher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createJobLauncher"));
        }
        return jobLauncher;
    }

    @NotNull
    protected ProgressManager createProgressIndicatorProvider() {
        CoreProgressManager coreProgressManager = new CoreProgressManager();
        if (coreProgressManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createProgressIndicatorProvider"));
        }
        return coreProgressManager;
    }

    @NotNull
    protected VirtualFileSystem createJarFileSystem() {
        CoreJarFileSystem coreJarFileSystem = new CoreJarFileSystem();
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createJarFileSystem"));
        }
        return coreJarFileSystem;
    }

    @NotNull
    protected CoreLocalFileSystem createLocalFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = new CoreLocalFileSystem();
        if (coreLocalFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "createLocalFileSystem"));
        }
        return coreLocalFileSystem;
    }

    @NotNull
    public MockApplication getApplication() {
        MockApplication mockApplication = this.myApplication;
        if (mockApplication == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "getApplication"));
        }
        return mockApplication;
    }

    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.myParentDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "getParentDisposable"));
        }
        return disposable;
    }

    public <T> void registerApplicationComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationComponent"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationComponent"));
        }
        CoreApplicationEnvironment.registerComponentInstance(this.myApplication.getPicoContainer(), interfaceClass, implementation);
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull String extension) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/core/CoreApplicationEnvironment", "registerFileType"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/core/CoreApplicationEnvironment", "registerFileType"));
        }
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(@NotNull ParserDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/core/CoreApplicationEnvironment", "registerParserDefinition"));
        }
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), definition);
    }

    public static <T> void registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/core/CoreApplicationEnvironment", "registerComponentInstance"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/core/CoreApplicationEnvironment", "registerComponentInstance"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "com/intellij/core/CoreApplicationEnvironment", "registerComponentInstance"));
        }
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    public <T> void addExplicitExtension(@NotNull LanguageExtension<T> instance, @NotNull Language language, @NotNull T object) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        this.doAddExplicitExtension(instance, language, object);
    }

    public void registerParserDefinition(@NotNull Language language, @NotNull ParserDefinition parserDefinition) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/core/CoreApplicationEnvironment", "registerParserDefinition"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/core/CoreApplicationEnvironment", "registerParserDefinition"));
        }
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, language, parserDefinition);
    }

    public <T> void addExplicitExtension(@NotNull FileTypeExtension<T> instance, @NotNull FileType fileType, @NotNull T object) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        this.doAddExplicitExtension(instance, fileType, object);
    }

    private <T, U> void doAddExplicitExtension(final @NotNull KeyedExtensionCollector<T, U> instance, final @NotNull U key, final @NotNull T object) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/core/CoreApplicationEnvironment", "doAddExplicitExtension"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/core/CoreApplicationEnvironment", "doAddExplicitExtension"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/core/CoreApplicationEnvironment", "doAddExplicitExtension"));
        }
        instance.addExplicitExtension(key, object);
        Disposer.register(this.myParentDisposable, new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(key, object);
            }
        });
    }

    public <T> void addExplicitExtension(@NotNull ClassExtension<T> instance, @NotNull Class aClass, @NotNull T object) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/core/CoreApplicationEnvironment", "addExplicitExtension"));
        }
        this.doAddExplicitExtension(instance, aClass, object);
    }

    public <T> void addExtension(@NotNull ExtensionPointName<T> name, final @NotNull T extension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreApplicationEnvironment", "addExtension"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/core/CoreApplicationEnvironment", "addExtension"));
        }
        final ExtensionPoint<T> extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register(this.myParentDisposable, new Disposable(){

            @Override
            public void dispose() {
                if (extensionPoint.hasExtension(extension)) {
                    extensionPoint.unregisterExtension(extension);
                }
            }
        });
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPoint"));
        }
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPoint"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPoint"));
        }
        String name = extensionPointName.getName();
        CoreApplicationEnvironment.registerExtensionPoint(area, name, aClass);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull String name, @NotNull Class<? extends T> aClass) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPoint"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPoint"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPoint"));
        }
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    public static <T> void registerApplicationExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationExtensionPoint"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/core/CoreApplicationEnvironment", "registerApplicationExtensionPoint"));
        }
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        if (pluginRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginRoot", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPointAndExtensions"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPointAndExtensions"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/core/CoreApplicationEnvironment", "registerExtensionPointAndExtensions"));
        }
        PluginManagerCore.registerExtensionPointAndExtensions(pluginRoot, fileName, area);
    }

    @NotNull
    public CoreLocalFileSystem getLocalFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myLocalFileSystem;
        if (coreLocalFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "getLocalFileSystem"));
        }
        return coreLocalFileSystem;
    }

    @NotNull
    public VirtualFileSystem getJarFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myJarFileSystem;
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreApplicationEnvironment", "getJarFileSystem"));
        }
        return virtualFileSystem;
    }
}

