/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspectionBase
extends LocalInspectionTool {
    public boolean myFilterOutGeneratedCode;
    private static final int MIN_FRAGMENT_SIZE = 3;

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        boolean usingLightProfile;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/dupLocator/index/DuplicatesInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/dupLocator/index/DuplicatesInspectionBase", "checkFile"));
        }
        final VirtualFile virtualFile = psiFile.getVirtualFile();
        if (!(virtualFile instanceof VirtualFileWithId) || !DuplicatesIndex.ourEnabled) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        final DuplicatesProfile profile = DuplicatesIndex.findDuplicatesProfile(psiFile.getFileType());
        if (profile == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        final Ref myProcessorRef = new Ref();
        FileASTNode node = psiFile.getNode();
        boolean bl = usingLightProfile = profile instanceof LightDuplicateProfile && node.getElementType() instanceof ILightStubFileElementType;
        if (usingLightProfile) {
            LighterAST ast = node.getLighterAST();
            assert (ast != null);
            ((LightDuplicateProfile)((Object)profile)).process(ast, new LightDuplicateProfile.Callback(){
                DuplicatedCodeProcessor<LighterASTNode> myProcessor;

                @Override
                public void process(int hash, int hash2, final @NotNull LighterAST ast, LighterASTNode ... nodes) {
                    if (ast == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/index/DuplicatesInspectionBase$1", "process"));
                    }
                    if (nodes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dupLocator/index/DuplicatesInspectionBase$1", "process"));
                    }
                    if (this.myProcessor == null) {
                        class LightDuplicatedCodeProcessor
                        extends DuplicatedCodeProcessor<LighterASTNode> {
                            LightDuplicatedCodeProcessor(VirtualFile file, Project project) {
                                super(file, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
                            }

                            @Override
                            protected TextRange getRangeInElement(LighterASTNode node) {
                                return null;
                            }

                            @Override
                            protected PsiElement getPsi(LighterASTNode node) {
                                return ((TreeBackedLighterAST)ast).unwrap(node).getPsi();
                            }

                            @Override
                            protected int getStartOffset(LighterASTNode node) {
                                return node.getStartOffset();
                            }

                            @Override
                            protected int getEndOffset(LighterASTNode node) {
                                return node.getEndOffset();
                            }

                            @Override
                            protected boolean isLightProfile() {
                                return true;
                            }
                        }
                        this.myProcessor = new LightDuplicatedCodeProcessor(virtualFile, psiFile.getProject());
                        myProcessorRef.set(this.myProcessor);
                    }
                    this.myProcessor.process(hash, hash2, nodes[0]);
                }
            });
        } else {
            final DuplocatorState state = profile.getDuplocatorState(psiFile.getLanguage());
            profile.createVisitor(new FragmentsCollector(){
                DuplicatedCodeProcessor<PsiFragment> myProcessor;

                @Override
                public void add(int hash, int cost, @Nullable PsiFragment frag) {
                    if (!DuplicatesIndex.isIndexedFragment(frag, cost, profile, state)) {
                        return;
                    }
                    if (this.myProcessor == null) {
                        class OldDuplicatedCodeProcessor
                        extends DuplicatedCodeProcessor<PsiFragment> {
                            OldDuplicatedCodeProcessor(VirtualFile file, Project project) {
                                super(file, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
                            }

                            @Override
                            protected TextRange getRangeInElement(PsiFragment node) {
                                PsiElement[] elements = node.getElements();
                                TextRange rangeInElement = null;
                                if (elements.length > 1) {
                                    PsiElement lastElement = elements[elements.length - 1];
                                    rangeInElement = new TextRange(elements[0].getStartOffsetInParent(), lastElement.getStartOffsetInParent() + lastElement.getTextLength());
                                }
                                return rangeInElement;
                            }

                            @Override
                            protected PsiElement getPsi(PsiFragment node) {
                                PsiElement[] elements = node.getElements();
                                return elements.length > 1 ? elements[0].getParent() : elements[0];
                            }

                            @Override
                            protected int getStartOffset(PsiFragment node) {
                                return node.getStartOffset();
                            }

                            @Override
                            protected int getEndOffset(PsiFragment node) {
                                return node.getEndOffset();
                            }

                            @Override
                            protected boolean isLightProfile() {
                                return false;
                            }
                        }
                        this.myProcessor = new OldDuplicatedCodeProcessor(virtualFile, psiFile.getProject());
                        myProcessorRef.set(this.myProcessor);
                    }
                    this.myProcessor.process(hash, 0, frag);
                }
            }, true).visitNode(psiFile);
        }
        DuplicatedCodeProcessor processor = (DuplicatedCodeProcessor)myProcessorRef.get();
        SmartList<ProblemDescriptor> descriptors = new SmartList<ProblemDescriptor>();
        if (processor != null) {
            VirtualFile baseDir = psiFile.getProject().getBaseDir();
            for (Map.Entry<Integer, TextRange> entry : processor.reportedRanges.entrySet()) {
                Integer offset = entry.getKey();
                if (!usingLightProfile && processor.fragmentSize.get(offset.intValue()) < 3) continue;
                VirtualFile file = (VirtualFile)processor.reportedFiles.get(offset.intValue());
                String path = null;
                if (file.equals(virtualFile)) {
                    path = "this file";
                } else if (baseDir != null) {
                    path = VfsUtilCore.getRelativePath(file, baseDir);
                }
                if (path == null) {
                    path = file.getPath();
                }
                String message = "Found duplicated code in " + path;
                PsiElement targetElement = (PsiElement)processor.reportedPsi.get(offset.intValue());
                TextRange rangeInElement = entry.getValue();
                int offsetInOtherFile = processor.reportedOffsetInOtherFiles.get(offset.intValue());
                LocalQuickFix fix = this.createNavigateToDupeFix(file, offsetInOtherFile);
                long hash = processor.fragmentHash.get(offset.intValue());
                LocalQuickFix viewAllDupesFix = hash != 0L ? this.createShowOtherDupesFix(virtualFile, offset, (int)hash, (int)(hash >> 32), psiFile.getProject()) : null;
                ProblemDescriptor descriptor = manager.createProblemDescriptor(targetElement, rangeInElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, fix, viewAllDupesFix);
                descriptors.add(descriptor);
            }
        }
        return descriptors.isEmpty() ? null : descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    protected LocalQuickFix createNavigateToDupeFix(@NotNull VirtualFile file, int offsetInOtherFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesInspectionBase", "createNavigateToDupeFix"));
        }
        return null;
    }

    protected LocalQuickFix createShowOtherDupesFix(VirtualFile file, int offset, int hash, int hash2, Project project) {
        return null;
    }

    static abstract class DuplicatedCodeProcessor<T>
    implements FileBasedIndex.ValueProcessor<TIntArrayList> {
        final TreeMap<Integer, TextRange> reportedRanges = new TreeMap();
        final TIntObjectHashMap<VirtualFile> reportedFiles = new TIntObjectHashMap();
        final TIntObjectHashMap<PsiElement> reportedPsi = new TIntObjectHashMap();
        final TIntIntHashMap reportedOffsetInOtherFiles = new TIntIntHashMap();
        final TIntIntHashMap fragmentSize = new TIntIntHashMap();
        final TIntLongHashMap fragmentHash = new TIntLongHashMap();
        final VirtualFile virtualFile;
        final Project project;
        final FileIndex myFileIndex;
        final boolean mySkipGeneratedCode;
        final boolean myFileWithinGeneratedCode;
        T myNode;
        int myHash;
        int myHash2;

        DuplicatedCodeProcessor(VirtualFile file, Project project, boolean skipGeneratedCode) {
            this.virtualFile = file;
            this.project = project;
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
            this.mySkipGeneratedCode = skipGeneratedCode;
            this.myFileWithinGeneratedCode = skipGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, project);
        }

        void process(int hash, int hash2, T node) {
            ProgressManager.checkCanceled();
            this.myNode = node;
            this.myHash = hash;
            this.myHash2 = hash2;
            FileBasedIndex.getInstance().processValues(DuplicatesIndex.NAME, hash, null, this, GlobalSearchScope.projectScope(this.project));
        }

        @Override
        public boolean process(VirtualFile file, TIntArrayList list) {
            int len = list.size();
            for (int i = 0; i < len; i += 2) {
                ProgressManager.checkCanceled();
                if (list.getQuick(i + 1) != this.myHash2) continue;
                int offset = list.getQuick(i);
                if (this.myFileIndex.isInSourceContent(this.virtualFile)) {
                    if (!this.myFileIndex.isInSourceContent(file)) {
                        return true;
                    }
                    if (!this.myFileIndex.isInTestSourceContent(this.virtualFile) && this.myFileIndex.isInTestSourceContent(file)) {
                        return true;
                    }
                    if (this.mySkipGeneratedCode && !this.myFileWithinGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, this.project)) {
                        return true;
                    }
                } else if (this.myFileIndex.isInSourceContent(file)) {
                    return true;
                }
                int startOffset = this.getStartOffset(this.myNode);
                int endOffset = this.getEndOffset(this.myNode);
                if (file.equals(this.virtualFile) && offset >= startOffset && offset < endOffset) continue;
                PsiElement target = this.getPsi(this.myNode);
                TextRange rangeInElement = this.getRangeInElement(this.myNode);
                Integer fragmentStartOffsetInteger = startOffset;
                SortedMap<Integer, TextRange> map = this.reportedRanges.subMap(fragmentStartOffsetInteger, endOffset);
                int newFragmentSize = !map.isEmpty() ? 0 : 1;
                Iterator<Integer> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer next = iterator.next();
                    iterator.remove();
                    this.reportedFiles.remove(next.intValue());
                    this.reportedOffsetInOtherFiles.remove(next.intValue());
                    this.reportedPsi.remove(next.intValue());
                    newFragmentSize += this.fragmentSize.remove(next.intValue());
                }
                this.reportedRanges.put(fragmentStartOffsetInteger, rangeInElement);
                this.reportedFiles.put(fragmentStartOffsetInteger.intValue(), (Object)file);
                this.reportedOffsetInOtherFiles.put(fragmentStartOffsetInteger.intValue(), offset);
                this.reportedPsi.put(fragmentStartOffsetInteger.intValue(), (Object)target);
                this.fragmentSize.put(fragmentStartOffsetInteger.intValue(), newFragmentSize);
                if (newFragmentSize >= 3 || this.isLightProfile()) {
                    this.fragmentHash.put(fragmentStartOffsetInteger.intValue(), (long)this.myHash & 0xFFFFFFFFL | (long)this.myHash2 << 32);
                }
                return false;
            }
            return true;
        }

        protected abstract TextRange getRangeInElement(T var1);

        protected abstract PsiElement getPsi(T var1);

        protected abstract int getStartOffset(T var1);

        protected abstract int getEndOffset(T var1);

        protected abstract boolean isLightProfile();
    }
}

