/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import org.jetbrains.annotations.NotNull;

public class PublicMethodNotExposedInInterfaceInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean onlyWarnIfContainingClassImplementsAnInterface = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.method.not.in.interface.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.method.not.in.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)infos[0], this.ignorableAnnotations);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspectionBase", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodNotExposedInInterfaceVisitor();
    }

    private class PublicMethodNotExposedInInterfaceVisitor
    extends BaseInspectionVisitor {
        private PublicMethodNotExposedInInterfaceVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspectionBase$PublicMethodNotExposedInInterfaceVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!containingClass.hasModifierProperty("public")) {
                return;
            }
            if (AnnotationUtil.isAnnotated(method, PublicMethodNotExposedInInterfaceInspectionBase.this.ignorableAnnotations)) {
                return;
            }
            if (PublicMethodNotExposedInInterfaceInspectionBase.this.onlyWarnIfContainingClassImplementsAnInterface) {
                PsiClass[] superClasses = containingClass.getSupers();
                boolean implementsInterface = false;
                for (PsiClass superClass : superClasses) {
                    if (!superClass.isInterface() || LibraryUtil.classIsInLibrary(superClass)) continue;
                    implementsInterface = true;
                    break;
                }
                if (!implementsInterface) {
                    return;
                }
            }
            if (this.exposedInInterface(method)) {
                return;
            }
            if (TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private boolean exposedInInterface(PsiMethod method) {
            Object[] superMethods = method.findSuperMethods();
            PsiMethod siblingInherited = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method);
            if (siblingInherited != null && !ArrayUtil.contains(siblingInherited, superMethods)) {
                superMethods = ArrayUtil.append(superMethods, siblingInherited);
            }
            for (Object superMethod : superMethods) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null) continue;
                if (superClass.isInterface()) {
                    return true;
                }
                String superclassName = superClass.getQualifiedName();
                if ("java.lang.Object".equals(superclassName)) {
                    return true;
                }
                if (!this.exposedInInterface((PsiMethod)superMethod)) continue;
                return true;
            }
            return false;
        }
    }
}

