/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Divider {
    private static final int STARTING_TREE_HEIGHT = 10;
    private static final PsiElement HAVE_TO_GET_CHILDREN = PsiUtilCore.NULL_PSI_ELEMENT;

    public static void divideInsideAndOutside(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull TextRange range, @NotNull List<PsiElement> inside, @NotNull List<ProperTextRange> insideRanges, @NotNull List<PsiElement> outside, @NotNull List<ProperTextRange> outsideRanges, boolean includeParents, @NotNull Condition<PsiFile> filter) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (inside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inside", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (insideRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideRanges", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (outside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outside", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (outsideRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideRanges", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        FileViewProvider viewProvider = file.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!filter.value(psiRoot)) continue;
            Divider.divideInsideAndOutside(psiRoot, startOffset, endOffset, range, inside, insideRanges, outside, outsideRanges, includeParents);
        }
    }

    private static void divideInsideAndOutside(@NotNull PsiFile root, int startOffset, int endOffset, @NotNull TextRange range, @NotNull List<PsiElement> inside, @NotNull List<ProperTextRange> insideRanges, @NotNull List<PsiElement> outside, @NotNull List<ProperTextRange> outsideRanges, boolean includeParents) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (inside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inside", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (insideRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideRanges", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (outside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outside", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        if (outsideRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideRanges", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutside"));
        }
        int currentOffset = root.getTextRange().getStartOffset();
        Condition<PsiElement>[] filters = Extensions.getExtensions(CollectHighlightsUtil.EP_NAME);
        int offset = currentOffset;
        TIntStack starts = new TIntStack(10);
        starts.push(startOffset);
        Stack<PsiFile> elements = new Stack<PsiFile>(10);
        Stack<PsiElement> children = new Stack<PsiElement>(10);
        PsiElement element = root;
        PsiElement child = HAVE_TO_GET_CHILDREN;
        while (true) {
            boolean startChildrenVisiting;
            ProgressManager.checkCanceled();
            for (Condition<PsiElement> filter : filters) {
                if (filter.value(element)) continue;
                assert (child == HAVE_TO_GET_CHILDREN);
                child = null;
                break;
            }
            if (child == HAVE_TO_GET_CHILDREN) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                int start;
                if (startChildrenVisiting) {
                    offset += element.getTextLength();
                }
                if (startOffset <= (start = starts.pop()) && offset <= endOffset) {
                    if (range.containsRange(start, offset)) {
                        inside.add(element);
                        insideRanges.add(new ProperTextRange(start, offset));
                    } else {
                        outside.add(element);
                        outsideRanges.add(new ProperTextRange(start, offset));
                    }
                }
                if (elements.isEmpty()) break;
                element = (PsiElement)elements.pop();
                child = (PsiElement)children.pop();
                continue;
            }
            if (offset > endOffset) break;
            children.push(child.getNextSibling());
            starts.push(offset);
            elements.push((PsiFile)element);
            element = child;
            child = HAVE_TO_GET_CHILDREN;
        }
        if (includeParents) {
            PsiElement parent;
            PsiElement psiElement = !outside.isEmpty() ? outside.get(outside.size() - 1) : (parent = !inside.isEmpty() ? inside.get(inside.size() - 1) : CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset));
            while (parent != null && !(parent instanceof PsiFile)) {
                if ((parent = parent.getParent()) == null) continue;
                outside.add(parent);
                TextRange textRange = parent.getTextRange();
                assert (textRange != null) : "Text range for " + parent + " is null. " + parent.getClass() + "; root: " + root + ": " + root.getVirtualFile();
                outsideRanges.add(ProperTextRange.create(textRange));
            }
        }
        assert (inside.size() == insideRanges.size());
        assert (outside.size() == outsideRanges.size());
    }
}

